Uuidm — Universally unique identifiers (UUIDs) for OCaml
-------------------------------------------------------------------------------
%%VERSION%%

Uuidm is an OCaml module implementing 128 bits universally unique
identifiers version 3, 5 (named based with MD5, SHA-1 hashing) and 4
(random based) according to [RFC 4122][rfc4122].

Uuidm has no dependency and is distributed under the ISC license.

[rfc4122]: http://tools.ietf.org/html/rfc4122

Homepage: http://erratique.ch/software/uuidm  

## Installation

Uuidm can be installed with `opam`:

    opam install uuidm

If you don't use `opam` consult the [`opam`](opam) file for build
instructions.


## Documentation

The documentation and API reference is automatically generated by
from the source interfaces. It can be consulted [online][doc].

[doc]: http://erratique.ch/software/uuidm/doc/Uuidm


## Sample programs

If you installed Uuidm with `opam`, it installed the `uuidtrip` binary
that output UUIDs; invoke with `-help` for more information.

In the distribution sample programs are located in the `test`
directory of the distribution. They can be built with:

    ocamlbuild -use-ocamlfind test/tests.otarget

The resulting binaries are in `_build/test`:

- `test.native` tests the library, nothing should fail.
- `perf.native` tests the performance of the library, see `perf.native -help`.
- `uuidtrip.native` outputs UUIDs, see `uuidtrip.native -help`.
