// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportPartialSuccess represents the details of a partially successful export request.
type ExportLogsPartialSuccess struct {
	ErrorMessage       string
	RejectedLogRecords int64
}

var (
	protoPoolExportLogsPartialSuccess = sync.Pool{
		New: func() any {
			return &ExportLogsPartialSuccess{}
		},
	}
)

func NewExportLogsPartialSuccess() *ExportLogsPartialSuccess {
	if !UseProtoPooling.IsEnabled() {
		return &ExportLogsPartialSuccess{}
	}
	return protoPoolExportLogsPartialSuccess.Get().(*ExportLogsPartialSuccess)
}

func DeleteExportLogsPartialSuccess(orig *ExportLogsPartialSuccess, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolExportLogsPartialSuccess.Put(orig)
	}
}

func CopyExportLogsPartialSuccess(dest, src *ExportLogsPartialSuccess) *ExportLogsPartialSuccess {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportLogsPartialSuccess()
	}
	dest.RejectedLogRecords = src.RejectedLogRecords
	dest.ErrorMessage = src.ErrorMessage

	return dest
}

func CopyExportLogsPartialSuccessSlice(dest, src []ExportLogsPartialSuccess) []ExportLogsPartialSuccess {
	var newDest []ExportLogsPartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]ExportLogsPartialSuccess, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportLogsPartialSuccess(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportLogsPartialSuccess(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportLogsPartialSuccessPtrSlice(dest, src []*ExportLogsPartialSuccess) []*ExportLogsPartialSuccess {
	var newDest []*ExportLogsPartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]*ExportLogsPartialSuccess, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportLogsPartialSuccess()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportLogsPartialSuccess(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportLogsPartialSuccess()
		}
	}
	for i := range src {
		CopyExportLogsPartialSuccess(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportLogsPartialSuccess) Reset() {
	*orig = ExportLogsPartialSuccess{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportLogsPartialSuccess) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RejectedLogRecords != int64(0) {
		dest.WriteObjectField("rejectedLogRecords")
		dest.WriteInt64(orig.RejectedLogRecords)
	}
	if orig.ErrorMessage != "" {
		dest.WriteObjectField("errorMessage")
		dest.WriteString(orig.ErrorMessage)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportLogsPartialSuccess) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "rejectedLogRecords", "rejected_log_records":
			orig.RejectedLogRecords = iter.ReadInt64()
		case "errorMessage", "error_message":
			orig.ErrorMessage = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportLogsPartialSuccess) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.RejectedLogRecords != int64(0) {
		n += 1 + proto.Sov(uint64(orig.RejectedLogRecords))
	}

	l = len(orig.ErrorMessage)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ExportLogsPartialSuccess) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RejectedLogRecords != int64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.RejectedLogRecords))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.ErrorMessage)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func (orig *ExportLogsPartialSuccess) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedLogRecords", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.RejectedLogRecords = int64(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ErrorMessage = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportLogsPartialSuccess() *ExportLogsPartialSuccess {
	orig := NewExportLogsPartialSuccess()
	orig.RejectedLogRecords = int64(13)
	orig.ErrorMessage = "test_errormessage"
	return orig
}

func GenTestExportLogsPartialSuccessPtrSlice() []*ExportLogsPartialSuccess {
	orig := make([]*ExportLogsPartialSuccess, 5)
	orig[0] = NewExportLogsPartialSuccess()
	orig[1] = GenTestExportLogsPartialSuccess()
	orig[2] = NewExportLogsPartialSuccess()
	orig[3] = GenTestExportLogsPartialSuccess()
	orig[4] = NewExportLogsPartialSuccess()
	return orig
}

func GenTestExportLogsPartialSuccessSlice() []ExportLogsPartialSuccess {
	orig := make([]ExportLogsPartialSuccess, 5)
	orig[1] = *GenTestExportLogsPartialSuccess()
	orig[3] = *GenTestExportLogsPartialSuccess()
	return orig
}
