// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Mapping describes the mapping of a binary in memory, including its address range, file offset, and metadata like build ID
type Mapping struct {
	AttributeIndices []int32
	MemoryStart      uint64
	MemoryLimit      uint64
	FileOffset       uint64
	FilenameStrindex int32
}

var (
	protoPoolMapping = sync.Pool{
		New: func() any {
			return &Mapping{}
		},
	}
)

func NewMapping() *Mapping {
	if !UseProtoPooling.IsEnabled() {
		return &Mapping{}
	}
	return protoPoolMapping.Get().(*Mapping)
}

func DeleteMapping(orig *Mapping, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolMapping.Put(orig)
	}
}

func CopyMapping(dest, src *Mapping) *Mapping {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewMapping()
	}
	dest.MemoryStart = src.MemoryStart
	dest.MemoryLimit = src.MemoryLimit
	dest.FileOffset = src.FileOffset
	dest.FilenameStrindex = src.FilenameStrindex
	dest.AttributeIndices = append(dest.AttributeIndices[:0], src.AttributeIndices...)

	return dest
}

func CopyMappingSlice(dest, src []Mapping) []Mapping {
	var newDest []Mapping
	if cap(dest) < len(src) {
		newDest = make([]Mapping, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMapping(&dest[i], false)
		}
	}
	for i := range src {
		CopyMapping(&newDest[i], &src[i])
	}
	return newDest
}

func CopyMappingPtrSlice(dest, src []*Mapping) []*Mapping {
	var newDest []*Mapping
	if cap(dest) < len(src) {
		newDest = make([]*Mapping, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMapping()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMapping(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMapping()
		}
	}
	for i := range src {
		CopyMapping(newDest[i], src[i])
	}
	return newDest
}

func (orig *Mapping) Reset() {
	*orig = Mapping{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Mapping) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.MemoryStart != uint64(0) {
		dest.WriteObjectField("memoryStart")
		dest.WriteUint64(orig.MemoryStart)
	}
	if orig.MemoryLimit != uint64(0) {
		dest.WriteObjectField("memoryLimit")
		dest.WriteUint64(orig.MemoryLimit)
	}
	if orig.FileOffset != uint64(0) {
		dest.WriteObjectField("fileOffset")
		dest.WriteUint64(orig.FileOffset)
	}
	if orig.FilenameStrindex != int32(0) {
		dest.WriteObjectField("filenameStrindex")
		dest.WriteInt32(orig.FilenameStrindex)
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}

	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Mapping) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "memoryStart", "memory_start":
			orig.MemoryStart = iter.ReadUint64()
		case "memoryLimit", "memory_limit":
			orig.MemoryLimit = iter.ReadUint64()
		case "fileOffset", "file_offset":
			orig.FileOffset = iter.ReadUint64()
		case "filenameStrindex", "filename_strindex":
			orig.FilenameStrindex = iter.ReadInt32()
		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *Mapping) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.MemoryStart != uint64(0) {
		n += 1 + proto.Sov(uint64(orig.MemoryStart))
	}
	if orig.MemoryLimit != uint64(0) {
		n += 1 + proto.Sov(uint64(orig.MemoryLimit))
	}
	if orig.FileOffset != uint64(0) {
		n += 1 + proto.Sov(uint64(orig.FileOffset))
	}
	if orig.FilenameStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.FilenameStrindex))
	}

	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *Mapping) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.MemoryStart != uint64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.MemoryStart))
		pos--
		buf[pos] = 0x8
	}
	if orig.MemoryLimit != uint64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.MemoryLimit))
		pos--
		buf[pos] = 0x10
	}
	if orig.FileOffset != uint64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FileOffset))
		pos--
		buf[pos] = 0x18
	}
	if orig.FilenameStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FilenameStrindex))
		pos--
		buf[pos] = 0x20
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x2a
	}
	return len(buf) - pos
}

func (orig *Mapping) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryStart", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.MemoryStart = uint64(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryLimit", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.MemoryLimit = uint64(num)

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field FileOffset", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.FileOffset = uint64(num)

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field FilenameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.FilenameStrindex = int32(num)
		case 5:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestMapping() *Mapping {
	orig := NewMapping()
	orig.MemoryStart = uint64(13)
	orig.MemoryLimit = uint64(13)
	orig.FileOffset = uint64(13)
	orig.FilenameStrindex = int32(13)
	orig.AttributeIndices = []int32{int32(0), int32(13)}
	return orig
}

func GenTestMappingPtrSlice() []*Mapping {
	orig := make([]*Mapping, 5)
	orig[0] = NewMapping()
	orig[1] = GenTestMapping()
	orig[2] = NewMapping()
	orig[3] = GenTestMapping()
	orig[4] = NewMapping()
	return orig
}

func GenTestMappingSlice() []Mapping {
	orig := make([]Mapping, 5)
	orig[1] = *GenTestMapping()
	orig[3] = *GenTestMapping()
	return orig
}
