/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.plugin.jdeps;

import com.google.devtools.build.lib.view.proto.Deps;
import io.bazel.kotlin.builder.utils.jars.JarOwner;
import io.bazel.kotlin.plugin.jdeps.BaseJdepsGenExtension;
import io.bazel.kotlin.plugin.jdeps.BaseJdepsGenExtensionKt;
import io.bazel.kotlin.plugin.jdeps.JdepsGenConfigurationKeys;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J(\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002J@\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nH\u0002JF\u0010\u0017\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\u000b2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002J$\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lio/bazel/kotlin/plugin/jdeps/BaseJdepsGenExtension;", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "checkStrictDeps", "", "result", "", "", "", "directDeps", "targetLabel", "createDepsMap", "classes", "", "doStrictDeps", "", "compilerConfiguration", "", "explicitDeps", "doWriteJdeps", "implicitClassesCanonicalPaths", "onAnalysisCompleted", "explicitClassesCanonicalPaths", "src_main_kotlin_io_bazel_kotlin_plugin_jdeps-jdeps-gen-lib"})
public abstract class BaseJdepsGenExtension {
    @NotNull
    private final CompilerConfiguration configuration;

    public BaseJdepsGenExtension(@NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.configuration = configuration;
    }

    @NotNull
    protected final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    protected final void onAnalysisCompleted(@NotNull Set<String> explicitClassesCanonicalPaths, @NotNull Set<String> implicitClassesCanonicalPaths) {
        Intrinsics.checkNotNullParameter(explicitClassesCanonicalPaths, "explicitClassesCanonicalPaths");
        Intrinsics.checkNotNullParameter(implicitClassesCanonicalPaths, "implicitClassesCanonicalPaths");
        List list = this.configuration.getList(JdepsGenConfigurationKeys.INSTANCE.getDIRECT_DEPENDENCIES());
        Intrinsics.checkNotNullExpressionValue(list, "configuration.getList(Jd\u2026Keys.DIRECT_DEPENDENCIES)");
        List directDeps = list;
        Object object = this.configuration.getNotNull(JdepsGenConfigurationKeys.INSTANCE.getTARGET_LABEL());
        Intrinsics.checkNotNullExpressionValue(object, "configuration.getNotNull\u2026urationKeys.TARGET_LABEL)");
        String targetLabel = (String)object;
        Map<String, List<String>> explicitDeps = this.createDepsMap(explicitClassesCanonicalPaths);
        this.doWriteJdeps(directDeps, targetLabel, explicitDeps, implicitClassesCanonicalPaths);
        this.doStrictDeps(this.configuration, targetLabel, directDeps, explicitDeps);
    }

    private final Map<String, List<String>> createDepsMap(Set<String> classes) {
        Map jarsToClasses = new LinkedHashMap();
        Iterable $this$forEach$iv = classes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"!/"};
            List parts = StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null);
            String jarPath = (String)parts.get(0);
            if (!StringsKt.endsWith$default(jarPath, ".jar", false, 2, null)) continue;
            ((List)jarsToClasses.computeIfAbsent(jarPath, createDepsMap.1.1.INSTANCE)).add(parts.get(1));
        }
        return jarsToClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doWriteJdeps(List<String> directDeps, String targetLabel, Map<String, ? extends List<String>> explicitDeps, Set<String> implicitClassesCanonicalPaths) {
        Deps.Dependency.Builder dependency;
        boolean bl;
        Object jarPath;
        Map<String, List<String>> implicitDeps = this.createDepsMap(implicitClassesCanonicalPaths);
        Object object = this.configuration.getNotNull(JdepsGenConfigurationKeys.INSTANCE.getOUTPUT_JDEPS());
        Intrinsics.checkNotNullExpressionValue(object, "configuration.getNotNull\u2026urationKeys.OUTPUT_JDEPS)");
        String jdepsOutput = (String)object;
        Deps.Dependencies.Builder rootBuilder = Deps.Dependencies.newBuilder();
        rootBuilder.setSuccess(true);
        rootBuilder.setRuleLabel(targetLabel);
        Set unusedDeps = CollectionsKt.subtract((Iterable)directDeps, (Iterable)explicitDeps.keySet());
        Object $this$forEach$iv = unusedDeps;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.iterator();
        while (object2.hasNext()) {
            Object t2 = object2.next();
            jarPath = (String)t2;
            bl = false;
            dependency = Deps.Dependency.newBuilder();
            dependency.setKind(Deps.Dependency.Kind.UNUSED);
            dependency.setPath((String)jarPath);
            rootBuilder.addDependency(dependency);
        }
        $this$forEach$iv = explicitDeps;
        $i$f$forEach = false;
        for (Map.Entry entry2 : $this$forEach$iv.entrySet()) {
            jarPath = entry2;
            bl = false;
            String jarPath2 = (String)jarPath.getKey();
            Deps.Dependency.Builder dependency2 = Deps.Dependency.newBuilder();
            dependency2.setKind(Deps.Dependency.Kind.EXPLICIT);
            dependency2.setPath(jarPath2);
            rootBuilder.addDependency(dependency2);
        }
        $this$forEach$iv = CollectionsKt.subtract((Iterable)implicitDeps.keySet(), (Iterable)explicitDeps.keySet());
        $i$f$forEach = false;
        object2 = $this$forEach$iv.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            String it = (String)object3;
            bl = false;
            dependency = Deps.Dependency.newBuilder();
            dependency.setKind(Deps.Dependency.Kind.IMPLICIT);
            dependency.setPath(it);
            rootBuilder.addDependency(dependency);
        }
        Closeable closeable = new BufferedOutputStream(new FileOutputStream(new File(jdepsOutput)));
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)closeable;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(rootBuilder, "rootBuilder");
            it.write(BaseJdepsGenExtensionKt.access$buildSorted(rootBuilder).toByteArray());
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final void doStrictDeps(CompilerConfiguration compilerConfiguration, String targetLabel, List<String> directDeps, Map<String, ? extends List<String>> explicitDeps) {
        switch ((String)compilerConfiguration.getNotNull(JdepsGenConfigurationKeys.INSTANCE.getSTRICT_KOTLIN_DEPS())) {
            case "warn": {
                this.checkStrictDeps(explicitDeps, directDeps, targetLabel);
                break;
            }
            case "error": {
                if (!this.checkStrictDeps(explicitDeps, directDeps, targetLabel)) break;
                throw new IllegalStateException("Strict Deps Violations - please fix".toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkStrictDeps(Map<String, ? extends List<String>> result, List<String> directDeps, String targetLabel) {
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = result.keySet();
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!directDeps.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Path path = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "get(it)");
            object.add(JarOwner.Companion.readJarOwnerFromManifest(path));
        }
        List missingStrictDeps = (List)destination$iv$iv;
        if (!((Collection)missingStrictDeps).isEmpty()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = missingStrictDeps;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                JarOwner it2 = (JarOwner)element$iv$iv;
                boolean bl3 = false;
                if (it2.getLabel() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List missingStrictLabels = (List)destination$iv$iv2;
            String open = "\u001b[35m\u001b[1m";
            String close2 = "\u001b[0m";
            destination$iv$iv2 = missingStrictDeps;
            object = new StringBuilder().append("\n        ").append(open).append(" ** Please add the following dependencies:").append(close2).append("\n        ");
            boolean $i$f$map2 = false;
            $this$forEach$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                JarOwner bl2 = (JarOwner)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl5 = false;
                String string = it3.getLabel();
                collection.add(string != null ? (Comparable)((Object)string) : (Comparable)it3.getJar());
            }
            String command = ((StringBuilder)object).append(CollectionsKt.joinToString$default((List)destination$iv$iv3, " ", null, null, 0, null, null, 62, null)).append(" to ").append(targetLabel).append("\n        ").toString();
            if (!((Collection)missingStrictLabels).isEmpty()) {
                command = command + open + " ** You can use the following buildozer command:" + close2 + "\n        buildozer 'add deps " + CollectionsKt.joinToString$default(missingStrictLabels, " ", null, null, 0, null, null, 62, null) + "' " + targetLabel + "\n        ";
            }
            System.out.println((Object)StringsKt.trimIndent(command));
            return true;
        }
        return false;
    }
}

