# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import Any, Hashable, Iterable, Iterator, Optional, Union

class IOBuf(Hashable):
    def __init__(self, buffer: Union[IOBuf, bytes, bytearray, memoryview]) -> None: ...
    def writable(self) -> bool: ...
    def clone(self) -> IOBuf: ...
    def cloneCoalesced(self) -> IOBuf: ...
    @property
    def next(self) -> Optional[IOBuf]: ...
    @property
    def prev(self) -> Optional[IOBuf]: ...
    @property
    def is_chained(self) -> bool: ...
    def chain_size(self) -> int: ...
    def chain_count(self) -> int: ...
    # Note that this gives you the bytes of the current IOBuf, for the whole IOBuf iterate through it or do b''.join(iobuf)
    def __bytes__(self) -> bytes: ...
    # IOBuf doesn't actually define __buffer__, but it supports buffer protocol; this stub tells typecheckers this fact
    def __buffer__(self, __flags: int) -> memoryview: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> IOBuf: ...
    def __deepcopy__(self) -> IOBuf: ...
    # Note that this gives you the size of the current IOBuf, for the whole IOBuf use chain_size
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[memoryview]: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __lt__(self, other: IOBuf) -> bool: ...
    def __gt__(self, other: IOBuf) -> bool: ...
    def __le__(self, other: IOBuf) -> bool: ...
    def __ge__(self, other: IOBuf) -> bool: ...

class WritableIOBuf(IOBuf):
    def __init__(self, arg: Union[IOBuf, bytearray, memoryview]) -> None: ...
    def writable(self) -> bool: ...
    def capacity(self) -> int: ...
    def length(self) -> int: ...
    def append_to_chain(self, other: WritableIOBuf) -> None: ...
    def coalesce(self) -> None: ...
    def clone(self) -> WritableIOBuf: ...
    def append(self, amount: int) -> None: ...
    def prepend(self, amount: int) -> None: ...
    def trim_start(self, amount: int) -> None: ...
    def trim_end(self, amount: int) -> None: ...
    @property
    def next(self) -> Optional[WritableIOBuf]: ...
    @property
    def prev(self) -> Optional[WritableIOBuf]: ...
    @staticmethod
    def create_unitialized(size: int) -> WritableIOBuf: ...
    def __copy__(self) -> WritableIOBuf: ...
    def __deepcopy__(self) -> WritableIOBuf: ...
