#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "iarray.h"
#include "utils.h"

intarray::intarray(int dummy)
{
	counters = NULL;
	values = NULL;
	nin = 0;
}

intarray::~intarray()
{
	if (counters)
		free(counters);

	if (values)
		free(values);
}

void intarray::setcounter(int index, int value)
{
	counters[index] = value;
}

int intarray::getcounter(int index)
{
	return counters[index];
}

int intarray::addvalue(int value, int defvalue)
{
	int loop;

	for(loop=0; loop<nin; loop++)
	{
		if (values[loop] == value)
		{
			counters[loop]++;
			return loop;
		}
	}

	values  = (int *)myrealloc(values,  sizeof(int)   * (nin + 1), "values array");
	counters = (int *)myrealloc(counters, sizeof(int) * (nin + 1), "counter array");

	values[nin] = value;
	setcounter(nin, defvalue);

	nin++;

	return nin-1;
}

void intarray::sort()
{
	do_sort(0, nin);
}

void intarray::do_sort(int start, int end)
{
	for(int loop=start; loop<(end-1); loop++)
	{
		for(int loop2=loop+1; loop2<end; loop2++)
		{
			if (getcounter(loop) < getcounter(loop2))
			{
				swap_entry(loop, loop2);
			}
		}
	}
}

void intarray::swap_entry(int index1, int index2)
{
	int dummy = values[index1];
	values[index1] = values[index2];
	values[index2] = dummy;

	dummy = getcounter(index1);
	setcounter(index1, getcounter(index2));
	setcounter(index2, dummy);
}
