;based on MUI Welcome/Finish Page Example Script written by Joost Verburg
!define MUI_ICON  ..\src\mole.ico
!define MUI_UNICON  ..\src\mole.ico
!define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_LANGDLL_ALWAYSSHOW
!include "MUI.nsh"
!include "Sections.nsh"
!include "LogicLib.nsh"
!include "StrFunc.nsh"

Name "MoleInvasion"
!define MOLEINVASION_VERSION "0.4"

;General
OutFile "MoleInvasion-Setup-${MOLEINVASION_VERSION}.exe"
!ifndef COMPRESSION
  !define COMPRESSION lzma
!endif
SetCompressor lzma

!define MUI_LANGDLL_REGISTRY_ROOT "HKLM" 
!define MUI_LANGDLL_REGISTRY_KEY "SOFTWARE\GNU\MoleInvasion" 
!define MUI_LANGDLL_REGISTRY_VALUENAME "lang"

;--------------------------------
;Configuration

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE $(MoleInvasionLicense)
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

!define MUI_ABORTWARNING

;Languages
!insertmacro MUI_LANGUAGE "English"
LicenseLangString MoleInvasionLicense "English" "COPYING.en.txt"
LangString TITLE_MoleInvasion "English" "MoleInvasion"
LangString DESC_MoleInvasion  "English" "Installs the game MoleInvasion, version ${MOLEINVASION_VERSION}"

!insertmacro MUI_LANGUAGE "French"
LicenseLangString MoleInvasionLicense "French" "COPYING.fr.txt"
LangString TITLE_MoleInvasion "French" "MoleInvasion"
LangString DESC_MoleInvasion  "French" "Installe le jeu MoleInvasion, en version ${MOLEINVASION_VERSION}"

!insertmacro MUI_LANGUAGE "German"
LicenseLangString MoleInvasionLicense "German" "COPYING.de.txt"
LangString TITLE_MoleInvasion "German" "MoleInvasion"
LangString DESC_MoleInvasion  "German" "Das Spiel MoleInvasion, Version ${MOLEINVASION_VERSION} anbringen"

!insertmacro MUI_LANGUAGE "Spanish"
LicenseLangString MoleInvasionLicense "Spanish" "COPYING.es.txt"
LangString TITLE_MoleInvasion "Spanish" "MoleInvasion"
LangString DESC_MoleInvasion  "Spanish" "Instala el juego MoleInvasion, versin ${MOLEINVASION_VERSION}"

!insertmacro MUI_LANGUAGE "Dutch"
LicenseLangString MoleInvasionLicense "Dutch" "COPYING.nl.txt"
LangString TITLE_MoleInvasion "Dutch" "MoleInvasion"
LangString DESC_MoleInvasion  "Dutch" "MoleInvasion ${MOLEINVASION_VERSION}"

!insertmacro MUI_LANGUAGE "Polish"
LicenseLangString MoleInvasionLicense "Polish" "COPYING.pl.txt"
LangString TITLE_MoleInvasion "Polish" "MoleInvasion"
LangString DESC_MoleInvasion  "Polish" "MoleInvasion ${MOLEINVASION_VERSION}"

!insertmacro MUI_LANGUAGE "Russian"
LicenseLangString MoleInvasionLicense "Russian" "COPYING.ru.txt"
LangString TITLE_MoleInvasion "Russian" "MoleInvasion"
LangString DESC_MoleInvasion  "Russian" "MoleInvasion ${MOLEINVASION_VERSION}"

!insertmacro MUI_LANGUAGE "Slovenian"
LicenseLangString MoleInvasionLicense "Slovenian" "COPYING.sk.txt"
LangString TITLE_MoleInvasion "Slovenian" "MoleInvasion"
LangString DESC_MoleInvasion  "Slovenian" "MoleInvasion ${MOLEINVASION_VERSION}"

;Folder-selection page
InstallDir "$PROGRAMFILES\MoleInvasion"
; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM SOFTWARE\GNU\MoleInvasion "pth"

AutoCloseWindow false

;--------------------------------
;Installer Sections

Section $(TITLE_MoleInvasion) Sec_MoleInvasion
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  File "..\GPL_LICENSE.txt"
  SetOutPath $INSTDIR\win
  File "..\src\mole.ico"
  File "..\win\moleinvasion.exe"
  File "..\win\editor.exe"
  File "..\win\editworld.exe"
  File "..\win\*.dll"
  SetOutPath $INSTDIR\font
  File "..\font\*.ttf"
  File "..\font\*.txt"
  SetOutPath $INSTDIR\snd
  File "..\snd\*.ogg"
  SetOutPath $INSTDIR\music
  File /nonfatal "..\music\*.ogg"
  SetOutPath $INSTDIR\txt
  File "..\txt\*.txt"

  ; find . -type d  | grep -v ".svn" | sort | while read a; do a=${a//\.\/}; echo -e "  SetOutPath \$INSTDIR\\lvl\\$a\n  File \"..\\lvl\\$a\*.lvl\"\n  File \"..\lvl\\$a\world.wld\""; done
  SetOutPath $INSTDIR\lvl\mole_hill
  File "..\lvl\mole_hill\*.lvl"
  File "..\lvl\mole_hill\world.wld"
  SetOutPath $INSTDIR\lvl\sandisland
  File "..\lvl\sandisland\*.lvl"
  File "..\lvl\sandisland\world.wld"
  SetOutPath $INSTDIR\lvl\supertux_revisited
  File "..\lvl\supertux_revisited\*.lvl"
  File "..\lvl\supertux_revisited\world.wld"
  SetOutPath $INSTDIR\lvl\tux_strikes_back
  File "..\lvl\tux_strikes_back\*.lvl"
  File "..\lvl\tux_strikes_back\world.wld"
  
  ; find . -type d  | grep -v ".svn" | sort | while read a;do echo -e "  SetOutPath \$INSTDIR/gfx/${a:2}\n  File \"../gfx/${a:2}/*.*\""; done | sed "s#/#\\\#g"
  SetOutPath $INSTDIR\gfx
  File "..\gfx\\*.*"
  SetOutPath $INSTDIR\gfx\arbre
  File "..\gfx\arbre\*.*"
  SetOutPath $INSTDIR\gfx\backgrounds
  File "..\gfx\backgrounds\*.*"
  SetOutPath $INSTDIR\gfx\backgrounds\castle
  File "..\gfx\backgrounds\castle\*.*"
  SetOutPath $INSTDIR\gfx\backgrounds\cave
  File "..\gfx\backgrounds\cave\*.*"
  SetOutPath $INSTDIR\gfx\backgrounds\country
  File "..\gfx\backgrounds\country\*.*"
  SetOutPath $INSTDIR\gfx\backgrounds\desert
  File "..\gfx\backgrounds\desert\*.*"
  SetOutPath $INSTDIR\gfx\backgrounds\sea
  File "..\gfx\backgrounds\sea\*.*"
  SetOutPath $INSTDIR\gfx\backgrounds\volcano
  File "..\gfx\backgrounds\volcano\*.*"
  SetOutPath $INSTDIR\gfx\bois-c
  File "..\gfx\bois-c\*.*"
  SetOutPath $INSTDIR\gfx\bois-p
  File "..\gfx\bois-p\*.*"
  SetOutPath $INSTDIR\gfx\bomby
  File "..\gfx\bomby\*.*"
  SetOutPath $INSTDIR\gfx\boulet
  File "..\gfx\boulet\*.*"
  SetOutPath $INSTDIR\gfx\box-chrono
  File "..\gfx\box-chrono\*.*"
  SetOutPath $INSTDIR\gfx\box-coin1
  File "..\gfx\box-coin1\*.*"
  SetOutPath $INSTDIR\gfx\box-coin10
  File "..\gfx\box-coin10\*.*"
  SetOutPath $INSTDIR\gfx\box-gem
  File "..\gfx\box-gem\*.*"
  SetOutPath $INSTDIR\gfx\box-potion
  File "..\gfx\box-potion\*.*"
  SetOutPath $INSTDIR\gfx\box-sac
  File "..\gfx\box-sac\*.*"
  SetOutPath $INSTDIR\gfx\coin
  File "..\gfx\coin\*.*"
  SetOutPath $INSTDIR\gfx\coin10
  File "..\gfx\coin10\*.*"
  SetOutPath $INSTDIR\gfx\explobomb
  File "..\gfx\explobomb\*.*"
  SetOutPath $INSTDIR\gfx\explosion
  File "..\gfx\explosion\*.*"
  SetOutPath $INSTDIR\gfx\flymole
  File "..\gfx\flymole\*.*"
  SetOutPath $INSTDIR\gfx\flymole_h
  File "..\gfx\flymole_h\*.*"
  SetOutPath $INSTDIR\gfx\gem
  File "..\gfx\gem\*.*"
  SetOutPath $INSTDIR\gfx\hammer
  File "..\gfx\hammer\*.*"
  SetOutPath $INSTDIR\gfx\herbe1
  File "..\gfx\herbe1\*.*"
  SetOutPath $INSTDIR\gfx\ihm
  File "..\gfx\ihm\*.*"
  SetOutPath $INSTDIR\gfx\imo_shell
  File "..\gfx\imo_shell\*.*"
  SetOutPath $INSTDIR\gfx\mov_shell
  File "..\gfx\mov_shell\*.*"
  SetOutPath $INSTDIR\gfx\pierro
  File "..\gfx\pierro\*.*"
  SetOutPath $INSTDIR\gfx\potion
  File "..\gfx\potion\*.*"
  SetOutPath $INSTDIR\gfx\sp57
  File "..\gfx\sp57\*.*"
  SetOutPath $INSTDIR\gfx\sp58
  File "..\gfx\sp58\*.*"
  SetOutPath $INSTDIR\gfx\sp59
  File "..\gfx\sp59\*.*"
  SetOutPath $INSTDIR\gfx\sp60
  File "..\gfx\sp60\*.*"
  SetOutPath $INSTDIR\gfx\sp61
  File "..\gfx\sp61\*.*"
  SetOutPath $INSTDIR\gfx\sp72
  File "..\gfx\sp72\*.*"
  SetOutPath $INSTDIR\gfx\sp73
  File "..\gfx\sp73\*.*"
  SetOutPath $INSTDIR\gfx\sp77
  File "..\gfx\sp77\*.*"
  SetOutPath $INSTDIR\gfx\sp82
  File "..\gfx\sp82\*.*"
  SetOutPath $INSTDIR\gfx\sprite1
  File "..\gfx\sprite1\*.*"
  SetOutPath $INSTDIR\gfx\sprite2
  File "..\gfx\sprite2\*.*"
  SetOutPath $INSTDIR\gfx\sprite3
  File "..\gfx\sprite3\*.*"
  SetOutPath $INSTDIR\gfx\sprite4
  File "..\gfx\sprite4\*.*"
  SetOutPath $INSTDIR\gfx\sprite5
  File "..\gfx\sprite5\*.*"
  SetOutPath $INSTDIR\gfx\tortoise
  File "..\gfx\tortoise\*.*"
  SetOutPath $INSTDIR\gfx\video
  File "..\gfx\video\*.*"
  SetOutPath $INSTDIR\gfx\wall-01
  File "..\gfx\wall-01\*.*"
  SetOutPath $INSTDIR\gfx\wall-02
  File "..\gfx\wall-02\*.*"
  SetOutPath $INSTDIR\gfx\wall-03
  File "..\gfx\wall-03\*.*"
  SetOutPath $INSTDIR\gfx\wall-04
  File "..\gfx\wall-04\*.*"
  SetOutPath $INSTDIR\gfx\wall-05
  File "..\gfx\wall-05\*.*"
  SetOutPath $INSTDIR\gfx\wall-06
  File "..\gfx\wall-06\*.*"
  SetOutPath $INSTDIR\gfx\wall-07
  File "..\gfx\wall-07\*.*"
  SetOutPath $INSTDIR\gfx\wall-08
  File "..\gfx\wall-08\*.*"
  SetOutPath $INSTDIR\gfx\wall-09
  File "..\gfx\wall-09\*.*"
  SetOutPath $INSTDIR\gfx\wall-10
  File "..\gfx\wall-10\*.*"
  SetOutPath $INSTDIR\gfx\wall-11
  File "..\gfx\wall-11\*.*"
  SetOutPath $INSTDIR\gfx\wall-12
  File "..\gfx\wall-12\*.*"
  SetOutPath $INSTDIR\gfx\wall-13
  File "..\gfx\wall-13\*.*"
  SetOutPath $INSTDIR\gfx\wall-14
  File "..\gfx\wall-14\*.*"

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\GNU\MoleInvasion "pth" "$INSTDIR"
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MoleInvasion" "DisplayName" "MoleInvasion (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MoleInvasion" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteUninstaller "uninstall.exe"
  ; Shortcuts
  SetOutPath $INSTDIR\win
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\MoleInvasion"
  CreateShortCut  "$SMPROGRAMS\MoleInvasion\MoleInvasion.lnk" "$INSTDIR\win\moleinvasion.exe" "-f" "$INSTDIR\win\moleinvasion.exe" 0
  CreateShortCut  "$SMPROGRAMS\MoleInvasion\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  ;Write language to the registry (for the uninstaller)
  WriteRegStr HKLM SOFTWARE\GNU\MoleInvasion "Installer Language" $LANGUAGE

;  GetFullPathName /SHORT $SHORTINSTDIR $INSTDIR
SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${Sec_MoleInvasion} $(DESC_MoleInvasion)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"
  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MoleInvasion"
  DeleteRegKey HKLM SOFTWARE\GNU\MoleInvasion
  DeleteRegKey HKCU SOFTWARE\GNU\MoleInvasion
  ; remove shortcuts, if any.
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\MoleInvasion"
  RMDir /r $INSTDIR\font
  RMDir /r $INSTDIR\gfx
  RMDir /r $INSTDIR\lvl
  RMDir /r $INSTDIR\music
  RMDir /r $INSTDIR\snd
  RMDir /r $INSTDIR\txt
  RMDir /r $INSTDIR\win
  Delete $INSTDIR\GPL_LICENSE.txt
  Delete $INSTDIR\uninstall.exe
  RMDir $INSTDIR

  ;  !insertmacro MUI_UNFINISHHEADER
SectionEnd

Function .onInit

  ;Language selection

  !insertmacro MUI_LANGDLL_DISPLAY

  SectionSetFlags ${Sec_MoleInvasion} 17

FunctionEnd

Function un.onInit
  !insertmacro MUI_UNGETLANGUAGE
FunctionEnd