/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.mavendeptree.dependenciesresults;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MavenDependencyNode {
    private final Set<String> children = new HashSet<String>();
    private final Set<String> configurations = new HashSet<String>();
    private final Set<String> types = new HashSet<String>();
    private String classifier;

    public MavenDependencyNode(String configuration, String type, String classifier) {
        if (configuration != null) {
            this.configurations.add(configuration);
        }
        if (type != null) {
            this.types.add(type);
        }
        if (classifier != null) {
            this.setClassifier(classifier);
        }
    }

    public void addChild(String childName) {
        this.children.add(childName);
    }

    public void addConfiguration(String configuration) {
        this.configurations.add(configuration);
    }

    public void addType(String type) {
        this.types.add(type);
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public int hashCode() {
        return Objects.hash(this.children, this.configurations, this.types, this.classifier);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MavenDependencyNode other = (MavenDependencyNode)obj;
        return this.children.equals(other.children) && this.configurations.equals(other.configurations) && Objects.equals(this.classifier, other.classifier);
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public Set<String> getConfigurations() {
        return this.configurations;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public MavenDependencyNode() {
    }
}

