/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpVariableNameInfo;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.psi.HttpVisitor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.tree.util.AstUtilKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002\u00a8\u0006\u0012"}, d2={"computeDeclaredVariablesForFile", "Lcom/intellij/util/containers/MultiMap;", "", "", "file", "Lcom/intellij/psi/PsiFile;", "collectVariableNamesForRequest", "", "Lcom/intellij/httpClient/http/request/HttpVariableNameInfo;", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "retrieveHttpVariableIdentifier", "Lcom/intellij/psi/PsiElement;", "variable", "Lcom/intellij/httpClient/http/request/psi/HttpVariable;", "isDynamicVariable", "", "variableName", "intellij.httpClient.lang"})
@SourceDebugExtension(value={"SMAP\nHttpRequestPsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestPsiUtils.kt\ncom/intellij/httpClient/http/request/HttpRequestPsiUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,86:1\n1567#2:87\n1598#2,4:88\n183#3,2:92\n*S KotlinDebug\n*F\n+ 1 HttpRequestPsiUtils.kt\ncom/intellij/httpClient/http/request/HttpRequestPsiUtilsKt\n*L\n64#1:87\n64#1:88,4\n73#1:92,2\n*E\n"})
public final class HttpRequestPsiUtilsKt {
    @NotNull
    public static final MultiMap<String, Integer> computeDeclaredVariablesForFile(@NotNull PsiFile file) {
        MultiMap multiMap;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof HttpRequestPsiFile)) {
            MultiMap multiMap2 = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"empty(...)");
            return multiMap2;
        }
        MultiMap $this$computeDeclaredVariablesForFile_u24lambda_u240 = multiMap = MultiMap.createLinked();
        boolean bl = false;
        PsiElement psiElement = ((HttpRequestPsiFile)file).getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        for (PsiElement element : PsiTreeUtilKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null)) {
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof HttpFileVariable) {
                String name = ((HttpFileVariable)element).getName();
                CharSequence charSequence = name;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                $this$computeDeclaredVariablesForFile_u24lambda_u240.putValue((Object)name, (Object)((HttpFileVariable)element).getTextOffset());
                continue;
            }
            if (!(psiElement2 instanceof HttpRequestBlock)) continue;
            for (HttpFileVariable variable : ((HttpRequestBlock)element).getFileVariableList()) {
                String name = variable.getName();
                CharSequence charSequence = name;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                $this$computeDeclaredVariablesForFile_u24lambda_u240.putValue((Object)name, (Object)variable.getTextOffset());
            }
        }
        MultiMap multiMap3 = multiMap;
        Intrinsics.checkNotNullExpressionValue((Object)multiMap3, (String)"apply(...)");
        return multiMap3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HttpVariableNameInfo> collectVariableNamesForRequest(@NotNull HttpRequest request) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List names = new ArrayList();
        HttpVisitor value2 = new HttpVisitor(names){
            final /* synthetic */ List<String> $names;
            {
                this.$names = $names;
            }

            public void visitVariable(HttpVariable o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitVariable(o);
                String string = o.getName();
                if (string == null) {
                    return;
                }
                String name = string;
                this.$names.add(name);
            }

            /*
             * WARNING - void declaration
             */
            public void visitMessageBody(HttpMessageBody o) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitMessageBody(o);
                String text2 = o.getText();
                List<TextRange> list2 = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(text2);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"collectVariablesRangesInMessageBody(...)");
                List<TextRange> ranges = list2;
                Iterable iterable = ranges;
                List<String> list3 = this.$names;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TextRange range = (TextRange)element$iv;
                    boolean bl = false;
                    String string = HttpRequestPsiUtils.getVariableName(text2, range);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVariableName(...)");
                    list3.add(string);
                }
            }

            public void visitRequestCompositeElement(HttpRequestCompositeElement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                for (PsiElement child : o.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        };
        request.accept(value2);
        Iterable $this$mapIndexed$iv = names;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void name;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HttpVariableNameInfo((String)name, (int)index));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PsiElement retrieveHttpVariableIdentifier(@NotNull HttpVariable variable) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            ASTNode aSTNode = variable.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
            Sequence $this$firstOrNull$iv = AstUtilKt.children((ASTNode)aSTNode);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode element = (ASTNode)element$iv;
                boolean bl = false;
                IElementType[] iElementTypeArray = new IElementType[]{HttpRequestElementTypes.VARIABLE_EXPRESSION};
                if (!HttpRequestPsiUtils.isOfTypes(element.getPsi(), TokenSet.create((IElementType[])iElementTypeArray))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        ASTNode aSTNode = v1;
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    public static final boolean isDynamicVariable(@NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        String string = HttpRequestElementTypes.DYNAMIC_SIGN.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String dynamicSign = string;
        String variable = ((Object)StringsKt.trim((CharSequence)variableName)).toString();
        if (Intrinsics.areEqual((Object)variable, (Object)dynamicSign)) {
            return true;
        }
        Regex regexp = new Regex("\\$ *\\w+");
        return regexp.matchesAt((CharSequence)variable, 0);
    }
}

