/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.run.HttpClientJsonVariablesHelperKt;
import com.intellij.httpClient.jsonPath.WrapVariableFix;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/jsonPath/HttpRequestJsonBodyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isAllowedToken", "element", "Lcom/intellij/psi/PsiElement;", "value", "", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientJsonBodyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientJsonBodyInspection.kt\ncom/intellij/httpClient/jsonPath/HttpRequestJsonBodyInspection\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n19#2:94\n1863#3,2:95\n*S KotlinDebug\n*F\n+ 1 HttpClientJsonBodyInspection.kt\ncom/intellij/httpClient/jsonPath/HttpRequestJsonBodyInspection\n*L\n28#1:94\n34#1:95,2\n*E\n"})
public final class HttpRequestJsonBodyInspection
extends LocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $this$forEach$iv;
        PsiLanguageInjectionHost psiLanguageInjectionHost;
        InjectedLanguageManager injectedManager;
        Project project;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                Project project2 = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                injectedManager = InjectedLanguageManager.getInstance((Project)project);
                psiLanguageInjectionHost = injectedManager.getInjectionHost((PsiElement)file);
                if (psiLanguageInjectionHost == null) break block5;
                PsiLanguageInjectionHost $this$asSafely$iv = psiLanguageInjectionHost;
                boolean $i$f$asSafely = false;
                PsiLanguageInjectionHost psiLanguageInjectionHost2 = $this$asSafely$iv;
                if (!(psiLanguageInjectionHost2 instanceof HttpMessageBody)) {
                    psiLanguageInjectionHost2 = null;
                }
                if ((psiLanguageInjectionHost = (HttpMessageBody)psiLanguageInjectionHost2) != null) break block6;
            }
            return new ProblemDescriptor[0];
        }
        PsiLanguageInjectionHost host = psiLanguageInjectionHost;
        PsiFile httpFile = host.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(manager, httpFile, isOnTheFly);
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.getDefault(project, httpFile);
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"getDefault(...)");
        HttpRequestVariableSubstitutor defaultSubstitutor = httpRequestVariableSubstitutor;
        List<TextRange> list2 = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(host.getText());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"collectVariablesRangesInMessageBody(...)");
        Iterable $i$f$asSafely = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String value2;
            String variableName;
            PsiElement injectedElement;
            TextRange rangeInFile;
            TextRange range = (TextRange)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)range.shiftRight(host.getTextRange().getStartOffset()), (String)"shiftRight(...)");
            if (injectedManager.findInjectedElementAt(httpFile, rangeInFile.getStartOffset()) == null) continue;
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)injectedElement);
            if (Intrinsics.areEqual((Object)(iElementType != null ? iElementType.getDebugName() : null), (Object)JsonElementTypes.DOUBLE_QUOTED_STRING.getDebugName())) continue;
            Intrinsics.checkNotNullExpressionValue((Object)HttpRequestPsiUtils.getVariableName(host.getText(), range), (String)"getVariableName(...)");
            if (defaultSubstitutor.getVariableValue(variableName, null, project, null) == null || this.isAllowedToken(injectedElement, value2)) continue;
            PsiElement psiElement = (PsiElement)host;
            String string = RestClientBundle.message("http.client.code.style.inspection.add.wrap.with.quotes", new Object[0]);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            PsiElement psiElement2 = (PsiElement)host;
            String string2 = range.substring(host.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            localQuickFixArray[0] = new WrapVariableFix(psiElement2, rangeInFile, string2);
            holder.registerProblem(psiElement, string, ProblemHighlightType.WEAK_WARNING, range, localQuickFixArray);
        }
        return holder.getResultsArray();
    }

    private final boolean isAllowedToken(PsiElement element, String value2) {
        JsonProperty jsonProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
        Object nameElement = jsonProperty != null ? jsonProperty.getNameElement() : null;
        PsiElement child = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)nameElement), element.getClass());
        if (Intrinsics.areEqual((Object)child, (Object)element)) {
            return false;
        }
        JsonNode jsonNode = HttpClientJsonVariablesHelperKt.readTreeSafe(value2);
        if (jsonNode == null) {
            return false;
        }
        JsonNode jsonElement = jsonNode;
        return jsonElement.isNumber() || jsonElement.isBoolean();
    }
}

