/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.commonjs;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import com.oracle.truffle.js.builtins.commonjs.GlobalCommonJSRequireBuiltins;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.nio.file.LinkOption;
import java.util.Map;

public abstract class CommonJSModuleGetterBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    private final GlobalCommonJSRequireBuiltins.GlobalRequire getter;

    CommonJSModuleGetterBuiltin(JSContext context2, JSBuiltin builtin, GlobalCommonJSRequireBuiltins.GlobalRequire getter) {
        super(context2, builtin);
        this.getter = getter;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Object getObject() {
        try {
            switch (this.getter) {
                case globalModuleGetter: {
                    return CommonJSModuleGetterBuiltin.getOrCreateModuleObject(this.getContext(), this.getRealm());
                }
                case globalExportsGetter: {
                    return JSObject.get(CommonJSModuleGetterBuiltin.getOrCreateModuleObject(this.getContext(), this.getRealm()), Strings.EXPORTS_PROPERTY_NAME);
                }
                case filenameGetter: {
                    return this.getCurrentFileName();
                }
                case dirnameGetter: {
                    return this.getCurrentFolderName();
                }
            }
            throw Errors.shouldNotReachHere();
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException ex) {
            throw Errors.createErrorFromException(ex);
        }
    }

    private static JSDynamicObject getOrCreateModuleObject(JSContext context2, JSRealm realm) {
        CompilerAsserts.neverPartOfCompilation();
        String filePath = CommonJSResolution.getCurrentFileNameFromStack();
        if (filePath != null) {
            TruffleFile truffleFile = realm.getEnv().getPublicTruffleFile(filePath);
            assert (truffleFile.isRegularFile(new LinkOption[0]));
            Map<TruffleFile, JSDynamicObject> requireCache = realm.getCommonJSRequireCache();
            JSDynamicObject cached = requireCache.get(truffleFile);
            if (cached != null) {
                return cached;
            }
            JSObject moduleObject = CommonJSModuleGetterBuiltin.createModuleObject(context2, realm);
            requireCache.put(truffleFile, moduleObject);
            return moduleObject;
        }
        return CommonJSModuleGetterBuiltin.createModuleObject(context2, realm);
    }

    private static JSObject createModuleObject(JSContext context2, JSRealm realm) {
        JSObject moduleObject = JSOrdinary.create(context2, realm);
        JSObject exportsObject = JSOrdinary.create(context2, realm);
        JSObject.set((JSDynamicObject)moduleObject, Strings.EXPORTS_PROPERTY_NAME, (Object)exportsObject);
        return moduleObject;
    }

    private TruffleString getCurrentFileName() {
        CompilerAsserts.neverPartOfCompilation();
        String filePath = CommonJSResolution.getCurrentFileNameFromStack();
        if (filePath != null) {
            TruffleFile truffleFile = this.getRealm().getEnv().getPublicTruffleFile(filePath);
            assert (truffleFile.isRegularFile(new LinkOption[0]));
            return Strings.fromJavaString(truffleFile.normalize().toString());
        }
        return Strings.UNKNOWN;
    }

    private TruffleString getCurrentFolderName() {
        CompilerAsserts.neverPartOfCompilation();
        String filePath = CommonJSResolution.getCurrentFileNameFromStack();
        JSRealm realm = this.getRealm();
        TruffleLanguage.Env env = realm.getEnv();
        if (filePath != null) {
            TruffleFile truffleFile = env.getPublicTruffleFile(filePath);
            assert (truffleFile.isRegularFile(new LinkOption[0]) && truffleFile.getParent().isDirectory(new LinkOption[0]));
            return Strings.fromJavaString(truffleFile.getParent().normalize().toString());
        }
        return Strings.fromJavaString(CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(realm, env).getAbsoluteFile().toString());
    }
}

