/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.errors.JsErrorMessages;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.List;
import java.util.Map;

public final class JSRegexLexer
extends RegexLexer {
    private static final CodePointSet ID_START = UnicodeProperties.getProperty("ID_Start").union(CodePointSet.createNoDedup(36, 36, 95, 95));
    private static final CodePointSet ID_CONTINUE = UnicodeProperties.getProperty("ID_Continue").union(CodePointSet.createNoDedup(36, 36, 8204, 8205));
    private static final TBitSet SYNTAX_CHARS = TBitSet.valueOf(36, 40, 41, 42, 43, 46, 47, 63, 91, 92, 93, 94, 123, 124, 125);
    private static final TBitSet CLASS_SET_SYNTAX_CHARS = TBitSet.valueOf(40, 41, 45, 47, 91, 92, 93, 123, 124, 125);
    private static final TBitSet CLASS_SET_RESERVED_PUNCTUATORS = TBitSet.valueOf(33, 35, 37, 38, 44, 45, 58, 59, 60, 61, 62, 64, 96, 126);
    private static final TBitSet CLASS_SET_RESERVED_DOUBLE_PUNCTUATORS = TBitSet.valueOf(33, 35, 36, 37, 38, 42, 43, 44, 46, 58, 59, 60, 61, 62, 63, 64, 94, 96, 126);
    private final RegexFlags flags;

    public JSRegexLexer(RegexSource source, RegexFlags flags, CompilationBuffer compilationBuffer) {
        super(source, compilationBuffer);
        this.flags = flags;
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return this.flags.isIgnoreCase();
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return false;
    }

    @Override
    protected boolean featureEnabledZLowerCaseAssertion() {
        return false;
    }

    @Override
    protected boolean featureEnabledWordBoundaries() {
        return true;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return false;
    }

    @Override
    protected boolean featureEnabledPossessiveQuantifiers() {
        return false;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        return false;
    }

    @Override
    protected boolean featureEnabledNestedCharClasses() {
        return false;
    }

    @Override
    protected boolean featureEnabledPOSIXCharClasses() {
        return false;
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return true;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledIgnoreWhiteSpace() {
        return false;
    }

    @Override
    protected TBitSet getWhitespace() {
        return DEFAULT_WHITESPACE;
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return !this.flags.isEitherUnicode();
    }

    @Override
    protected boolean featureEnabledSpecialGroups() {
        return true;
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return this.flags.isEitherUnicode();
    }

    @Override
    protected boolean featureEnabledClassSetExpressions() {
        return this.flags.isUnicodeSets();
    }

    @Override
    protected void caseFoldUnfold(CodePointSetAccumulator charClass) {
        CaseFoldData.CaseFoldUnfoldAlgorithm caseFolding = this.flags.isEitherUnicode() ? CaseFoldData.CaseFoldUnfoldAlgorithm.ECMAScriptUnicode : CaseFoldData.CaseFoldUnfoldAlgorithm.ECMAScriptNonUnicode;
        CodePointSetAccumulator tmp = this.compilationBuffer.getCodePointSetAccumulator1();
        CaseFoldData.applyCaseFoldUnfold(charClass, tmp, caseFolding);
    }

    @Override
    protected CodePointSet complementClassSet(CodePointSet codePointSet) {
        if (this.flags.isUnicodeSets() && this.flags.isIgnoreCase()) {
            return codePointSet.createInverse(CaseFoldData.FOLDED_CHARACTERS, this.compilationBuffer);
        }
        return codePointSet.createInverse(this.source.getEncoding());
    }

    @Override
    protected ClassSetContents caseFoldClassSetAtom(ClassSetContents classSetContents) {
        if (this.flags.isUnicodeSets() && this.flags.isIgnoreCase()) {
            return classSetContents.caseFold(this.compilationBuffer.getCodePointSetAccumulator1());
        }
        return classSetContents;
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.flags.isDotAll() ? Constants.DOT_ALL : Constants.DOT;
    }

    @Override
    protected CodePointSet getIdContinue() {
        return ID_CONTINUE;
    }

    @Override
    protected CodePointSet getIdStart() {
        return ID_START;
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        switch (c) {
            case 's': {
                if (this.source.getOptions().isU180EWhitespace()) {
                    return Constants.LEGACY_WHITE_SPACE;
                }
                return Constants.WHITE_SPACE;
            }
            case 'S': {
                if (this.source.getOptions().isU180EWhitespace()) {
                    return Constants.LEGACY_NON_WHITE_SPACE;
                }
                return Constants.NON_WHITE_SPACE;
            }
            case 'd': {
                return Constants.DIGITS;
            }
            case 'D': {
                return Constants.NON_DIGITS;
            }
            case 'w': {
                if (this.flags.isUnicodeSets() && this.flags.isIgnoreCase()) {
                    return Constants.WORD_CHARS_UNICODE_SETS_IGNORE_CASE;
                }
                if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                    return Constants.WORD_CHARS_UNICODE_IGNORE_CASE;
                }
                return Constants.WORD_CHARS;
            }
            case 'W': {
                if (this.flags.isUnicodeSets() && this.flags.isIgnoreCase()) {
                    return Constants.NON_WORD_CHARS_UNICODE_SETS_IGNORE_CASE;
                }
                if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                    return Constants.NON_WORD_CHARS_UNICODE_IGNORE_CASE;
                }
                return Constants.NON_WORD_CHARS;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void checkClassSetCharacter(int codePoint) throws RegexSyntaxException {
        String punctuator;
        if (CLASS_SET_SYNTAX_CHARS.get(codePoint)) {
            throw this.syntaxError(JsErrorMessages.unexpectedCharacterInClassSet(codePoint));
        }
        if (CLASS_SET_RESERVED_DOUBLE_PUNCTUATORS.get(codePoint) && this.lookahead(punctuator = Character.toString(codePoint))) {
            throw this.syntaxError(JsErrorMessages.unexpectedDoublePunctuatorInClassSet(punctuator));
        }
    }

    @Override
    protected long boundedQuantifierMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxError("Numbers out of order in {} quantifier");
    }

    @Override
    protected Token handleBoundedQuantifierSyntaxError() throws RegexSyntaxException {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Incomplete quantifier");
        }
        this.position = this.getLastTokenPosition() + 1;
        return this.literalChar(123);
    }

    @Override
    protected Token handleBoundedQuantifierOverflow(long min, long max) {
        return null;
    }

    @Override
    protected Token handleBoundedQuantifierOverflowMin(long min, long max) {
        return null;
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int startPos) {
        return this.syntaxError("Range out of order in character class");
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int startPos, ClassSetContents firstAtom, ClassSetContents secondAtom) {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Invalid character class");
        }
    }

    @Override
    protected CodePointSet getPOSIXCharClass(String name) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXCollationElement(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXEquivalenceClass(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleComplementOfStringSet() {
        return this.syntaxError(JsErrorMessages.invalidRegularExpression(this.source, "Negated character class may contain strings"));
    }

    @Override
    protected RegexSyntaxException handleEmptyGroupName() {
        return this.syntaxError("Empty named capture group name");
    }

    @Override
    protected void handleGroupRedefinition(String name, int newId, int oldId) {
    }

    @Override
    protected void handleIncompleteEscapeX() {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Invalid escape");
        }
    }

    @Override
    protected void handleInvalidBackReference(int reference) {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Missing capture group for backreference");
        }
    }

    @Override
    protected void handleInvalidBackReference(String reference) {
        throw this.syntaxError("Missing capture group for backreference");
    }

    @Override
    protected RegexSyntaxException handleInvalidCharInCharClass() {
        throw this.syntaxError("Invalid character in character class");
    }

    private int handleInvalidEscape(int c) {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Invalid escape");
        }
        return c;
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        return this.syntaxError("Invalid group");
    }

    @Override
    protected RegexSyntaxException handleMixedClassSetOperators(RegexLexer.ClassSetOperator leftOperator, RegexLexer.ClassSetOperator rightOperator) {
        return this.syntaxError(JsErrorMessages.mixedOperatorsInClassSet(leftOperator, rightOperator));
    }

    @Override
    protected RegexSyntaxException handleMissingClassSetOperand(RegexLexer.ClassSetOperator operator) {
        return this.syntaxError(JsErrorMessages.missingClassSetOperand(operator));
    }

    @Override
    protected void handleOctalOutOfRange() {
    }

    @Override
    protected RegexSyntaxException handleRangeAsClassSetOperand(RegexLexer.ClassSetOperator operator) {
        return this.syntaxError(JsErrorMessages.rangeAsClassSetOperand(operator));
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw this.syntaxError("Ends with an unfinished escape sequence");
    }

    @Override
    protected void handleUnfinishedGroupComment() {
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        return this.syntaxError("Invalid group");
    }

    @Override
    protected RegexSyntaxException handleUnfinishedRangeInClassSet() {
        return this.syntaxError("Unterminated character range");
    }

    @Override
    protected void handleUnmatchedRightBrace() {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Unmatched '}'");
        }
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxError("Unterminated character class");
    }

    @Override
    protected void handleUnmatchedRightBracket() {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Unmatched ']'");
        }
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        if (this.consumingLookahead("\\u")) {
            int unicodeEscape = this.parseUnicodeEscapeChar(true);
            if (unicodeEscape < 0) {
                throw this.syntaxError("Invalid Unicode escape");
            }
            return unicodeEscape;
        }
        int c = this.consumeChar();
        return Character.isHighSurrogate((char)c) ? this.finishSurrogatePair((char)c) : c;
    }

    private String jsParseGroupName() {
        RegexLexer.ParseGroupNameResult result2 = this.parseGroupName('>');
        switch (result2.state) {
            case empty: {
                throw this.handleEmptyGroupName();
            }
            case unterminated: {
                throw this.syntaxError("Unterminated group name");
            }
            case invalidStart: {
                throw this.syntaxError("Invalid character at start of group name");
            }
            case invalidRest: {
                throw this.syntaxError("Invalid character in group name");
            }
            case valid: {
                return result2.groupName;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseCustomEscape(char c) {
        if (c == 'k') {
            if (this.flags.isEitherUnicode() || this.hasNamedCaptureGroups()) {
                if (this.atEnd()) {
                    this.handleUnfinishedEscape();
                }
                if (this.consumeChar() != '<') {
                    throw this.syntaxError("Missing group name in named capture group reference");
                }
                String groupName = this.jsParseGroupName();
                if (this.namedCaptureGroups != null && this.namedCaptureGroups.containsKey(groupName)) {
                    return Token.createBackReference(((List)this.namedCaptureGroups.get(groupName)).stream().mapToInt(x -> x).toArray(), false);
                }
                Map<String, List<Integer>> allNamedCaptureGroups = this.getNamedCaptureGroups();
                if (allNamedCaptureGroups != null && allNamedCaptureGroups.containsKey(groupName)) {
                    return Token.createBackReference(allNamedCaptureGroups.get(groupName).stream().mapToInt(x -> x).toArray(), false);
                }
                this.handleInvalidBackReference(groupName);
            } else {
                return this.literalChar(c);
            }
        }
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        switch (c) {
            case 48: {
                if (this.flags.isEitherUnicode() && this.lookahead(RegexLexer::isDecimalDigit, 1)) {
                    throw this.syntaxError("Invalid escape");
                }
                if (!this.flags.isEitherUnicode() && this.lookahead(RegexLexer::isOctalDigit, 1)) {
                    return this.parseOctal(0);
                }
                return 0;
            }
            case 99: {
                if (this.atEnd()) {
                    this.retreat();
                    return this.handleInvalidControlEscape();
                }
                char controlLetter = this.curChar();
                if (!this.flags.isEitherUnicode() && (JSRegexLexer.isDecimalDigit(controlLetter) || controlLetter == '_') && inCharClass) {
                    this.advance();
                    return controlLetter % 32;
                }
                if (!('a' <= controlLetter && controlLetter <= 'z' || 'A' <= controlLetter && controlLetter <= 'Z')) {
                    this.retreat();
                    return this.handleInvalidControlEscape();
                }
                this.advance();
                return Character.toUpperCase(controlLetter) - 64;
            }
            case 117: {
                int unicodeEscape = this.parseUnicodeEscapeChar(this.flags.isEitherUnicode());
                return unicodeEscape < 0 ? c : unicodeEscape;
            }
        }
        return -1;
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        if (inCharClass && this.flags.isUnicodeSets() ? !SYNTAX_CHARS.get(c) && !CLASS_SET_RESERVED_PUNCTUATORS.get(c) : (inCharClass ? !SYNTAX_CHARS.get(c) && c != 45 : !SYNTAX_CHARS.get(c))) {
            return this.handleInvalidEscape(c);
        }
        return c;
    }

    private char handleInvalidControlEscape() throws RegexSyntaxException {
        if (this.flags.isEitherUnicode()) {
            throw this.syntaxError("Invalid control char escape");
        }
        return '\\';
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        return null;
    }

    @Override
    protected Token parseGroupLt() {
        this.registerNamedCaptureGroup(this.jsParseGroupName());
        return Token.createCaptureGroupBegin();
    }

    private int parseUnicodeEscapeChar(boolean unicodeMode) throws RegexSyntaxException {
        if (unicodeMode && this.consumingLookahead("{")) {
            int value2 = this.parseHex(1, Integer.MAX_VALUE, 0x10FFFF);
            if (!this.consumingLookahead("}")) {
                throw this.syntaxError("Invalid Unicode escape");
            }
            return value2;
        }
        int value3 = this.parseHex(4, 4, 65535);
        if (unicodeMode && Character.isHighSurrogate((char)value3)) {
            int resetIndex = this.position;
            if (this.consumingLookahead("\\u") && !this.lookahead("{")) {
                char lead = (char)value3;
                char trail = (char)this.parseHex(4, 4, 65535);
                if (Character.isLowSurrogate(trail)) {
                    return Character.toCodePoint(lead, trail);
                }
                this.position = resetIndex;
            } else {
                this.position = resetIndex;
            }
        }
        return value3;
    }

    private int parseHex(int minDigits, int maxDigits, int maxValue) throws RegexSyntaxException {
        int ret = 0;
        int initialIndex = this.position;
        for (int i = 0; i < maxDigits; ++i) {
            if (this.atEnd() || !JSRegexLexer.isHexDigit(this.curChar())) {
                if (i >= minDigits) break;
                if (this.flags.isEitherUnicode()) {
                    throw this.syntaxError("Invalid Unicode escape");
                }
                this.position = initialIndex;
                return -1;
            }
            char c = this.consumeChar();
            ret *= 16;
            ret = c >= 'a' ? (ret += c - 87) : (c >= 'A' ? (ret += c - 55) : (ret += c - 48));
            if (ret <= maxValue) continue;
            throw this.syntaxError("Invalid Unicode escape");
        }
        return ret;
    }
}

