/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.ManagedChannel;
import io.grpc.NameResolverRegistry;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.internal.DnsNameResolverProvider;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.rules.GRPCUtils;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.ml.MLServerGrpc;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.tools.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GRPCRule
extends RemoteRule {
    public static final String CONFIG_TYPE = "grpc";
    private static final Logger logger = LoggerFactory.getLogger(GRPCRule.class);
    private static final int DEFAULT_BATCH_SIZE = 8;
    public static final Pattern WHITESPACE_REGEX = Pattern.compile("[\u00a0\u202f\ufeff\ufffd]");
    private static final String DEFAULT_DESCRIPTION = "INTERNAL - dynamically loaded rule supported by remote server";
    private static final LoadingCache<RemoteRuleConfig, Connection> servers = CacheBuilder.newBuilder().build(CacheLoader.from(serviceConfiguration -> {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException("No configuration for connection given");
        }
        try {
            return new Connection((RemoteRuleConfig)serviceConfiguration);
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }));
    private final Connection conn;
    private final int batchSize;
    private final boolean sendAnalyzedData;
    private int maxSentenceLength;

    public static String cleanID(String id, Language lang) {
        return StringTools.toId(id, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GRPCRule(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging) {
        super(language, messages, config, inputLogging);
        this.maxSentenceLength = Integer.parseInt(config.getOptions().getOrDefault("maxSentenceLength", String.valueOf(Integer.MAX_VALUE)));
        this.sendAnalyzedData = config.getOptions().getOrDefault("analyzed", "false").equalsIgnoreCase("true");
        this.batchSize = Integer.parseInt(config.getOptions().getOrDefault("batchSize", String.valueOf(8)));
        LoadingCache<RemoteRuleConfig, Connection> loadingCache = servers;
        synchronized (loadingCache) {
            Connection conn = null;
            try {
                conn = (Connection)servers.get((Object)this.serviceConfiguration);
            }
            catch (Exception e) {
                logger.error("Could not connect to remote service at " + this.serviceConfiguration, (Throwable)e);
            }
            this.conn = conn;
        }
    }

    @Override
    protected RemoteRule.RemoteRequest prepareRequest(List<AnalyzedSentence> sentences2, @Nullable Long textSessionId) {
        List<Object> ids = Collections.emptyList();
        List<AnalyzedSentence> filteredSentences = sentences2.stream().filter(s -> s.getText().length() <= this.maxSentenceLength).collect(Collectors.toList());
        if (textSessionId != null) {
            ids = Collections.nCopies(filteredSentences.size(), textSessionId);
        }
        if (this.sendAnalyzedData) {
            ArrayList<MLServerProto.AnalyzedMatchRequest> requests = new ArrayList<MLServerProto.AnalyzedMatchRequest>();
            for (int offset = 0; offset < filteredSentences.size(); offset += this.batchSize) {
                MLServerProto.AnalyzedMatchRequest req = MLServerProto.AnalyzedMatchRequest.newBuilder().addAllSentences(filteredSentences.subList(offset, Math.min(filteredSentences.size(), offset + this.batchSize)).stream().map(GRPCUtils::toGRPC).collect(Collectors.toList())).setInputLogging(this.inputLogging).addAllTextSessionID(textSessionId != null ? ids.subList(offset, Math.min(filteredSentences.size(), offset + this.batchSize)) : Collections.emptyList()).build();
                requests.add(req);
            }
            return new AnalyzedMLRuleRequest(requests, filteredSentences);
        }
        ArrayList<MLServerProto.MatchRequest> requests = new ArrayList<MLServerProto.MatchRequest>();
        for (int offset = 0; offset < filteredSentences.size(); offset += this.batchSize) {
            List text2 = filteredSentences.stream().map(AnalyzedSentence::getText).map(s -> {
                if (this.whitespaceNormalisation) {
                    return WHITESPACE_REGEX.matcher((CharSequence)s).replaceAll(" ");
                }
                return s;
            }).collect(Collectors.toList());
            MLServerProto.MatchRequest req = MLServerProto.MatchRequest.newBuilder().addAllSentences(text2.subList(offset, Math.min(text2.size(), offset + this.batchSize))).setInputLogging(this.inputLogging).addAllTextSessionID(textSessionId != null ? ids.subList(offset, Math.min(text2.size(), offset + this.batchSize)) : Collections.emptyList()).build();
            requests.add(req);
        }
        if (requests.size() > 1) {
            logger.debug("Split {} sentences into {} requests for {}", new Object[]{filteredSentences.size(), requests.size(), this.getId()});
        }
        return new MLRuleRequest(requests, filteredSentences, textSessionId);
    }

    @Nullable
    private static String nonEmpty(String s) {
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    @Override
    protected Callable<RemoteRuleResult> executeRequest(RemoteRule.RemoteRequest requestArg, long timeoutMilliseconds) throws TimeoutException {
        return () -> {
            List<AnalyzedSentence> sentences2;
            MLRuleRequest reqArgs = (MLRuleRequest)requestArg;
            boolean noRegression = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("no-regression", "false"));
            if (noRegression && reqArgs.textSessionId != null && (reqArgs.textSessionId == -1L || reqArgs.textSessionId == -2L)) {
                return new RemoteRuleResult(false, true, Collections.emptyList(), reqArgs.sentences);
            }
            ArrayList<ListenableFuture<MLServerProto.MatchResponse>> futures = new ArrayList<ListenableFuture<MLServerProto.MatchResponse>>();
            ArrayList<MLServerProto.MatchResponse> responses = new ArrayList<MLServerProto.MatchResponse>();
            try {
                Object reqData;
                if (this.sendAnalyzedData) {
                    reqData = (AnalyzedMLRuleRequest)requestArg;
                    List<AnalyzedSentence> sentences22 = ((AnalyzedMLRuleRequest)reqData).sentences;
                    for (MLServerProto.AnalyzedMatchRequest analyzedMatchRequest : ((AnalyzedMLRuleRequest)reqData).requests) {
                        if (timeoutMilliseconds > 0L) {
                            logger.debug("Deadline for rule {}: {}ms", (Object)this.getId(), (Object)timeoutMilliseconds);
                            futures.add(((MLServerGrpc.MLServerFutureStub)this.conn.stub.withDeadlineAfter(timeoutMilliseconds, TimeUnit.MILLISECONDS)).matchAnalyzed(analyzedMatchRequest));
                            continue;
                        }
                        futures.add(this.conn.stub.matchAnalyzed(analyzedMatchRequest));
                    }
                } else {
                    reqData = (MLRuleRequest)requestArg;
                    sentences2 = ((MLRuleRequest)reqData).sentences;
                    for (MLServerProto.MatchRequest matchRequest : ((MLRuleRequest)reqData).requests) {
                        if (timeoutMilliseconds > 0L) {
                            logger.debug("Deadline for rule {}: {}ms", (Object)this.getId(), (Object)timeoutMilliseconds);
                            futures.add(((MLServerGrpc.MLServerFutureStub)this.conn.stub.withDeadlineAfter(timeoutMilliseconds, TimeUnit.MILLISECONDS)).match(matchRequest));
                            continue;
                        }
                        futures.add(this.conn.stub.match(matchRequest));
                    }
                }
                for (ListenableFuture listenableFuture : futures) {
                    responses.add((MLServerProto.MatchResponse)listenableFuture.get());
                }
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.DEADLINE_EXCEEDED.getCode()) {
                    throw new TimeoutException(e.getMessage());
                }
                throw e;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TimeoutException(e + Objects.toString(e.getMessage()));
            }
            List<RuleMatch> matches = this.getRuleMatches(sentences2, responses);
            RemoteRuleResult remoteRuleResult = new RemoteRuleResult(true, true, matches, sentences2);
            return remoteRuleResult;
        };
    }

    private List<RuleMatch> getRuleMatches(List<AnalyzedSentence> sentences2, List<MLServerProto.MatchResponse> responses) {
        BiFunction<MLServerProto.MatchList, AnalyzedSentence, Stream> createMatch = (matchList, sentence) -> matchList.getMatchesList().stream().map(match -> {
            String description = match.getRuleDescription();
            if ((description == null || description.isEmpty()) && ((description = this.getDescription()) == null || description.isEmpty())) {
                throw new RuntimeException("Missing description for rule with ID " + match.getId() + "_" + match.getSubId());
            }
            GRPCSubRule subRule = new GRPCSubRule((MLServerProto.Match)match, description, this.ruleLanguage);
            String message = match.getMatchDescription();
            String shortMessage = match.getMatchShortDescription();
            if (message == null || message.isEmpty()) {
                message = this.getMessage((MLServerProto.Match)match, (AnalyzedSentence)sentence);
            }
            if (message == null || message.isEmpty()) {
                throw new RuntimeException("Missing message for match with ID " + subRule.getId());
            }
            int start = match.getOffset();
            int end = start + match.getLength();
            RuleMatch m = new RuleMatch(subRule, (AnalyzedSentence)sentence, start, end, message, shortMessage);
            if (!match.getUrl().isEmpty()) {
                try {
                    m.setUrl(new URL(match.getUrl()));
                }
                catch (MalformedURLException e) {
                    logger.warn("Got invalid URL from GRPC rule {}: {}", (Object)this, (Object)e);
                }
            }
            m.setAutoCorrect(match.getAutoCorrect());
            if (match.getSuggestedReplacementsList().isEmpty()) {
                m.setSuggestedReplacements((List<String>)match.getSuggestionsList());
            } else {
                m.setSuggestedReplacementObjects(match.getSuggestedReplacementsList().stream().map(s -> {
                    SuggestedReplacement repl = new SuggestedReplacement(s.getReplacement(), GRPCRule.nonEmpty(s.getDescription()), GRPCRule.nonEmpty(s.getSuffix()));
                    if ((double)s.getConfidence() > 0.0) {
                        repl.setConfidence(Float.valueOf(s.getConfidence()));
                    }
                    return repl;
                }).collect(Collectors.toList()));
            }
            return m;
        });
        List<RuleMatch> matches = Streams.zip(responses.stream().flatMap(res -> res.getSentenceMatchesList().stream()), sentences2.stream(), createMatch).flatMap(Function.identity()).collect(Collectors.toList());
        return matches;
    }

    protected abstract String getMessage(MLServerProto.Match var1, AnalyzedSentence var2);

    @Override
    protected RemoteRuleResult fallbackResults(RemoteRule.RemoteRequest request) {
        MLRuleRequest req = (MLRuleRequest)request;
        return new RemoteRuleResult(false, false, Collections.emptyList(), req.sentences);
    }

    public static GRPCRule create(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging, String id, final String descriptionKey, final Map<String, String> messagesByID) {
        return new GRPCRule(language, messages, config, inputLogging){

            @Override
            protected String getMessage(MLServerProto.Match match, AnalyzedSentence sentence) {
                return this.messages.getString((String)messagesByID.get(match.getSubId()));
            }

            @Override
            public String getDescription() {
                return this.messages.getString(descriptionKey);
            }
        };
    }

    public static GRPCRule create(Language language, RemoteRuleConfig config, boolean inputLogging, String id, final String description, final Map<String, String> messagesByID) {
        return new GRPCRule(language, JLanguageTool.getMessageBundle(), config, inputLogging){

            @Override
            protected String getMessage(MLServerProto.Match match, AnalyzedSentence sentence) {
                return (String)messagesByID.get(match.getSubId());
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    public static List<GRPCRule> createAll(Language language, List<RemoteRuleConfig> configs, boolean inputLogging, String prefix, String defaultDescription) {
        return configs.stream().filter(cfg -> cfg.getRuleId().startsWith(prefix)).map(cfg -> GRPCRule.create(language, cfg, inputLogging, cfg.getRuleId(), defaultDescription, Collections.emptyMap())).collect(Collectors.toList());
    }

    public static List<GRPCRule> createAll(Language language, List<RemoteRuleConfig> configs, boolean inputLogging) {
        return configs.stream().filter(RemoteRuleConfig.isRelevantConfig(CONFIG_TYPE, language)).map(cfg -> GRPCRule.create(language, cfg, inputLogging, cfg.getRuleId(), DEFAULT_DESCRIPTION, Collections.emptyMap())).collect(Collectors.toList());
    }

    static {
        shutdownRoutines.add(() -> servers.asMap().values().forEach(rec$ -> ((Connection)rec$).shutdown()));
    }

    public static class Connection {
        final ManagedChannel channel;
        final MLServerGrpc.MLServerFutureStub stub;

        public static ManagedChannel getManagedChannel(String host, int port, boolean useSSL, @Nullable String clientPrivateKey, @Nullable String clientCertificate, @Nullable String rootCertificate) throws SSLException {
            NettyChannelBuilder channelBuilder;
            if (host.startsWith("dns://")) {
                channelBuilder = NettyChannelBuilder.forTarget((String)(host + ":" + port));
                channelBuilder.defaultLoadBalancingPolicy("round_robin");
                NameResolverRegistry.getDefaultRegistry().register(new DnsNameResolverProvider());
            } else {
                channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
            }
            if (useSSL) {
                SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                if (rootCertificate != null) {
                    sslContextBuilder.trustManager(new File(rootCertificate));
                }
                if (clientCertificate != null && clientPrivateKey != null) {
                    sslContextBuilder.keyManager(new File(clientCertificate), new File(clientPrivateKey));
                }
                channelBuilder = channelBuilder.negotiationType(NegotiationType.TLS).sslContext(sslContextBuilder.build());
            } else {
                channelBuilder = channelBuilder.usePlaintext();
            }
            return channelBuilder.build();
        }

        Connection(RemoteRuleConfig serviceConfiguration) throws SSLException {
            String host = serviceConfiguration.getUrl();
            int port = serviceConfiguration.getPort();
            boolean ssl = Boolean.parseBoolean(serviceConfiguration.getOptions().getOrDefault("secure", "false"));
            String key2 = serviceConfiguration.getOptions().get("clientKey");
            String cert = serviceConfiguration.getOptions().get("clientCertificate");
            String ca = serviceConfiguration.getOptions().get("rootCertificate");
            this.channel = Connection.getManagedChannel(host, port, ssl, key2, cert, ca);
            this.stub = MLServerGrpc.newFutureStub(this.channel);
        }

        private void shutdown() {
            if (this.channel != null) {
                this.channel.shutdownNow();
            }
        }
    }

    protected class AnalyzedMLRuleRequest
    extends RemoteRule.RemoteRequest {
        final List<MLServerProto.AnalyzedMatchRequest> requests;
        final List<AnalyzedSentence> sentences;

        public AnalyzedMLRuleRequest(List<MLServerProto.AnalyzedMatchRequest> requests, List<AnalyzedSentence> sentences2) {
            this.requests = requests;
            this.sentences = sentences2;
        }
    }

    protected class MLRuleRequest
    extends RemoteRule.RemoteRequest {
        final List<MLServerProto.MatchRequest> requests;
        final List<AnalyzedSentence> sentences;
        final Long textSessionId;

        public MLRuleRequest(List<MLServerProto.MatchRequest> requests, List<AnalyzedSentence> sentences2, Long textSessionId) {
            this.requests = requests;
            this.sentences = sentences2;
            this.textSessionId = textSessionId;
        }
    }

    public static class GRPCSubRule
    extends Rule {
        private final String matchId;
        private final String description;

        GRPCSubRule(MLServerProto.Match match, String description, Language lang) {
            String ruleId = match.getId();
            String subId = match.getSubId();
            this.matchId = subId != null && !subId.trim().isEmpty() ? GRPCRule.cleanID(ruleId, lang) + "_" + GRPCRule.cleanID(subId, lang) : GRPCRule.cleanID(ruleId, lang);
            this.description = description;
            this.setTags(match.getRule().getTagsList().stream().map(t -> Tag.valueOf(t.name())).collect(Collectors.toList()));
        }

        @Override
        public String getId() {
            return this.matchId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

