/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.schema;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.schema.CompareResult;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u0013\u0010\u0014\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "", "()V", "contentType", "Lkotlin/reflect/KType;", "getContentType", "()Lkotlin/reflect/KType;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "nullable", "", "getNullable", "()Z", "type", "getType", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "other", "equals", "Frame", "Group", "Value", "core"})
public abstract class ColumnSchema {
    @NotNull
    public abstract ColumnKind getKind();

    public abstract boolean getNullable();

    @NotNull
    public abstract KType getType();

    @Nullable
    public abstract KType getContentType();

    public boolean equals(@Nullable Object other) {
        boolean bl;
        ColumnSchema columnSchema = other instanceof ColumnSchema ? (ColumnSchema)other : null;
        if (columnSchema == null) {
            return false;
        }
        ColumnSchema otherType = columnSchema;
        if (otherType.getKind() != this.getKind()) {
            return false;
        }
        if (otherType.getNullable() != this.getNullable()) {
            return false;
        }
        ColumnSchema columnSchema2 = this;
        if (columnSchema2 instanceof Value) {
            bl = Intrinsics.areEqual((Object)this.getType(), (Object)((Value)otherType).getType());
        } else if (columnSchema2 instanceof Group) {
            bl = Intrinsics.areEqual((Object)((Group)this).getSchema(), (Object)((Group)otherType).getSchema());
        } else if (columnSchema2 instanceof Frame) {
            bl = Intrinsics.areEqual((Object)((Frame)this).getSchema(), (Object)((Frame)otherType).getSchema());
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return bl;
    }

    @NotNull
    public final CompareResult compare(@NotNull ColumnSchema other) {
        CompareResult compareResult;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.getKind() != other.getKind()) {
            return CompareResult.None;
        }
        if (this == other) {
            return CompareResult.Equals;
        }
        ColumnSchema columnSchema = this;
        if (columnSchema instanceof Value) {
            compareResult = ((Value)this).compare((Value)other);
        } else if (columnSchema instanceof Group) {
            compareResult = ((Group)this).compare((Group)other);
        } else if (columnSchema instanceof Frame) {
            compareResult = ((Frame)this).compare((Frame)other);
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return compareResult;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Frame;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "nullable", "", "contentType", "Lkotlin/reflect/KType;", "(Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;ZLkotlin/reflect/KType;)V", "getContentType", "()Lkotlin/reflect/KType;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getNullable", "()Z", "getSchema", "()Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "type", "getType", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "other", "core"})
    public static final class Frame
    extends ColumnSchema {
        @NotNull
        private final DataFrameSchema schema;
        private final boolean nullable;
        @Nullable
        private final KType contentType;
        @NotNull
        private final ColumnKind kind;

        public Frame(@NotNull DataFrameSchema schema2, boolean nullable, @Nullable KType contentType) {
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            this.schema = schema2;
            this.nullable = nullable;
            this.contentType = contentType;
            this.kind = ColumnKind.Frame;
        }

        @NotNull
        public final DataFrameSchema getSchema() {
            return this.schema;
        }

        @Override
        public boolean getNullable() {
            return this.nullable;
        }

        @Override
        @Nullable
        public KType getContentType() {
            return this.contentType;
        }

        @Override
        @NotNull
        public ColumnKind getKind() {
            return this.kind;
        }

        @Override
        @NotNull
        public KType getType() {
            return Reflection.typeOf(DataFrame.class, (KTypeProjection)KTypeProjection.Companion.getSTAR());
        }

        @NotNull
        public final CompareResult compare(@NotNull Frame other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.schema.compare(other.schema).combine(CompareResult.Companion.compareNullability(this.getNullable(), other.getNullable()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Group;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "contentType", "Lkotlin/reflect/KType;", "(Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;Lkotlin/reflect/KType;)V", "getContentType", "()Lkotlin/reflect/KType;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "nullable", "", "getNullable", "()Z", "getSchema", "()Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "type", "getType", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "other", "core"})
    public static final class Group
    extends ColumnSchema {
        @NotNull
        private final DataFrameSchema schema;
        @Nullable
        private final KType contentType;
        @NotNull
        private final ColumnKind kind;
        private final boolean nullable;

        public Group(@NotNull DataFrameSchema schema2, @Nullable KType contentType) {
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            this.schema = schema2;
            this.contentType = contentType;
            this.kind = ColumnKind.Group;
        }

        @NotNull
        public final DataFrameSchema getSchema() {
            return this.schema;
        }

        @Override
        @Nullable
        public KType getContentType() {
            return this.contentType;
        }

        @Override
        @NotNull
        public ColumnKind getKind() {
            return this.kind;
        }

        @Override
        public boolean getNullable() {
            return this.nullable;
        }

        @Override
        @NotNull
        public KType getType() {
            return Reflection.typeOf(DataRow.class, (KTypeProjection)KTypeProjection.Companion.getSTAR());
        }

        @NotNull
        public final CompareResult compare(@NotNull Group other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.schema.compare(other.schema);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Value;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "type", "Lkotlin/reflect/KType;", "(Lkotlin/reflect/KType;)V", "contentType", "getContentType", "()Lkotlin/reflect/KType;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "nullable", "", "getNullable", "()Z", "getType", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "other", "core"})
    public static final class Value
    extends ColumnSchema {
        @NotNull
        private final KType type;
        @NotNull
        private final ColumnKind kind;
        private final boolean nullable;
        @Nullable
        private final KType contentType;

        public Value(@NotNull KType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
            this.kind = ColumnKind.Value;
            this.nullable = this.getType().isMarkedNullable();
        }

        @Override
        @NotNull
        public KType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public ColumnKind getKind() {
            return this.kind;
        }

        @Override
        public boolean getNullable() {
            return this.nullable;
        }

        @Override
        @Nullable
        public KType getContentType() {
            return this.contentType;
        }

        @NotNull
        public final CompareResult compare(@NotNull Value other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.areEqual((Object)this.getType(), (Object)other.getType()) ? CompareResult.Equals : (KTypes.isSubtypeOf((KType)this.getType(), (KType)other.getType()) ? CompareResult.IsDerived : (KTypes.isSupertypeOf((KType)this.getType(), (KType)other.getType()) ? CompareResult.IsSuper : CompareResult.None));
        }
    }
}

