/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.jigsaw;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.uml.java.jigsaw.JigsawUmlEdge;
import com.intellij.uml.java.jigsaw.JigsawUmlNode;
import com.intellij.uml.java.jigsaw.JigsawUmlProvider;
import com.intellij.uml.java.jigsaw.JigsawUmlRelationships;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JigsawUmlDataModel
extends DiagramDataModel<PsiJavaModule> {
    private static final Logger LOG = Logger.getInstance(JigsawUmlDataModel.class);
    private final Set<JigsawUmlNode> myNodes;
    private final Set<JigsawUmlEdge> myEdges;
    private final Map<String, SmartPsiElementPointer<PsiJavaModule>> myInitialElements;

    JigsawUmlDataModel(@NotNull Project project, @Nullable PsiJavaModule element) {
        if (project == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(0);
        }
        super(project, JigsawUmlProvider.getInstance());
        this.myNodes = new HashSet<JigsawUmlNode>();
        this.myEdges = new HashSet<JigsawUmlEdge>();
        this.myInitialElements = new HashMap<String, SmartPsiElementPointer<PsiJavaModule>>();
        if (element != null) {
            this.myInitialElements.put(element.getName(), this.createPointer(element));
        }
    }

    @Override
    @NotNull
    public synchronized Collection<? extends DiagramNode<PsiJavaModule>> getNodes() {
        Set<JigsawUmlNode> set = this.myNodes;
        if (set == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public synchronized Collection<? extends DiagramEdge<PsiJavaModule>> getEdges() {
        Set<JigsawUmlEdge> set = this.myEdges;
        if (set == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public String getNodeName(@NotNull DiagramNode<PsiJavaModule> n) {
        if (n == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(3);
        }
        String string = n.getIdentifyingElement().getName();
        if (string == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public synchronized DiagramNode<PsiJavaModule> addElement(PsiJavaModule element) {
        if (element == null) {
            return null;
        }
        this.myInitialElements.computeIfAbsent(element.getName(), unused -> this.createPointer(element));
        return new JigsawUmlNode(element, (JigsawUmlProvider)this.getBuilder().getProvider());
    }

    @NotNull
    private SmartPsiElementPointer<PsiJavaModule> createPointer(@NotNull PsiJavaModule element) {
        if (element == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(5);
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer((PsiElement)element);
        if (smartPsiElementPointer == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(6);
        }
        return smartPsiElementPointer;
    }

    @Override
    public void refreshDataModel() {
        this.updateDataModel();
    }

    private synchronized void updateDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        JigsawUmlProvider umlProvider = (JigsawUmlProvider)this.getBuilder().getProvider();
        HashSet pendingModulesQueue = new HashSet();
        for (SmartPsiElementPointer<PsiJavaModule> psiElementPointer : this.myInitialElements.values()) {
            ContainerUtil.addIfNotNull(pendingModulesQueue, (Object)((PsiJavaModule)psiElementPointer.getElement()));
        }
        HashMap<PsiJavaModule, JigsawUmlNode> usedModules = new HashMap<PsiJavaModule, JigsawUmlNode>();
        while (!pendingModulesQueue.isEmpty()) {
            Iterator it = pendingModulesQueue.iterator();
            LOG.assertTrue(it.hasNext(), (Object)"next pending module");
            PsiJavaModule javaModule = (PsiJavaModule)it.next();
            it.remove();
            JigsawUmlNode toNode = usedModules.computeIfAbsent(javaModule, aModule -> new JigsawUmlNode((PsiJavaModule)aModule, umlProvider));
            Map<PsiJavaModule, DiagramRelationshipInfo> requiredModules = JigsawUmlDataModel.getRequiredModules(javaModule);
            for (Map.Entry<PsiJavaModule, DiagramRelationshipInfo> requiredModule : requiredModules.entrySet()) {
                JigsawUmlNode fromNode = usedModules.computeIfAbsent(requiredModule.getKey(), aModule -> {
                    pendingModulesQueue.add(aModule);
                    return new JigsawUmlNode((PsiJavaModule)aModule, umlProvider);
                });
                this.myEdges.add(new JigsawUmlEdge(fromNode, toNode, requiredModule.getValue()));
            }
        }
        this.myNodes.addAll(usedModules.values());
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(7);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    @NotNull
    private static Map<PsiJavaModule, DiagramRelationshipInfo> getRequiredModules(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(8);
        }
        HashMap<PsiJavaModule, DiagramRelationshipInfo> result = new HashMap<PsiJavaModule, DiagramRelationshipInfo>();
        for (PsiRequiresStatement requiresStatement : javaModule.getRequires()) {
            PsiJavaModule resolved = requiresStatement.resolve();
            if (resolved == null) continue;
            DiagramRelationshipInfo relationship = JigsawUmlRelationships.getRelationship(requiresStatement.hasModifierProperty("transitive"), requiresStatement.hasModifierProperty("static"));
            result.put(resolved, relationship);
        }
        HashMap<PsiJavaModule, DiagramRelationshipInfo> hashMap = result;
        if (hashMap == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/jigsaw/JigsawUmlDataModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/jigsaw/JigsawUmlDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

