/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.ide.DataManager;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.CurrentFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.ExistingFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.ExistingFileStyleCreatorWithChooser;
import com.intellij.psi.css.actions.ruleset.NewFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.xml.XmlFile;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class CssSelectTargetPopupFactory
extends BaseListPopupStep<StyleCreator> {
    private CssSelectTargetPopupFactory() {
    }

    @NotNull
    public static ListPopup createSelectTargetPopup(@NotNull @NlsContexts.PopupTitle String popupTitle, @NotNull PsiFile file, @NotNull Editor editor, boolean suggestCurrentFile, @NotNull Consumer<? super StyleCreator> chooseItemCallback) {
        PsiDirectory parentDirectory;
        if (popupTitle == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(2);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group = DefaultActionGroup.createPopupGroupWithEmptyText();
        if (suggestCurrentFile) {
            group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new CurrentFileStyleCreator(file)));
        }
        if ((parentDirectory = file.getContainingDirectory()) != null) {
            group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new NewFileStyleCreator(file)));
        }
        group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new ExistingFileStyleCreatorWithChooser(file)));
        HashSet filesToIgnore = new HashSet();
        CssSelectTargetPopupFactory.addCreatorsForLinkedFiles(file, group, filesToIgnore, chooseItemCallback);
        CssSelectTargetPopupFactory.addCreatorsForOpenFiles(file, group, filesToIgnore, chooseItemCallback);
        CssSelectTargetPopupFactory.addCreatorsForRecentFiles(file, group, filesToIgnore, chooseItemCallback);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(popupTitle, (ActionGroup)group, dataContext, false, null, 10);
        if (listPopup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(4);
        }
        return listPopup;
    }

    private static void addCreatorsForLinkedFiles(@NotNull PsiFile file, @NotNull DefaultActionGroup rootGroup, @NotNull Set<? super VirtualFile> filesToIgnore, @NotNull Consumer<? super StyleCreator> chooseItemCallback) {
        if (file == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(5);
        }
        if (rootGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(6);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(7);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(8);
        }
        if (file instanceof XmlFile) {
            CssResolver resolver = CssResolveManager.getInstance().getNewResolver();
            resolver.setStrictResolveMode(true);
            resolver.setUseAgentStylesheet(false);
            StylesheetFile[] stylesheetFiles = resolver.resolveStyleSheets((XmlFile)file, null);
            DefaultActionGroup linkedFilesGroup = DefaultActionGroup.createPopupGroupWithEmptyText();
            linkedFilesGroup.addSeparator(CssBundle.message("action.text.separator.linked.files", new Object[0]));
            if (!LanguageUtil.isInTemplateLanguageFile((PsiElement)file)) {
                for (StylesheetFile stylesheetFile : stylesheetFiles) {
                    linkedFilesGroup.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new ExistingFileStyleCreator(file, stylesheetFile)));
                    filesToIgnore.add((VirtualFile)stylesheetFile.getVirtualFile());
                }
            }
            if (linkedFilesGroup.getChildrenCount() > 0) {
                rootGroup.addAll((ActionGroup)linkedFilesGroup);
            }
        }
    }

    private static void addCreatorsForRecentFiles(@NotNull PsiFile contextFile, @NotNull DefaultActionGroup rootGroup, @NotNull Set<? super VirtualFile> filesToIgnore, @NotNull Consumer<? super StyleCreator> chooseItemCallback) {
        if (contextFile == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(9);
        }
        if (rootGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(10);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(11);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(12);
        }
        DefaultActionGroup recentFilesGroup = DefaultActionGroup.createPopupGroupWithEmptyText();
        recentFilesGroup.addSeparator(CssBundle.message("action.text.separator.recent.files", new Object[0]));
        List recentEditedFiles = IdeDocumentHistory.getInstance((Project)contextFile.getProject()).getChangedFiles();
        CssSelectTargetPopupFactory.addStylesheetFilesToGroup(recentEditedFiles, contextFile, chooseItemCallback, filesToIgnore, recentFilesGroup);
        if (recentFilesGroup.getChildrenCount() > 0) {
            rootGroup.addAll((ActionGroup)recentFilesGroup);
        }
    }

    private static void addCreatorsForOpenFiles(@NotNull PsiFile contextFile, @NotNull DefaultActionGroup rootGroup, @NotNull Set<? super VirtualFile> filesToIgnore, @NotNull Consumer<? super StyleCreator> chooseItemCallback) {
        if (contextFile == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(13);
        }
        if (rootGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(14);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(15);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(16);
        }
        DefaultActionGroup recentFilesGroup = DefaultActionGroup.createPopupGroupWithEmptyText();
        recentFilesGroup.addSeparator(CssBundle.message("action.text.separator.open.files", new Object[0]));
        List<VirtualFile> openFiles = Arrays.asList(FileEditorManager.getInstance((Project)contextFile.getProject()).getOpenFiles());
        CssSelectTargetPopupFactory.addStylesheetFilesToGroup(openFiles, contextFile, chooseItemCallback, filesToIgnore, recentFilesGroup);
        if (recentFilesGroup.getChildrenCount() > 0) {
            rootGroup.addAll((ActionGroup)recentFilesGroup);
        }
    }

    private static void addStylesheetFilesToGroup(@NotNull List<? extends VirtualFile> files, @NotNull PsiFile contextFile, @NotNull Consumer<? super StyleCreator> callback, @NotNull Set<? super VirtualFile> filesToIgnore, @NotNull DefaultActionGroup targetGroup) {
        if (files == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(17);
        }
        if (contextFile == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(18);
        }
        if (callback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(19);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(20);
        }
        if (targetGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(21);
        }
        PsiManager psiManager = contextFile.getManager();
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile;
            if (filesToIgnore.contains(virtualFile) || !((psiFile = psiManager.findFile(virtualFile)) instanceof StylesheetFile)) continue;
            targetGroup.add(CssSelectTargetPopupFactory.wrapWithAction(callback, new ExistingFileStyleCreator(contextFile, (StylesheetFile)psiFile)));
            filesToIgnore.add((VirtualFile)virtualFile);
        }
    }

    @NotNull
    private static AnAction wrapWithAction(final @NotNull Consumer<? super StyleCreator> pass, final @NotNull StyleCreator creator) {
        if (pass == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(22);
        }
        if (creator == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(23);
        }
        return new AnAction(){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                e.getPresentation().setText(creator.getName(), false);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                pass.accept(creator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupTitle";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseItemCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGroup";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIgnore";
                break;
            }
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetGroup";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectTargetPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSelectTargetPopup";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCreatorsForLinkedFiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCreatorsForRecentFiles";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCreatorsForOpenFiles";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addStylesheetFilesToGroup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

