/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DasUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TsqlDefinitionProviderBase
extends AbstractDefinitionProvider {
    @Override
    @NotNull
    public Iterable<DasObject> load(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnectionCore connection2, @NotNull StringBuilder sink) throws Exception {
        if (objects == null) {
            TsqlDefinitionProviderBase.$$$reportNull$$$0(0);
        }
        if (connection2 == null) {
            TsqlDefinitionProviderBase.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            TsqlDefinitionProviderBase.$$$reportNull$$$0(2);
        }
        this.fetchSourcesByDb(objects, connection2, (PairConsumer<DasObject, Object>)((PairConsumer)(o, s) -> {
            if (s instanceof String) {
                sink.append(s).append("\nGO\n\n");
            }
            if (s instanceof Throwable) {
                sink.append("-- ").append(o.getName()).append("\n-- ").append(((Throwable)s).getMessage());
            }
        }));
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            TsqlDefinitionProviderBase.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchSourcesByDb(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnectionCore connection2, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            TsqlDefinitionProviderBase.$$$reportNull$$$0(4);
        }
        if (connection2 == null) {
            TsqlDefinitionProviderBase.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            TsqlDefinitionProviderBase.$$$reportNull$$$0(6);
        }
        MultiMap map2 = MultiMap.create();
        for (DasObject dasObject : objects) {
            map2.putValue((Object)DasUtil.getCatalog(dasObject), (Object)dasObject);
        }
        String currentDb = this.getCurrentDb(connection2);
        Collection collection = map2.remove((Object)currentDb);
        if (collection != null) {
            this.fetchSources(collection, connection2, consumer);
        }
        if (!map2.isEmpty()) {
            try {
                for (Map.Entry entry : map2.entrySet()) {
                    connection2.getRemoteConnection().setCatalog((String)entry.getKey());
                    this.fetchSources((Iterable)entry.getValue(), connection2, consumer);
                }
            }
            finally {
                if (currentDb != null) {
                    connection2.getRemoteConnection().setCatalog(currentDb);
                }
            }
        }
    }

    @Nullable
    protected abstract String getCurrentDb(@NotNull DatabaseConnectionCore var1) throws SQLException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/TsqlDefinitionProviderBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/TsqlDefinitionProviderBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fetchSourcesByDb";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

