/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtil;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u0005*\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ#\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010*\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesEditorUtils;", "", "<init>", "()V", "scrollTo", "", "Lcom/intellij/openapi/editor/Editor;", "targetLine", "", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "removeCells", "removedCells", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "withIgnoreStandardEditorPositionKeeper", "T", "body", "Lkotlin/Function0;", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.jupyter.core"})
public final class NotebookCellLinesEditorUtils {
    @NotNull
    public static final NotebookCellLinesEditorUtils INSTANCE = new NotebookCellLinesEditorUtils();

    private NotebookCellLinesEditorUtils() {
    }

    public final void scrollTo(@NotNull Editor $this$scrollTo, int targetLine, @NotNull ScrollType scrollType) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)"scrollType");
        $this$scrollTo.getScrollingModel().scrollTo(new LogicalPosition(targetLine, 0), scrollType);
    }

    public final void removeCells(@NotNull Editor $this$removeCells, @NotNull List<NotebookCellLines.Interval> removedCells) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCells, (String)"<this>");
        Intrinsics.checkNotNullParameter(removedCells, (String)"removedCells");
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)$this$removeCells);
        if (notebookCellSelectionModel != null) {
            NotebookCellSelectionModel model = notebookCellSelectionModel;
            boolean bl = false;
            NotebookCellLines.Interval newPrimaryCell = NotebookCellLinesActionUtil.INSTANCE.findNewPrimaryCell(CollectionsKt.toSet((Iterable)removedCells), model, NotebookCellLines.Companion.get($this$removeCells));
            model.selectSingleCell(newPrimaryCell);
        }
        Document document = $this$removeCells.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        NotebookCellLinesDocumentUtils.INSTANCE.removeCells(document, removedCells, NotebookIntervalPointerFactory.Companion.getOrNull($this$removeCells));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withIgnoreStandardEditorPositionKeeper(@NotNull Editor $this$withIgnoreStandardEditorPositionKeeper, @NotNull Function0<? extends T> body) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withIgnoreStandardEditorPositionKeeper, (String)"<this>");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Boolean prevState = (Boolean)$this$withIgnoreStandardEditorPositionKeeper.getUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING);
        $this$withIgnoreStandardEditorPositionKeeper.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
        try {
            object = body.invoke();
        }
        finally {
            $this$withIgnoreStandardEditorPositionKeeper.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)prevState);
        }
        return (T)object;
    }
}

