/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.cbor.CborBuilder;
import kotlinx.serialization.cbor.CborConfiguration;
import kotlinx.serialization.cbor.CborKt;
import kotlinx.serialization.cbor.internal.ByteArrayInput;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import kotlinx.serialization.cbor.internal.CborParser;
import kotlinx.serialization.cbor.internal.CborReader;
import kotlinx.serialization.cbor.internal.CborWriter;
import kotlinx.serialization.cbor.internal.DefiniteLengthCborWriter;
import kotlinx.serialization.cbor.internal.IndefiniteLengthCborWriter;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u0011\u001a\u0002H\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J)\u0010\u0013\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lkotlinx/serialization/cbor/Cbor;", "Lkotlinx/serialization/BinaryFormat;", "configuration", "Lkotlinx/serialization/cbor/CborConfiguration;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "<init>", "(Lkotlinx/serialization/cbor/CborConfiguration;Lkotlinx/serialization/modules/SerializersModule;)V", "getConfiguration", "()Lkotlinx/serialization/cbor/CborConfiguration;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "encodeToByteArray", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "decodeFromByteArray", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "Default", "Lkotlinx/serialization/cbor/Cbor$Default;", "Lkotlinx/serialization/cbor/CborImpl;", "kotlinx-serialization-cbor"})
public abstract class Cbor
implements BinaryFormat {
    @NotNull
    public static final Default Default = new Default(null);
    @NotNull
    private final CborConfiguration configuration;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private static final Cbor CoseCompliant = CborKt.Cbor$default(null, Cbor::CoseCompliant$lambda$0, 1, null);

    private Cbor(CborConfiguration configuration, SerializersModule serializersModule) {
        this.configuration = configuration;
        this.serializersModule = serializersModule;
    }

    @NotNull
    public final CborConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public <T> byte[] encodeToByteArray(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        ByteArrayOutput output = new ByteArrayOutput();
        CborWriter dumper = this.configuration.getUseDefiniteLengthEncoding() ? (CborWriter)new DefiniteLengthCborWriter(this, output) : (CborWriter)new IndefiniteLengthCborWriter(this, output);
        dumper.encodeSerializableValue(serializer, value);
        return output.toByteArray();
    }

    public <T> T decodeFromByteArray(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayInput stream = new ByteArrayInput(bytes);
        CborReader reader = new CborReader(this, new CborParser(stream, this.configuration.getVerifyObjectTags()));
        return reader.decodeSerializableValue(deserializer);
    }

    private static final Unit CoseCompliant$lambda$0(CborBuilder $this$Cbor) {
        Intrinsics.checkNotNullParameter((Object)$this$Cbor, (String)"$this$Cbor");
        $this$Cbor.setEncodeDefaults(false);
        $this$Cbor.setIgnoreUnknownKeys(false);
        $this$Cbor.setEncodeKeyTags(true);
        $this$Cbor.setEncodeValueTags(true);
        $this$Cbor.setEncodeObjectTags(true);
        $this$Cbor.setVerifyKeyTags(true);
        $this$Cbor.setVerifyValueTags(true);
        $this$Cbor.setVerifyObjectTags(true);
        $this$Cbor.setUseDefiniteLengthEncoding(true);
        $this$Cbor.setPreferCborLabelsOverNames(true);
        $this$Cbor.setAlwaysUseByteString(false);
        $this$Cbor.setSerializersModule(SerializersModuleBuildersKt.EmptySerializersModule());
        return Unit.INSTANCE;
    }

    public /* synthetic */ Cbor(CborConfiguration configuration, SerializersModule serializersModule, DefaultConstructorMarker $constructor_marker) {
        this(configuration, serializersModule);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkotlinx/serialization/cbor/Cbor$Default;", "Lkotlinx/serialization/cbor/Cbor;", "<init>", "()V", "CoseCompliant", "getCoseCompliant", "()Lkotlinx/serialization/cbor/Cbor;", "kotlinx-serialization-cbor"})
    public static final class Default
    extends Cbor {
        private Default() {
            super(new CborConfiguration(false, false, false, false, false, false, false, false, false, false, false), SerializersModuleBuildersKt.EmptySerializersModule(), null);
        }

        @NotNull
        public final Cbor getCoseCompliant() {
            return CoseCompliant;
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

