/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.datatype.xsd.Measure;
import com.thaiopensource.datatype.xsd.OrderRelation;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;
import org.relaxng.datatype.helpers.StreamingValidatorImpl;

abstract class DatatypeBase
implements Datatype2 {
    private final int whiteSpace;
    static final int WHITE_SPACE_PRESERVE = 0;
    static final int WHITE_SPACE_REPLACE = 1;
    static final int WHITE_SPACE_COLLAPSE = 2;

    abstract boolean lexicallyAllows(String var1);

    DatatypeBase() {
        this.whiteSpace = 2;
    }

    DatatypeBase(int n) {
        this.whiteSpace = n;
    }

    int getWhiteSpace() {
        return this.whiteSpace;
    }

    public boolean isValid(String string, ValidationContext validationContext) {
        return this.lexicallyAllows(string = this.normalizeWhiteSpace(string)) && this.allowsValue(string, validationContext);
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        if (!this.isValid(string, validationContext)) {
            throw new DatatypeException();
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        if (!this.lexicallyAllows(string = this.normalizeWhiteSpace(string))) {
            return null;
        }
        return this.getValue(string, validationContext);
    }

    final String normalizeWhiteSpace(String string) {
        switch (this.whiteSpace) {
            case 2: {
                return DatatypeBase.collapseWhiteSpace(string);
            }
            case 1: {
                return DatatypeBase.replaceWhiteSpace(string);
            }
        }
        return string;
    }

    boolean allowsValue(String string, ValidationContext validationContext) {
        return true;
    }

    abstract Object getValue(String var1, ValidationContext var2);

    OrderRelation getOrderRelation() {
        return null;
    }

    Measure getMeasure() {
        return null;
    }

    private static final String collapseWhiteSpace(String string) {
        int n = DatatypeBase.collapseStart(string);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        boolean bl = n == 0 || string.charAt(n - 1) == ' ';
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static final int collapseStart(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            switch (string.charAt(n)) {
                case ' ': {
                    if (n != 0 && string.charAt(n - 1) != ' ' && n != n2 - 1) break;
                    return n;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    private static final String replaceWhiteSpace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    char[] cArray = string.toCharArray();
                    cArray[n2] = 32;
                    ++n2;
                    while (n2 < n) {
                        switch (cArray[n2]) {
                            case '\t': 
                            case '\n': 
                            case '\r': {
                                cArray[n2] = 32;
                            }
                        }
                        ++n2;
                    }
                    return new String(cArray);
                }
            }
            ++n2;
        }
        return string;
    }

    DatatypeBase getPrimitive() {
        return this;
    }

    public boolean isContextDependent() {
        return false;
    }

    public boolean alwaysValid() {
        return false;
    }

    public int getIdType() {
        return 0;
    }

    public int valueHashCode(Object object) {
        return object.hashCode();
    }

    public boolean sameValue(Object object, Object object2) {
        return object.equals(object2);
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext validationContext) {
        return new StreamingValidatorImpl(this, validationContext);
    }
}

