/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridColorsScheme
extends DelegateColorScheme {
    private final boolean myUseConsoleFonts;
    @Nullable
    private FontPreferences myFontPreferences;
    private Color myDefaultBackground;

    public GridColorsScheme(boolean useConsoleFonts, @Nullable DataGridAppearanceSettings settings) {
        super(EditorColorsManager.getInstance().getGlobalScheme());
        this.updateFromSettings(settings);
        this.myUseConsoleFonts = useConsoleFonts;
    }

    public boolean isExplicitDefaultBackground() {
        return this.myDefaultBackground != null;
    }

    @NotNull
    public CellAttributes getAttributes(@NotNull CellAttributesKey key) {
        if (key == null) {
            GridColorsScheme.$$$reportNull$$$0(0);
        }
        TextAttributes attributes = this.getAttributes(key.attributes);
        Color color = attributes.getBackgroundColor();
        Color background = key.isUnderlined ? null : color;
        Color effect = key.isUnderlined ? color : null;
        return new CellAttributes(background, effect, key.isUnderlined);
    }

    @NotNull
    public Color getDefaultBackground() {
        Color color = this.myDefaultBackground != null ? this.myDefaultBackground : super.getDefaultBackground();
        if (color == null) {
            GridColorsScheme.$$$reportNull$$$0(1);
        }
        return color;
    }

    public void setDefaultBackground(@Nullable Color color) {
        this.myDefaultBackground = color;
    }

    public void updateFromScheme(boolean useCustomFont, @NotNull GridColorsScheme scheme) {
        if (scheme == null) {
            GridColorsScheme.$$$reportNull$$$0(2);
        }
        if (useCustomFont) {
            this.myFontPreferences = new FontPreferencesImpl();
            String family = scheme.getFontPreferences().getFontFamily();
            ((FontPreferencesImpl)this.myFontPreferences).setEffectiveFontFamilies(List.of(family));
            ((FontPreferencesImpl)this.myFontPreferences).setFontSize(family, scheme.getEditorFontSize());
            ((FontPreferencesImpl)this.myFontPreferences).setLineSpacing(scheme.getLineSpacing());
        } else {
            this.myFontPreferences = null;
        }
    }

    public void updateFromSettings(@Nullable DataGridAppearanceSettings settings) {
        if (settings != null && settings.getUseGridCustomFont()) {
            this.myFontPreferences = new FontPreferencesImpl();
            String family = (String)ObjectUtils.notNull((Object)settings.getGridFontFamily(), (Object)this.getDelegate().getFontPreferences().getFontFamily());
            ((FontPreferencesImpl)this.myFontPreferences).setEffectiveFontFamilies(List.of(family));
            ((FontPreferencesImpl)this.myFontPreferences).setFontSize(family, settings.getGridFontSize());
            ((FontPreferencesImpl)this.myFontPreferences).setLineSpacing(settings.getGridLineSpacing());
        } else {
            this.myFontPreferences = null;
        }
    }

    public void setLineSpacing(float lineSpacing) {
        if (this.myFontPreferences != null) {
            if (this.myFontPreferences instanceof ModifiableFontPreferences) {
                ((ModifiableFontPreferences)this.myFontPreferences).setLineSpacing(lineSpacing);
            }
        } else {
            super.setLineSpacing(lineSpacing);
        }
    }

    public void setEditorFontSize(int fontSize) {
        if (this.myFontPreferences != null) {
            if (this.myFontPreferences instanceof ModifiableFontPreferences) {
                ((ModifiableFontPreferences)this.myFontPreferences).setFontSize(this.getEditorFontName(), fontSize);
            }
        } else {
            super.setEditorFontSize(fontSize);
        }
    }

    public void setEditorFontSize(float fontSize) {
        if (this.myFontPreferences != null) {
            if (this.myFontPreferences instanceof ModifiableFontPreferences) {
                ((ModifiableFontPreferences)this.myFontPreferences).setFontSize(this.getEditorFontName(), fontSize);
            }
        } else {
            super.setEditorFontSize(fontSize);
        }
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences != null ? this.myFontPreferences : (this.myUseConsoleFonts ? super.getConsoleFontPreferences() : super.getFontPreferences());
        if (fontPreferences == null) {
            GridColorsScheme.$$$reportNull$$$0(3);
        }
        return fontPreferences;
    }

    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            GridColorsScheme.$$$reportNull$$$0(4);
        }
        if (this.myFontPreferences != null) {
            this.myFontPreferences = preferences;
        } else {
            super.setFontPreferences(preferences);
        }
    }

    public void setCustomFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            GridColorsScheme.$$$reportNull$$$0(5);
        }
        this.myFontPreferences = preferences;
    }

    public String getEditorFontName() {
        return this.myFontPreferences != null ? this.myFontPreferences.getFontFamily() : (this.myUseConsoleFonts ? super.getConsoleFontName() : super.getEditorFontName());
    }

    public int getEditorFontSize() {
        return this.myFontPreferences != null ? this.myFontPreferences.getSize(this.getEditorFontName()) : (this.myUseConsoleFonts ? super.getConsoleFontSize() : super.getEditorFontSize());
    }

    public float getEditorFontSize2D() {
        return this.myFontPreferences != null ? this.myFontPreferences.getSize2D(this.getEditorFontName()) : (this.myUseConsoleFonts ? super.getConsoleFontSize2D() : super.getEditorFontSize2D());
    }

    public float getLineSpacing() {
        return this.myFontPreferences != null ? this.myFontPreferences.getLineSpacing() : (this.myUseConsoleFonts ? super.getConsoleLineSpacing() : super.getLineSpacing());
    }

    @NotNull
    public Font getFont(EditorFontType key) {
        if (this.myFontPreferences == null) {
            Font font = this.myUseConsoleFonts ? super.getFont(EditorFontType.getConsoleType((EditorFontType)key)) : super.getFont(key);
            if (font == null) {
                GridColorsScheme.$$$reportNull$$$0(6);
            }
            return font;
        }
        Font font = this.myFontPreferences instanceof DelegatingFontPreferences ? EditorFontCache.getInstance().getFont(key) : FontFamilyService.getFont((String)this.myFontPreferences.getFontFamily(), (String)this.myFontPreferences.getRegularSubFamily(), (String)this.myFontPreferences.getBoldSubFamily(), (int)0, (float)this.myFontPreferences.getSize2D(this.myFontPreferences.getFontFamily()));
        if (font == null) {
            GridColorsScheme.$$$reportNull$$$0(7);
        }
        return font;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridColorsScheme";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridColorsScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBackground";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateFromScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFontPreferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCustomFontPreferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

