/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.library.JSCDNLibManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLibraryUtil {
    public static final Logger LOG = Logger.getInstance(JSLibraryUtil.class);
    private static final String[] MIN_SUFFIXES = new String[]{".min.", "-min.", "-yui-compressed"};
    private static final HashMap<String, String> MIN_TO_DEV_VERSION_MAP = new HashMap();
    public static final String NODE_MODULES = "node_modules";
    public static final String BOWER_COMPONENTS = "bower_components";
    private static final String JSPM_PACKAGES = "jspm_packages";
    public static final String[] LIBRARY_DIR_NAMES = new String[]{"node_modules", "bower_components", "jspm_packages"};
    public static final Set<String> LIBRARY_ROOT_DIR_NAME_SET = Set.of(LIBRARY_DIR_NAMES);
    private static final String JS_EXT = ".js";
    private static final String CSS_EXT = ".css";
    private static final String[] HTTP_PREFIXES;

    private JSLibraryUtil() {
    }

    public static boolean containsLibURL(String location) {
        return HtmlUtil.hasHtmlPrefix((String)location) && (JSLibraryUtil.isPossibleLibFile(location) || JSCDNLibManager.getLibraryForUrl(location) != null);
    }

    public static String getDevVersionLocation(@NotNull String location, boolean forDownload) {
        JSCDNLibManager.JSCDNLibrary library;
        if (location == null) {
            JSLibraryUtil.$$$reportNull$$$0(0);
        }
        if ((library = JSCDNLibManager.getLibraryForUrl(location)) != null) {
            return library.getNonMinifiedUrl(forDownload);
        }
        if (!JSLibraryUtil.isPossibleLibFile(location)) {
            return location;
        }
        String fileName = JSLibraryUtil.extractFileName(location);
        if (MIN_TO_DEV_VERSION_MAP.containsKey(fileName)) {
            return location.replace(fileName, MIN_TO_DEV_VERSION_MAP.get(fileName));
        }
        return JSLibraryUtil.convertLocationSuffixToNonMinimized(location);
    }

    public static String convertLocationSuffixToNonMinimized(@NotNull String location) {
        String oldFileName;
        if (location == null) {
            JSLibraryUtil.$$$reportNull$$$0(1);
        }
        String fileName = oldFileName = JSLibraryUtil.extractFileName(location);
        for (String minSuffix : MIN_SUFFIXES) {
            if (!fileName.contains(minSuffix)) continue;
            fileName = oldFileName.replace(minSuffix, ".");
            return location.replace(oldFileName, fileName);
        }
        return location;
    }

    private static boolean isPossibleLibFile(String location) {
        return location.endsWith(JS_EXT) || location.endsWith(CSS_EXT);
    }

    public static String makeUniqueFileName(String filePath, boolean adjustFileName) {
        if (adjustFileName) {
            filePath = JSLibraryUtil.getDevVersionLocation(filePath, false);
        }
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            filePath = filePath.replace(prefix, "http_");
            break;
        }
        return filePath.replace('/', '_').replace('\\', '_');
    }

    private static String extractFileName(String filePath) {
        int fileSepIndex = filePath.lastIndexOf(47);
        if (fileSepIndex < 0) {
            fileSepIndex = filePath.lastIndexOf(File.separatorChar);
        }
        return fileSepIndex >= 0 ? filePath.substring(fileSepIndex + 1) : filePath;
    }

    public static String getLibName(String location) {
        int dotIndex;
        JSCDNLibManager.JSCDNLibrary library = JSCDNLibManager.getLibraryForUrl(location);
        if (library != null) {
            return library.getLibraryName();
        }
        String libName = JSLibraryUtil.extractFileName(location);
        if (!MIN_TO_DEV_VERSION_MAP.containsKey(libName)) {
            for (String minSuffix : MIN_SUFFIXES) {
                if (!libName.contains(minSuffix)) continue;
                libName = libName.replace(minSuffix, ".");
                break;
            }
        }
        if ((dotIndex = libName.lastIndexOf(46)) >= 0) {
            libName = libName.substring(0, dotIndex);
        }
        return libName;
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(2);
        }
        return JSLibraryUtil.isProbableLibraryFile(file, project == null ? null : ProjectUtil.guessProjectDir((Project)project));
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(3);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, null);
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(4);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, fileToStop) || JSUrlImportsUtil.isInRemoteModulesLibrary(file);
    }

    private static boolean isPredefinedLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(5);
        }
        return JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file);
    }

    public static VirtualFile getTopLibraryFolder(@NotNull VirtualFile file, @NotNull String libraryFolder, @Nullable VirtualFile stopFolder) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(6);
        }
        if (libraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(7);
        }
        VirtualFile currentTarget = file;
        VirtualFile current = file;
        VirtualFile candidate;
        while ((candidate = JSLibraryUtil.getLibraryFolder(currentTarget, libraryFolder)) != null && (stopFolder == null || VfsUtilCore.isAncestor((VirtualFile)stopFolder, (VirtualFile)candidate, (boolean)true))) {
            current = candidate;
            if (current.getParent() == null || current.getParent().getParent() == null) {
                return current;
            }
            currentTarget = current.getParent().getParent();
        }
        return current;
    }

    @Nullable
    public static VirtualFile findAncestorLibraryDir(@NotNull VirtualFile fileOrDir, @NotNull String libraryName) {
        if (fileOrDir == null) {
            JSLibraryUtil.$$$reportNull$$$0(8);
        }
        if (libraryName == null) {
            JSLibraryUtil.$$$reportNull$$$0(9);
        }
        for (VirtualFile f = fileOrDir.getParent(); f != null; f = f.getParent()) {
            if (!StringUtil.equals((CharSequence)libraryName, (CharSequence)f.getNameSequence())) continue;
            return f;
        }
        return null;
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(10);
        }
        return JSLibraryUtil.getLibraryFolder(file, LIBRARY_ROOT_DIR_NAME_SET);
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file, @NotNull String parentLibraryFolder) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(11);
        }
        if (parentLibraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(12);
        }
        return JSLibraryUtil.getLibraryFolder(file, Collections.singleton(parentLibraryFolder));
    }

    @Nullable
    private static VirtualFile getLibraryFolder(@NotNull VirtualFile file, @NotNull Set<String> parentLibraryFolders) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(13);
        }
        if (parentLibraryFolders == null) {
            JSLibraryUtil.$$$reportNull$$$0(14);
        }
        VirtualFile current = file;
        while (current != null) {
            CharSequence parentName;
            VirtualFile parent = current.getParent();
            CharSequence charSequence = parentName = parent == null ? null : parent.getNameSequence();
            if (parentName != null && parentLibraryFolders.contains(parentName.toString())) {
                return current;
            }
            current = parent;
        }
        return null;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, String @NotNull [] dirNames, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(15);
        }
        if (dirNames == null) {
            JSLibraryUtil.$$$reportNull$$$0(16);
        }
        return JSLibraryUtil.findDirectoryInPath(file, dirNames, fileToStop) != null;
    }

    @Nullable
    public static VirtualFile findDirectoryInPath(@NotNull VirtualFile file, String @NotNull [] dirNames, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(17);
        }
        if (dirNames == null) {
            JSLibraryUtil.$$$reportNull$$$0(18);
        }
        for (VirtualFile parent = file.getParent(); parent != null && !parent.equals(fileToStop); parent = parent.getParent()) {
            CharSequence name = parent.getNameSequence();
            for (String dirName : dirNames) {
                if (!StringUtil.equals((CharSequence)dirName, (CharSequence)name)) continue;
                return parent;
            }
        }
        return null;
    }

    public static boolean hasAllDirectoriesInPath(@NotNull VirtualFile file, String @NotNull [] dirNames, @NotNull VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(19);
        }
        if (fileToStop == null) {
            JSLibraryUtil.$$$reportNull$$$0(20);
        }
        if (dirNames == null) {
            JSLibraryUtil.$$$reportNull$$$0(21);
        }
        if (dirNames.length == 0) {
            return false;
        }
        Set remainingDirs = null;
        for (VirtualFile parent = file.getParent(); parent != null && !parent.equals(fileToStop); parent = parent.getParent()) {
            CharSequence name = parent.getNameSequence();
            if (remainingDirs == null) {
                for (String dirName : dirNames) {
                    if (!name.equals(dirName)) continue;
                    remainingDirs = ContainerUtil.newHashSet((Object[])dirNames);
                    break;
                }
            }
            if (remainingDirs == null || !remainingDirs.contains(name)) continue;
            remainingDirs.remove(name);
            if (!remainingDirs.isEmpty()) continue;
            return true;
        }
        return remainingDirs != null && remainingDirs.isEmpty();
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String directoryName, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(22);
        }
        if (directoryName == null) {
            JSLibraryUtil.$$$reportNull$$$0(23);
        }
        for (VirtualFile parent = file.getParent(); parent != null && !parent.equals(fileToStop); parent = parent.getParent()) {
            if (!StringUtil.equals((CharSequence)directoryName, (CharSequence)parent.getNameSequence())) continue;
            return true;
        }
        return false;
    }

    public static boolean isProbableLibraryPath(@NotNull String filePath) {
        if (filePath == null) {
            JSLibraryUtil.$$$reportNull$$$0(24);
        }
        filePath = FileUtil.toSystemIndependentName((String)filePath);
        for (String dirName : LIBRARY_DIR_NAMES) {
            if (!JSLibraryUtil.containsDirInSystemIndependentPath(filePath, dirName)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDirInPath(@NotNull String filePath, @NotNull String dirName) {
        if (filePath == null) {
            JSLibraryUtil.$$$reportNull$$$0(25);
        }
        if (dirName == null) {
            JSLibraryUtil.$$$reportNull$$$0(26);
        }
        filePath = FileUtil.toSystemIndependentName((String)filePath);
        return JSLibraryUtil.containsDirInSystemIndependentPath(filePath, dirName);
    }

    private static boolean containsDirInSystemIndependentPath(@NotNull String filePath, @NotNull String dirName) {
        if (filePath == null) {
            JSLibraryUtil.$$$reportNull$$$0(27);
        }
        if (dirName == null) {
            JSLibraryUtil.$$$reportNull$$$0(28);
        }
        int ind = filePath.indexOf(dirName);
        while (ind >= 0) {
            if (!(ind != 0 && filePath.charAt(ind - 1) != '/' || ind + dirName.length() != filePath.length() && filePath.charAt(ind + dirName.length()) != '/')) {
                return true;
            }
            ind = filePath.indexOf(dirName, ind + dirName.length());
        }
        return false;
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull LocalFileSystem localFileSystem, @NotNull File ioFile) {
        if (localFileSystem == null) {
            JSLibraryUtil.$$$reportNull$$$0(29);
        }
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(30);
        }
        if (!ioFile.isFile()) {
            LOG.warn("Cannot find " + ioFile.getAbsolutePath() + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = localFileSystem.findFileByIoFile(ioFile);
        if (file != null) {
            return file;
        }
        LOG.warn("Cannot find virtual file for " + ioFile.getAbsolutePath());
        return null;
    }

    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(31);
        }
        return JSLibraryUtil.findUpClosestNodeModulesResolveRoot(file, true);
    }

    @Nullable
    public static VirtualFile findConfigFile(@Nullable VirtualFile file, @NotNull String configName) {
        VirtualFile current;
        if (configName == null) {
            JSLibraryUtil.$$$reportNull$$$0(32);
        }
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = current = file.isDirectory() ? file : file.getParent();
        while (current != null) {
            VirtualFile config = current.findChild(configName);
            if (config != null && config.isValid() && !config.isDirectory()) {
                return config;
            }
            current = current.getParent();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(33);
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            VirtualFile nodeModulesDir = parent.findChild(NODE_MODULES);
            if (nodeModulesDir != null && nodeModulesDir.isDirectory()) {
                return nodeModulesDir;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findFileByIO(@NotNull File ioFile, boolean includeInvalid) {
        VirtualFile file;
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(34);
        }
        if ((file = LocalFileSystem.getInstance().findFileByIoFile(ioFile)) != null && (includeInvalid || file.isValid())) {
            return file;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Cannot find virtual file " + ioFile.getName() + " by file " + ioFile.getPath());
        }
        return null;
    }

    @Contract(value="_, null -> null")
    public static VirtualFile getContentRootForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(35);
        }
        if (file == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile contentRoot = JSProjectUtil.getBaseDirectoryForFile(project, file, false);
        if (contentRoot == null && (file = file.getParent()) != null) {
            contentRoot = fileIndex.getContentRootForFile(file, false);
        }
        if (contentRoot == null && file != null && fileIndex.isInLibrary(file)) {
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
            VirtualFile virtualFile = file = sourceRoot != null ? sourceRoot.getParent() : null;
            if (file != null) {
                contentRoot = fileIndex.getContentRootForFile(file, false);
            }
        }
        if (contentRoot == null && file != null) {
            contentRoot = BaseProjectDirectories.getInstance((Project)project).getBaseDirectoryFor(file);
        }
        return contentRoot;
    }

    @NotNull
    public static GlobalSearchScope getContentScopeWithoutLibraries(@NotNull Project project) {
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(36);
        }
        GlobalSearchScope scope2 = ProjectScope.getContentScope((Project)project);
        final ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        GlobalSearchScope globalSearchScope = scope2.intersectWith(new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file.isValid() && !file.isDirectory() && !JSLibraryUtil.isProbableLibraryFile(file) && !fileIndex.isInLibrary(file);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (globalSearchScope == null) {
            JSLibraryUtil.$$$reportNull$$$0(37);
        }
        return globalSearchScope;
    }

    public static boolean isInProjectAndOutsideOfLibraryRoots(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile contentRoot;
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(38);
        }
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(39);
        }
        return (contentRoot = JSProjectUtil.getBaseDirectoryForFile(project, file, false)) != null && !JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, contentRoot);
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, @NotNull ModalityState modalityState, @Nullable Runnable finishRunnable, File ... files) {
        if (modalityState == null) {
            JSLibraryUtil.$$$reportNull$$$0(40);
        }
        if (files == null) {
            JSLibraryUtil.$$$reportNull$$$0(41);
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile[] virtualFiles = (VirtualFile[])ContainerUtil.map((Object[])files, arg_0 -> ((LocalFileSystem)fileSystem).refreshAndFindFileByIoFile(arg_0), (Object[])VirtualFile.EMPTY_ARRAY);
        JSLibraryUtil.markDirtyAndRefresh(async, recursive, reloadChildren, modalityState, finishRunnable, virtualFiles);
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, @NotNull ModalityState modalityState, @Nullable Runnable finishRunnable, Path ... files) {
        if (modalityState == null) {
            JSLibraryUtil.$$$reportNull$$$0(42);
        }
        if (files == null) {
            JSLibraryUtil.$$$reportNull$$$0(43);
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile[] virtualFiles = (VirtualFile[])ContainerUtil.map((Object[])files, arg_0 -> ((LocalFileSystem)fileSystem).refreshAndFindFileByNioFile(arg_0), (Object[])VirtualFile.EMPTY_ARRAY);
        JSLibraryUtil.markDirtyAndRefresh(async, recursive, reloadChildren, modalityState, finishRunnable, virtualFiles);
    }

    private static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, @NotNull ModalityState modalityState, @Nullable Runnable finishRunnable, VirtualFile ... files) {
        List list;
        if (modalityState == null) {
            JSLibraryUtil.$$$reportNull$$$0(44);
        }
        if (!(list = VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files)).isEmpty()) {
            RefreshQueue.getInstance().refresh(async, recursive, finishRunnable, modalityState, files);
        }
    }

    static {
        MIN_TO_DEV_VERSION_MAP.put("dojo.xd.js", "dojo.xd.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put("dojo.js", "dojo.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put("ext-core.js", "ext-core-debug.js");
        MIN_TO_DEV_VERSION_MAP.put("swfobject.js", "swfobject_src.js");
        MIN_TO_DEV_VERSION_MAP.put("webfont.js", "webfont_debug.js");
        HTTP_PREFIXES = new String[]{"http://", "https://"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 31: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLibraryFolder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLibraryFolders";
                break;
            }
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToStop";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileSystem";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryUtil";
                break;
            }
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryUtil";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentScopeWithoutLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDevVersionLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertLocationSuffixToNonMinimized";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isProbableLibraryFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedLibraryFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTopLibraryFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorLibraryDir";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFolder";
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasDirectoryInPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryInPath";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasAllDirectoriesInPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isProbableLibraryPath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "containsDirInPath";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "containsDirInSystemIndependentPath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findUpClosestNodeModulesResolveRoot";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findConfigFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIO";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getContentScopeWithoutLibraries";
                break;
            }
            case 37: {
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectAndOutsideOfLibraryRoots";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyAndRefresh";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 37 -> new IllegalStateException(string);
        };
    }
}

