/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.structureView;

import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

final class TypeScriptStructureItemPresentation
extends JSStructureItemPresentation {
    TypeScriptStructureItemPresentation(@NotNull JSStructureViewElementBase jsStructureViewElement) {
        if (jsStructureViewElement == null) {
            TypeScriptStructureItemPresentation.$$$reportNull$$$0(0);
        }
        super(jsStructureViewElement);
    }

    @Override
    protected String buildPresentationForElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TypeScriptStructureItemPresentation.$$$reportNull$$$0(1);
        }
        StringBuilder presentation = null;
        if (psiElement instanceof TypeScriptCallSignature) {
            presentation = new StringBuilder();
            presentation.append(((TypeScriptCallSignature)psiElement).isConstructor() ? "new" : "");
            presentation.append(JSFormatUtil.buildFunctionSignaturePresentation((JSFunction)psiElement));
        } else if (psiElement instanceof TypeScriptPropertySignature) {
            presentation = new StringBuilder();
            presentation.append(JSPsiImplUtils.getNameOrComputedPropertyName((TypeScriptPropertySignature)psiElement, true));
            JSTypeDeclaration type2 = ((TypeScriptPropertySignature)psiElement).getTypeDeclaration();
            if (type2 != null && !(type2 instanceof TypeScriptObjectType)) {
                presentation.append(this.getTypeSeparator());
                StringBuilder presentationFinal = presentation;
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(psiElement, () -> presentationFinal.append(TypeScriptStructureItemPresentation.getTypePresentation(type2)));
            }
        } else if (psiElement instanceof TypeScriptIndexSignature) {
            JSTypeDeclaration parameterType;
            TypeScriptIndexSignature indexSignature = (TypeScriptIndexSignature)psiElement;
            presentation = new StringBuilder("[");
            PsiElement nameElement = indexSignature.getParameterNameElement();
            if (nameElement != null) {
                presentation.append(nameElement.getText());
            }
            if ((parameterType = indexSignature.getParameterType()) != null) {
                presentation.append(this.getTypeSeparator());
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation(parameterType));
            }
            presentation.append("]");
            JSTypeDeclaration type3 = indexSignature.getType();
            if (type3 != null) {
                presentation.append(this.getTypeSeparator());
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation(type3));
            }
        } else if (psiElement instanceof TypeScriptClass) {
            TypeScriptClass typeScriptClass = (TypeScriptClass)psiElement;
            String name = typeScriptClass.getName();
            if (name == null) {
                name = JSFormatUtil.getAnonymousName(psiElement);
            }
            presentation = new StringBuilder(name);
            TypeScriptTypeParameterList list = typeScriptClass.getTypeParameterList();
            if (list != null) {
                presentation.append("<");
                presentation.append(StringUtil.join((Object[])list.getTypeParameters(), parameter -> StringUtil.notNullize((String)parameter.getName()), (String)", "));
                presentation.append(">");
            }
        }
        return presentation != null ? presentation.toString() : super.buildPresentationForElement(psiElement);
    }

    @NotNull
    private static String getTypePresentation(@NotNull JSTypeDeclaration type2) {
        if (type2 == null) {
            TypeScriptStructureItemPresentation.$$$reportNull$$$0(2);
        }
        String string = JSFormatUtil.formatType(type2.getJSType(), (PsiElement)type2, 8193);
        if (string == null) {
            TypeScriptStructureItemPresentation.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private String getTypeSeparator() {
        String string = JSSymbolPresentationProvider.getDefaultTypeSeparator(this.element.getElement());
        if (string == null) {
            TypeScriptStructureItemPresentation.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsStructureViewElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/structureView/TypeScriptStructureItemPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/structureView/TypeScriptStructureItemPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildPresentationForElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentation";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

