/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0003\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"NPX_PACKAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "VALID_NG_APP_NAME", "UNKNOWN_VERSION", "Lcom/intellij/util/text/SemVer;", "isPackageGreaterOrEqual", "", "pkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "major", "", "minor", "patch", "ng", "", "path", "validateFolderName", "label", "intellij.angular"})
public final class AngularCliProjectGeneratorKt {
    private static final Pattern NPX_PACKAGE_PATTERN = Pattern.compile("npx --package @angular/cli(?:@([0-9]+\\.[0-9]+\\.[0-9a-zA-Z-.]+))? ng");
    private static final Pattern VALID_NG_APP_NAME = Pattern.compile("[a-zA-Z][0-9a-zA-Z]*(-[a-zA-Z][0-9a-zA-Z]*)*");
    @NotNull
    private static final SemVer UNKNOWN_VERSION = new SemVer("0.0.0", 0, 0, 0);

    private static final boolean isPackageGreaterOrEqual(NodePackage pkg, int major, int minor, int patch) {
        SemVer ver = null;
        if (Intrinsics.areEqual((Object)pkg.getName(), (Object)"@angular/cli")) {
            ver = pkg.getVersion();
        } else {
            Matcher m = NPX_PACKAGE_PATTERN.matcher(pkg.getSystemIndependentPath());
            if (m.matches()) {
                ver = SemVer.parseFromText((String)m.group(1));
            }
        }
        return ver == null || ver.isGreaterOrEqualThan(major, minor, patch);
    }

    @NotNull
    public static final String ng(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path + File.separator + "bin" + File.separator + "ng";
    }

    @NlsContexts.DialogMessage
    private static final String validateFolderName(String path, String label) {
        String string;
        String string2 = PathUtil.getFileName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
        String fileName = string2;
        if (!VALID_NG_APP_NAME.matcher(fileName).matches()) {
            Object[] objectArray = new Object[]{label, fileName};
            string = XmlStringUtil.wrapInHtml((CharSequence)Angular2Bundle.Companion.message("angular.action.new-project.wrong-folder-name", objectArray));
        } else {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ boolean access$isPackageGreaterOrEqual(NodePackage pkg, int major, int minor, int patch) {
        return AngularCliProjectGeneratorKt.isPackageGreaterOrEqual(pkg, major, minor, patch);
    }

    public static final /* synthetic */ String access$validateFolderName(String path, String label) {
        return AngularCliProjectGeneratorKt.validateFolderName(path, label);
    }

    public static final /* synthetic */ SemVer access$getUNKNOWN_VERSION$p() {
        return UNKNOWN_VERSION;
    }
}

