/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import java.util.Arrays;
import org.eclipse.lsp4j.debug.util.ToStringBuilder;

/**
 * Response to 'setExceptionBreakpoints' request.
 * <p>
 * The response contains an array of Breakpoint objects with information about each exception breakpoint or filter.
 * The Breakpoint objects are in the same order as the elements of the 'filters', 'filterOptions', 'exceptionOptions'
 * arrays given as arguments. If both 'filters' and 'filterOptions' are given, the returned array must start with
 * 'filters' information first, followed by 'filterOptions' information.
 * <p>
 * The 'verified' property of a Breakpoint object signals whether the exception breakpoint or filter could
 * be successfully created and whether the condition or hit count expressions are valid. In case of an error
 * the 'message' property explains the problem. The 'id' property can be used to introduce a unique ID for the
 * exception breakpoint or filter so that it can be updated subsequently by sending breakpoint events.
 * <p>
 * For backward compatibility both the 'breakpoints' array and the enclosing 'body' are optional. If these elements
 * are missing a client is not able to show problems for individual exception breakpoints or filters.
 */
@SuppressWarnings("all")
public class SetExceptionBreakpointsResponse {
  /**
   * Information about the exception breakpoints or filters.
   * <p>
   * The breakpoints returned are in the same order as the elements of the
   * 'filters', 'filterOptions', 'exceptionOptions' arrays in the arguments.
   * If both 'filters' and 'filterOptions' are given, the returned array must
   * start with 'filters' information first, followed by 'filterOptions'
   * information.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.47
   */
  private Breakpoint[] breakpoints;

  /**
   * Information about the exception breakpoints or filters.
   * <p>
   * The breakpoints returned are in the same order as the elements of the
   * 'filters', 'filterOptions', 'exceptionOptions' arrays in the arguments.
   * If both 'filters' and 'filterOptions' are given, the returned array must
   * start with 'filters' information first, followed by 'filterOptions'
   * information.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.47
   */
  public Breakpoint[] getBreakpoints() {
    return this.breakpoints;
  }

  /**
   * Information about the exception breakpoints or filters.
   * <p>
   * The breakpoints returned are in the same order as the elements of the
   * 'filters', 'filterOptions', 'exceptionOptions' arrays in the arguments.
   * If both 'filters' and 'filterOptions' are given, the returned array must
   * start with 'filters' information first, followed by 'filterOptions'
   * information.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.47
   */
  public void setBreakpoints(final Breakpoint[] breakpoints) {
    this.breakpoints = breakpoints;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("breakpoints", this.breakpoints);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    SetExceptionBreakpointsResponse other = (SetExceptionBreakpointsResponse) obj;
    if (this.breakpoints == null) {
      if (other.breakpoints != null)
        return false;
    } else if (!Arrays.deepEquals(this.breakpoints, other.breakpoints))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.breakpoints== null) ? 0 : Arrays.deepHashCode(this.breakpoints));
  }
}
