/*

  Nosuid TCP/IP ping POINK_VER by Mariusz Mazur <mmazur@kernel.pl>
  This code is 80% original lcamtuf's code but don't tell anyone
  ---------------------------------------------------------------
 
  The Nosuid TCP/IP ping and related utilities are free software; you
  can redistribute it and/or modify it under the terms of the GNU Library
  General Public License as published by the Free Software Foundation;
  either version 2 of the License, or (at your option) any later version.
 
*/

#define DEF_DELAY		1
#define DEF_TIMEOUT		5

#define POINK_VER "2.03"


#include <stdio.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdarg.h>
#include <errno.h>
#include <signal.h>
#include <getopt.h>
#include <stdlib.h>
#include <string.h>


#ifdef HAVE_IPV6
typedef struct sockaddr_in6    SOCKADDR_IN;
int family = AF_INET6;
#define POINK "ping6"
#else
typedef struct sockaddr_in     SOCKADDR_IN;
int family = AF_INET;
#define POINK "ping"
#endif



int to,tamto,count=0,got,min,max,trip,skew,n=1,errorcount=0;
struct timeval first_ping, last_ping;
char ad[20];
char *progname;


void xerr(void)
{
	perror(progname);
	exit(errno);
}


void usage(void)
{
	fprintf(stderr, 
			"  usage: %s [ -i delay ] [ -c count ] [ -t timeout] host\n",
			progname);
	exit(2);
}


void alrm(int x)
{
	to=1;
}


void stats(int x)
{
	int totaltime;
	
	gettimeofday(&last_ping,NULL);

	totaltime=(last_ping.tv_sec-first_ping.tv_sec)*1000+
		            (last_ping.tv_usec-first_ping.tv_usec)/1000;

	printf("\n--- %s ping statistics ---\n", ad);
	printf("%d packet(s) transmitted, %d received, %d%% loss, %d error(s), "
			"time %dms\n", 	n-1, got, (n-1-got)*100/(n-1),
			errorcount, totaltime);
	printf("round-trip statistics min/avg/max: ");
	if (got)
	{
		printf("%.3f/%.3f/%.3f msec", (float)min/1000, (float)trip/got/1000,
				(float)max/1000);
		
		if (min/1000<=0.1) 
			printf(" (%d/%d/%d usec)", min, trip/got, max);
		
		printf("\n");
	}
	else
		printf("(not available due to 100%% packet loss)\n");
	
	exit(0);
}


int main(int argc,char* argv[])
{
	struct hostent *hp;
	SOCKADDR_IN s;
	struct timeval ping_start, ping_end;
	struct sigaction siga;
	char ch, pingerror[100];
	int delay=DEF_DELAY,timeout=DEF_TIMEOUT;
	int suck, tmp, port=65535;

  
	printf("Nosuid TCP/IP %s %s by <mmazur@kernel.pl>\n", POINK, POINK_VER);


	progname=argv[0];

	while ((ch=getopt(argc,argv,"i:t:c:")) != EOF)
		switch(ch)
		{
		  case 'c':
        	count=atoi(optarg);
        	if (count<0)
			{
				fprintf(stderr, "%s: invalid number of pings\n", progname);
				exit(2);
			}
        	break;

		  case 'i':
			delay=atoi(optarg);
        	if (delay<1 || delay>1000)
			{
				fprintf(stderr, "%s: invalid ping delay\n", progname);
				exit(2);
			}
			break;

	      case 't':
    	    timeout=atoi(optarg);
        	if (timeout<1 || timeout>100)
			{
				fprintf(stderr, "%s: invalid ping timeout\n", progname);
				exit(2);
			}
			break;

		  default:
			usage();
    }
    
	if (argc-optind!=1)
		usage();

	min=timeout*1000000;

#ifdef HAVE_IPV6
	hp=gethostbyname2(argv[optind], family);
#else
	hp=gethostbyname(argv[optind]);
#endif

	if (!hp)
	{
		fprintf(stderr, "%s: host not found\n", progname);
		exit(1);
	}

//	IPV6 addresses are to long to print on screen (same behaviour as in
//	iputils ping6
	
#ifdef HAVE_IPV6
	sprintf(ad, "%s", argv[optind]);
#else
	tmp=*(long*)hp->h_addr;

	sprintf(ad,"%d.%d.%d.%d", tmp & 0xff, tmp>>8 & 0xff, tmp>>16 & 0xff,
			tmp>>24 & 0xff);
#endif

	signal(SIGINT,stats);

	if (count) 
		printf("Pinging %s (%s) - %d packet(s), delay %d sec(s),"
				"timeout %d sec(s)\n", *hp->h_name?hp->h_name:ad, ad, count,
				delay, timeout);
	else
		printf("Pinging %s (%s) - delay %d sec(s), timeout %d sec(s)\n",
				*hp->h_name?hp->h_name:ad, ad, delay, timeout);

	gettimeofday(&first_ping,NULL);

	while (n++<=count || !count)
	{
#ifdef HAVE_IPV6
		bcopy(hp->h_addr, (void*)&s.sin6_addr, hp->h_length);
		s.sin6_family=hp->h_addrtype;
		s.sin6_port=htons(port);
#else
		bcopy(hp->h_addr, (void*)&s.sin_addr, hp->h_length);
		s.sin_family=hp->h_addrtype;
		s.sin_port=htons(port);
#endif
		if ((suck=socket(family,SOCK_STREAM,0))<0)
			xerr();
		siga.sa_handler=alrm;
		to=tamto=skew=siga.sa_flags=0;

		sigaction(SIGALRM,&siga,NULL);
		alarm(timeout);

		gettimeofday(&ping_start,NULL);

		if ((skew=!connect(suck,(struct sockaddr *)&s, sizeof(s))) || 1)
		{
			if (to || errno==EINTR)
				sprintf(pingerror, "No ping reply within %d second(s)",
						timeout);
			
			else if (errno==EHOSTUNREACH)
				sprintf(pingerror, "Destination host unreachable");

			else if (errno==EHOSTDOWN)
				sprintf(pingerror, "Destination host is down");

			else if (errno && errno!=ECONNREFUSED)
				xerr();

			if(to || (errno && errno!=ECONNREFUSED))
			{
				printf("While pinging %s: seq=%d %s\n", ad, n-1, pingerror);
				errorcount++;
				tamto=timeout;
			}
		}

		gettimeofday(&ping_end,NULL);

		if (!tamto)
		{
		tmp=(ping_end.tv_sec-ping_start.tv_sec)*1000000+
			ping_end.tv_usec-ping_start.tv_usec;

		if (tmp/1000>=100)
			printf("Ping reply from %s: seq=%d time=%.0f msec%s\n",
					ad, n-1, (float)tmp/1000, skew?" (skew!)":"");
		else if (tmp/1000>=0.1)
			printf("Ping reply from %s: seq=%d time=%.3f msec%s\n",
					ad, n-1, (float)tmp/1000, skew?" (skew!)":"");
		else
			printf("Ping reply from %s: seq=%d time=%d usec%s\n",
					ad, n-1, tmp, skew?" (skew!)":"");
		got++;
		trip+=tmp;
		port-=skew;
		if (tmp>max)
			max=tmp;
		if (tmp<min)
			min=tmp;
		}
		else 
			port-=1;

		shutdown(suck,2);
		close(suck);
		alarm(0);
		if (n<=count || !count) 
			sleep(delay);
	}
	n--;
	stats(0);

	return(0);
}

