/*  job_printintegralinfo.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_PRINTINTEGRALINFO_H_
#define JOB_PRINTINTEGRALINFO_H_

#include "job.h"

namespace Reduze {

/// Job template
class PrintIntegralInfo: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("print_integral_info");
		s.set_short_description("Prints info about integrals.");
		s.set_long_description("Prints and exports information about "
				" integrals.");
		s.add_option("input_file", true, "string", ""
				"Name of input file containing integrals to consider.");
		s.add_option("loopedia_file", true, "string", ""
				"Name of output file suitable for a Loopedia submission.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	PrintIntegralInfo() {
		add_auto_options();
	}
	virtual ~PrintIntegralInfo() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_file_);
		add_auto_io("loopedia_file", loopedia_file_);
	}
	virtual void init();
private:
	std::string input_file_, loopedia_file_;
};

}

#endif /* JOB_PRINTINTEGRALINFO_H_ */
