/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import de.renier.vdr.channel.editor.util.LocalProperties;
import de.renier.vdr.channel.editor.util.Utils;



public class Messages {
  private static final String BUNDLE_NAME = "de.renier.vdr.channel.editor.messages"; //$NON-NLS-1$

  private static final ResourceBundle RESOURCE_BUNDLE;

  static {
    // get locale from property
    String systemLanguage = LocalProperties.getInstance().getProperty(LocalProperties.PROP_SYSTEM_LANGUAGE);
    if (Utils.isEmpty(systemLanguage)) {
      systemLanguage = Locale.getDefault().getLanguage();
    }
    
    // get locale from string
    Locale locale = new Locale(systemLanguage);
    
    // init resource bundle
    RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, locale);
  }  

  private Messages() {
  }

  public static String getString(String key) {
    try {
      return RESOURCE_BUNDLE.getString(key);
    } catch (MissingResourceException e) {
      return '!' + key + '!';
    }
  }
}
