/************************************************************/
/*                                                          */
/* Module ID  - diag0.                                      */
/*                                                          */
/* Function   - Retrieve buffer containing DIAG 0 reults.   */
/*                                                          */
/* Called By  - N/A.                                        */
/*                                                          */
/* Calling To - N/A.                                        */
/*                                                          */
/* Parameters - (1) Command.                                */
/*              DESCRIPTION: Command to be executed.        */
/*                                                          */
/* Notes      - (1) Uses /dev/cpcmdx to communicate with CP */
/*                                                          */
/*              (2) ....................................... */
/*                                                          */
/*                                                          */
/* Name       - Neale Ferguson.                             */
/*                                                          */
/* Date       - January, 2000.                              */
/*                                                          */
/*                                                          */
/* Associated    - (1) Refer To ........................... */
/* Documentation                                            */
/*                 (2) Refer To ........................... */
/*                                                          */
/************************************************************/

/************************************************************/
/*                                                          */
/*                     DEFINES                              */
/*                     -------                              */
/*                                                          */
/************************************************************/

#define CPDEV 		"/dev/cpid"

/*=============== End of Defines ===========================*/

/************************************************************/
/*                                                          */
/*              INCLUDE STATEMENTS                          */
/*              ------------------                          */
/*                                                          */
/************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <linux/ioctl.h>

/*================== End of Include Statements =============*/

/************************************************************/
/*                                                          */
/*              TYPE DEFINITIONS                            */
/*              ----------------                            */
/*                                                          */
/************************************************************/

/* Use 'r' as magic number */
#define IDCMD_IOC_MAGIC  'r'

#define IDCMD_IOCRESET    _IO(IDCMD_IOC_MAGIC, 0)
#define IDGETBF           _IOR(IDCMD_IOC_MAGIC, 1, char*)

/*================== End of Type Definitions ===============*/

/************************************************************/
/*                                                          */
/*             FUNCTION PROTOTYPES                          */
/*             -------------------                          */
/*                                                          */
/************************************************************/

/*================== End of Prototypes =====================*/

/************************************************************/
/*                                                          */
/*           GLOBAL VARIABLE DECLARATIONS                   */
/*           ----------------------------                   */
/*                                                          */
/************************************************************/

/*============== End of Variable Declarations ==============*/

/************************************************************/
/*                                                          */
/* Name       - main.                                       */
/*                                                          */
/* Function   - Open the CP command device.                 */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*                                                          */
/************************************************************/

int
main(int argc, char **argv)
{
	int fd, rc, i, j, exitRc = 0;
	char response[40];

	fd = open(CPDEV, O_RDWR);
	if (fd >= 0) {
		rc = ioctl(fd, IDGETBF, &response);
		if (rc != 0) {
			exitRc = errno;
			fprintf(stderr, "IOCTL: %s\n", strerror(errno));
		} else {
			for (i = 0; i < 5; i++) {
				for (j = 0; j < 8; j++) {
					printf("%02X ", response[i * 8 + j]);
				}
				printf("\n");
			}
		}
	} else
		fprintf(stderr, "OPEN: %s\n", strerror(errno));
	close(fd);
	exit(exitRc);
}

/*===================== End of Function ====================*/
