/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rnc;

import com.thaiopensource.relaxng.parse.SchemaBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class NamespaceManager {
    private final Map<String, Boolean> requiredNamespaces = new HashMap<String, Boolean>();
    private static final String[] conventionalBindings = new String[]{"", SchemaBuilder.INHERIT_NS, "inherit", SchemaBuilder.INHERIT_NS, "", "", "local", "", "rng", "http://relaxng.org/ns/structure/1.0", "a", "http://relaxng.org/ns/compatibility/annotations/1.0"};
    private final Map<Binding, BindingUsage> bindingUsageMap = new HashMap<Binding, BindingUsage>();

    NamespaceManager() {
    }

    void requireNamespace(String string, boolean bl) {
        Boolean bl2 = this.requiredNamespaces.get(string);
        if (bl2 == null || bl2.booleanValue() && !bl) {
            bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.requiredNamespaces.put(string, bl2);
        }
    }

    void requireBinding(String string, String string2) {
        this.noteBinding(string, string2, true);
    }

    void preferBinding(String string, String string2) {
        this.noteBinding(string, string2, false);
    }

    private void noteBinding(String string, String string2, boolean bl) {
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        Binding binding = new Binding(string, string2);
        BindingUsage bindingUsage = this.bindingUsageMap.get(binding);
        if (bindingUsage == null) {
            bindingUsage = new BindingUsage();
            this.bindingUsageMap.put(binding, bindingUsage);
        }
        if (bl) {
            bindingUsage.required = true;
        }
        ++bindingUsage.usageCount;
    }

    /*
     * WARNING - void declaration
     */
    NamespaceBindings createBindings() {
        Object object;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        hashMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        hashMap2.put("http://www.w3.org/XML/1998/namespace", "xml");
        this.requiredNamespaces.remove("http://www.w3.org/XML/1998/namespace");
        Vector<Binding> vector = new Vector<Binding>();
        vector.addAll(this.bindingUsageMap.keySet());
        Collections.sort(vector, new BindingComparator());
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Binding object22 = (Binding)iterator.next();
            if (hashMap.get(object22.prefix) != null) continue;
            object = this.requiredNamespaces.get(object22.namespaceUri);
            boolean bl2 = bl = object != null && (object22.prefix.length() > 0 || ((Boolean)object).booleanValue());
            if (!this.bindingUsageMap.get((Object)object22).required && !bl) continue;
            hashMap.put(object22.prefix, object22.namespaceUri);
            iterator.remove();
            if (bl) {
                this.requiredNamespaces.remove(object22.namespaceUri);
            }
            if (object22.prefix.length() <= 0) continue;
            hashMap2.put(object22.namespaceUri, object22.prefix);
        }
        for (Binding binding : vector) {
            if (hashMap.get(binding.prefix) != null) continue;
            hashMap.put(binding.prefix, binding.namespaceUri);
        }
        for (int i = 0; i < conventionalBindings.length; i += 2) {
            Boolean bl;
            String string = conventionalBindings[i];
            if (hashMap.get(string) != null || (bl = this.requiredNamespaces.get(object = conventionalBindings[i + 1])) == null || string.length() <= 0 && !bl.booleanValue()) continue;
            hashMap.put(string, object);
            this.requiredNamespaces.remove(object);
            if (string.length() <= 0) continue;
            hashMap2.put(object, string);
        }
        Iterator<String> iterator2 = this.requiredNamespaces.keySet().iterator();
        boolean bl = true;
        while (iterator2.hasNext()) {
            void var5_13;
            object = "ns" + Integer.toString((int)var5_13);
            if (hashMap.get(object) == null) {
                String string = iterator2.next();
                hashMap.put(object, string);
                hashMap2.put(string, object);
            }
            ++var5_13;
        }
        return new NamespaceBindings(hashMap, hashMap2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BindingComparator
    implements Comparator<Binding> {
        private BindingComparator() {
        }

        @Override
        public int compare(Binding binding, Binding binding2) {
            BindingUsage bindingUsage = (BindingUsage)NamespaceManager.this.bindingUsageMap.get(binding);
            BindingUsage bindingUsage2 = (BindingUsage)NamespaceManager.this.bindingUsageMap.get(binding2);
            if (bindingUsage.required != bindingUsage2.required) {
                return bindingUsage.required ? -1 : 1;
            }
            if (bindingUsage.usageCount != bindingUsage2.usageCount) {
                return bindingUsage2.usageCount - bindingUsage.usageCount;
            }
            if (binding.prefix.length() != binding2.prefix.length()) {
                return binding.prefix.length() - binding2.prefix.length();
            }
            int n = binding.prefix.compareTo(binding2.prefix);
            if (n != 0) {
                return n;
            }
            return binding.namespaceUri.compareTo(binding2.namespaceUri);
        }
    }

    static class BindingUsage {
        boolean required;
        int usageCount;

        BindingUsage() {
        }
    }

    static class Binding {
        private final String prefix;
        private final String namespaceUri;

        Binding(String string, String string2) {
            this.prefix = string;
            this.namespaceUri = string2;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getNamespaceUri() {
            return this.namespaceUri;
        }

        public int hashCode() {
            return this.prefix.hashCode() ^ this.namespaceUri.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Binding)) {
                return false;
            }
            Binding binding = (Binding)object;
            return this.prefix.equals(binding.prefix) && this.namespaceUri.equals(binding.namespaceUri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamespaceBindings {
        private final Map<String, String> prefixMap;
        private final Map<String, String> nsMap;

        private NamespaceBindings(Map<String, String> map, Map<String, String> map2) {
            this.prefixMap = map;
            this.nsMap = map2;
        }

        String getNonEmptyPrefix(String string) {
            return this.nsMap.get(string);
        }

        String getNamespaceUri(String string) {
            return this.prefixMap.get(string);
        }

        Set<String> getPrefixes() {
            return this.prefixMap.keySet();
        }
    }
}

