/**
 * Copyright (c) 2025, Fabian Groffen. All rights reserved.
 *
 * See LICENSE for the license.
 */

#ifndef UTIL_H
#define UTIL_H 1

#include <stdbool.h>
#include <ldns/ldns.h>

extern const char *FGCOLOUR_RED;
extern const char *FGCOLOUR_GREEN;
extern const char *FGCOLOUR_YELLOW;
extern const char *FGCOLOUR_BLUE;
extern const char *FGCOLOUR_MAGENTA;
extern const char *FGCOLOUR_CYAN;
extern const char *FGCOLOUR_NORM;

extern const char *FGCOLOUR_BRRED;
extern const char *FGCOLOUR_BRGREEN;
extern const char *FGCOLOUR_BRYELLOW;
extern const char *FGCOLOUR_BRBLUE;
extern const char *FGCOLOUR_BRMAGENTA;
extern const char *FGCOLOUR_BRCYAN;

void
util_enable_colours
(
    bool enable
);

ldns_rdf *
util_addr2dname
(
    ldns_rdf *input,
    bool      useip6intdomain
);

ldns_rdf *
util_dname_frm_str
(
    const char *input,
    uint8_t     ndots,
    bool        useip6intdomain
);

ldns_rdf **
util_addr_frm_str
(
    ldns_resolver *res,
    const char    *input,
    uint8_t        ndots
);

#endif
