/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    Callback completion_handler_callback;
    NSOpenPanel panel;
    String directoryPath;
    String message = "";
    String filterPath = "";

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        if (Display.getSheetEnabled() && parent != null && (style & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    long _completionHandler(long result) {
        this.handleResponse(result);
        return result;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    void handleResponse(long response) {
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            NSApplication.sharedApplication().stopModal();
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(null);
        if (response == 1L) {
            NSString filename = this.panel.filename();
            this.directoryPath = this.filterPath = filename.getString();
        }
        this.releaseHandles();
    }

    public String open() {
        this.directoryPath = null;
        this.panel = NSOpenPanel.openPanel();
        this.panel.setCanCreateDirectories(true);
        this.panel.setAllowsMultipleSelection((this.style & 2) != 0);
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        this.panel.setMessage(NSString.stringWith(this.message != null ? this.message : ""));
        this.panel.setCanChooseFiles(false);
        this.panel.setCanChooseDirectories(true);
        this.panel.setTreatsFilePackagesAsDirectories(true);
        NSString dir = this.filterPath != null && this.filterPath.length() > 0 ? NSString.stringWith(this.filterPath) : null;
        this.panel.setDirectoryURL(NSURL.fileURLWithPath(dir));
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(this, this.panel);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            this.completion_handler_callback = new Callback(this, "_completionHandler", 1);
            long handler = this.completion_handler_callback.getAddress();
            OS.beginSheetModalForWindow(this.panel, this.parent.view.window(), handler);
            NSApplication.sharedApplication().runModalForWindow(this.parent.view.window());
        } else {
            long response = this.panel.runModal();
            this.handleResponse(response);
        }
        return this.directoryPath;
    }

    void releaseHandles() {
        if (this.completion_handler_callback != null) {
            this.completion_handler_callback.dispose();
            this.completion_handler_callback = null;
        }
        this.panel = null;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

