//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  File:   G4AtomicShells_XDB_EADL.cc                                        //
//  Author: D.H. Wright (SLAC)                                                //
//  Date:   9 August 2018                                                     //
//                                                                            //
//  Description: Class containing number of shells, electron configurations   //
//               and binding energies for atoms from Z = 1 to Z = 120.        //
//               Most entries are taken from the X-ray Data Book, with        //
//               unmeasured values supplied by Kibedi.  See documentation     //
//               file in G4EMLOW7.3 or later, directory fluor/                //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include "G4AtomicShells_XDB_EADL.hh"

#include "G4SystemOfUnits.hh"

// clang-format off
const G4int G4AtomicShells_XDB_EADL::fNumberOfShells[121] =
{
  1,   // nonexistent zero element
  1,  1,  2,  2,  3,   3,  4,  4,  4,  4, //   1 - 10
  5,  5,  6,  6,  7,   7,  7,  7,  8,  8, //  11 - 20
  9,  9,  9, 10, 10,  10, 10, 10, 10, 10, //  21 - 30
 11, 11, 12, 12, 12,  12, 13, 13, 14, 14, //  31 - 40
 14, 15, 15, 15, 15,  14, 15, 15, 16, 16, //  41 - 50
 17, 17, 17, 17, 18,  18, 19, 21, 21, 20, //  51 - 60
 19, 20, 20, 21, 21,  20, 20, 20, 20, 20, //  61 - 70
 21, 21, 21, 21, 22,  22, 22, 22, 22, 22, //  71 - 80
 23, 23, 24, 24, 24,  24, 25, 25, 26, 26, //  81 - 90
 27, 27, 27, 26, 27,  28, 28, 27, 27, 27, //  91 - 100
 27, 27, 28, 28, 28,  28, 29, 29, 29, 29, // 101 - 110
 29, 29, 30, 30, 31,  31, 31, 31, 32, 32  // 111 - 120
};

const G4int G4AtomicShells_XDB_EADL::fIndexOfShells[121] =
{
    0,   // nonexistent zero element
    1,    2,    3,    5,    7,     10,   13,   17,   21,   25, //   1 - 10
   29,   34,   39,   45,   51,     58,   65,   72,   79,   87, //  11 - 20
    95,  104, 113,  122,  132,    142,  152,  162,  172,  182, //  21 - 30
  192,  203,  214,  226,  238,    250,  262,  275,  288,  302, //  31 - 40
  316,  330,  345,  360,  375,    390,  404,  419,  434,  450, //  41 - 50
  466,  483,  500,  517,  534,    552,  570,  589,  610,  631, //  51 - 60
  651,  670,  690,  710,  731,    752,  772,  792,  812,  832, //  61 - 70
  852,  873,  894,  915,  936,    958,  980, 1002, 1024, 1046, //  71 - 80
 1068, 1091, 1114, 1138, 1162,   1186, 1210, 1235, 1260, 1286, //  81 - 90
 1312, 1339, 1366, 1393, 1419,   1446, 1474, 1502, 1529, 1556, //  91 - 100
 1583, 1610, 1637, 1665, 1693,   1721, 1749, 1778, 1807, 1836, // 101 - 110
 1865, 1894, 1923, 1953, 1983,   2014, 2045, 2076, 2107, 2139  // 111 - 120
};

const G4double G4AtomicShells_XDB_EADL::fBindingEnergies[2171] =
{
  0.0,  // nonexistent zero element

  // H   ---------------------------------------------------------------------
  0.0136,

  // He  ---------------------------------------------------------------------
  0.0246,

  // Li  ---------------------------------------------------------------------
  0.0547,  0.0054,

  // Be  ---------------------------------------------------------------------
  0.1115,  0.0093,

  // B   ---------------------------------------------------------------------
  0.1880,  0.0126,  0.0047,

  // C   ---------------------------------------------------------------------
  0.2842,  0.0181,  0.0090,

  // N   ---------------------------------------------------------------------
  0.4099,  0.0373,  0.0089,  0.0097,

  // O   ---------------------------------------------------------------------
  0.5431,  0.0416,  0.0068,  0.0074,

  // F   ---------------------------------------------------------------------
  0.6967,  0.0340,  0.0084,  0.0087,

  // Ne  ---------------------------------------------------------------------
  0.8702,  0.0485,  0.0217,  0.0216,

  // Na  ---------------------------------------------------------------------
  1.0708,  0.0635,  0.03065,   0.03081,   0.0007,

  // Mg  ---------------------------------------------------------------------
  1.3030,  0.0887,  0.04978,   0.0495,  0.0021,

  // Al  ---------------------------------------------------------------------
  1.5596,  0.1178,  0.07295,   0.07255,   0.0007,  0.0060,

  // Si  ---------------------------------------------------------------------
  1.8390,  0.1497,  0.09982,   0.09942,   0.0076,  0.0030,

  // P   ---------------------------------------------------------------------
  2.1455,  0.1890,  0.1360,  0.1350,  0.0162,  0.0096,  0.0101,

  // S   ---------------------------------------------------------------------
  2.4720,  0.2309,  0.1636,  0.1625,  0.0158,  0.0078,  0.0082,

  // Cl  ---------------------------------------------------------------------
  2.8224,  0.2700,  0.2020,  0.2000,  0.0175,  0.0067,  0.0067,

  // Ar  ---------------------------------------------------------------------
  3.2059,  0.3263,  0.2506,  0.2484,  0.0293,  0.0159,  0.0157,

  // K   ---------------------------------------------------------------------
  3.6084,  0.3786,  0.2973,  0.2946,  0.0348,  0.0183,  0.0183,
  0.0001,

  // Ca  ---------------------------------------------------------------------
  4.0385,  0.4384,  0.3497,  0.3462,  0.0443,  0.0254,  0.0254,
  0.0018,

  // Sc  ---------------------------------------------------------------------
  4.4920,  0.4980,  0.4036,  0.3987,  0.0511,  0.0283,  0.0283,
  0.0066,  0.0017,

  // Ti  ---------------------------------------------------------------------
  4.9660,  0.5609,  0.4602,  0.4538,  0.0587,  0.0326,  0.0326,
  0.0037,  0.0016,

  // V   ---------------------------------------------------------------------
  5.4650,  0.6267,  0.5198,  0.5121,  0.0663,  0.0372,  0.0372,
  0.0022,  0.0017,

  // Cr  ---------------------------------------------------------------------
  5.9890,  0.6960,  0.5838,  0.5741,  0.0741,  0.0422,  0.0422,
  0.0029,  0.0022,  0.0010,

  // Mn  ---------------------------------------------------------------------
  6.5390,  0.7691,  0.6499,  0.6387,  0.0823,  0.0472,  0.0472,
  0.0035,  0.0027,  0.0019,

  // Fe  ---------------------------------------------------------------------
  7.1120,  0.8446,  0.7199,  0.7068,  0.0913,  0.0527,  0.0527,
  0.0039,  0.0031,  0.0021,

  // Co  ---------------------------------------------------------------------
  7.7090,  0.9251,  0.7932,  0.7781,  0.1010,  0.0589,  0.0599,
  0.0033,  0.0027,  0.0019,

  // Ni  ---------------------------------------------------------------------
  8.3330,  1.0086,  0.8700,  0.8527,  0.1108,  0.0680,  0.0662,
  0.0039,  0.0033,  0.0022,

  // Cu  ---------------------------------------------------------------------
  8.9790,  1.0967,  0.9523,  0.9327,  0.1225,  0.0773,  0.0751,
  0.0018,  0.0015,  0.0012,

  // Zn  ---------------------------------------------------------------------
  9.6590,  1.1962,  1.0449,  1.0218,  0.1398,  0.0914,  0.0886,
  0.0102,  0.0101,  0.0013,

  // Ga  ---------------------------------------------------------------------
   10.3670,  1.2990,  1.1432,  1.1164,  0.1595,  0.1035,  0.1000,
  0.0187,  0.0187,  0.0056,  0.0008,

  // Ge  ---------------------------------------------------------------------
   11.1030,  1.4146,  1.2481,  1.2170,  0.1801,  0.1249,  0.1208,
  0.0298,  0.0292,  0.0090,  0.0023,

  // As  ---------------------------------------------------------------------
   11.8670,  1.5270,  1.3591,  1.3236,  0.2047,  0.1462,  0.1412,
  0.0417,  0.0417,  0.0125,  0.0025,  0.0025,

  // Se  ---------------------------------------------------------------------
   12.6580,  1.6520,  1.4743,  1.4339,  0.2296,  0.1665,  0.1607,
  0.0555,  0.0546,  0.0162,  0.0056,  0.0056,

  // Br  ---------------------------------------------------------------------
   13.4740,  1.7820,  1.5960,  1.5500,  0.2570,  0.1890,  0.1820,
  0.0700,  0.0690,  0.0273,  0.0052,  0.0046,

  // Kr  ---------------------------------------------------------------------
   14.3260,  1.9210,  1.7309,  1.6784,  0.2928,  0.2222,  0.2144,
  0.0950,  0.0938,  0.0275,  0.0141,  0.0141,

  // Rb  ---------------------------------------------------------------------
   15.2000,  2.0650,  1.8640,  1.8040,  0.3267,  0.2487,  0.2391,
  0.1130,  0.1120,  0.0305,  0.0163,  0.0153,  0.0040,

  // Sr  ---------------------------------------------------------------------
   16.1050,  2.2160,  2.0070,  1.9400,  0.3587,  0.2803,  0.2700,
  0.1360,  0.1342,  0.0389,  0.0213,  0.0201,  0.0050,

  // Y   ---------------------------------------------------------------------
   17.0380,  2.3730,  2.1560,  2.0800,  0.3920,  0.3106,  0.2988,
  0.1577,  0.1558,  0.0438,  0.0244,  0.0231,  0.0024,  0.0060,

  // Zr  ---------------------------------------------------------------------
   17.9980,  2.5320,  2.3070,  2.2230,  0.4303,  0.3435,  0.3298,
  0.1811,  0.1788,  0.0506,  0.0285,  0.0271,  0.0030,  0.0070,

  // Nb  ---------------------------------------------------------------------
   18.9860,  2.6980,  2.4650,  2.3710,  0.4666,  0.3761,  0.3606,
  0.2050,  0.2023,  0.0564,  0.0326,  0.0308,  0.0032,  0.0070,

  // Mo  ---------------------------------------------------------------------
   20.0000,  2.8660,  2.6250,  2.5200,  0.5063,  0.4116,  0.3940,
  0.2311,  0.2279,  0.0632,  0.0376,  0.0355,  0.0019,  0.0012,
  0.0070,

  // Tc  ---------------------------------------------------------------------
   21.0440,  3.0430,  2.7930,  2.6770,  0.5440,  0.4476,  0.4177,
  0.2576,  0.2539,  0.0695,  0.0423,  0.0399,  0.0020,  0.0012,
  0.0070,

  // Ru  ---------------------------------------------------------------------
   22.1170,  3.2240,  2.9670,  2.8380,  0.5861,  0.4835,  0.4614,
  0.2842,  0.2800,  0.0750,  0.0463,  0.0432,  0.0024,  0.0018,
  0.0070,

  // Rh  ---------------------------------------------------------------------
   23.2200,  3.4120,  3.1460,  3.0040,  0.6281,  0.5213,  0.4965,
  0.3119,  0.3072,  0.0814,  0.0505,  0.0473,  0.0028,  0.0022,
  0.0070,

  // Pd  ---------------------------------------------------------------------
   24.3500,  3.6040,  3.3300,  3.1730,  0.6716,  0.5599,  0.5323,
  0.3405,  0.3352,  0.0871,  0.0557,  0.0509,  0.0017,  0.0013,

  // Ag  ---------------------------------------------------------------------
   25.5140,  3.8060,  3.5240,  3.3510,  0.7190,  0.6038,  0.5730,
  0.3740,  0.3683,  0.0970,  0.0637,  0.0583,  0.0036,  0.0031,
  0.0080,

  // Cd  ---------------------------------------------------------------------
   26.7110,  4.0180,  3.7270,  3.5380,  0.7720,  0.6526,  0.6184,
  0.4119,  0.4052,  0.1098,  0.0639,  0.0639,  0.0117,  0.0107,
  0.0090,

  // In  ---------------------------------------------------------------------
   27.9400,  4.2380,  3.9380,  3.7300,  0.8272,  0.7032,  0.6653,
  0.4514,  0.4439,  0.1229,  0.0735,  0.0735,  0.0177,  0.0169,
  0.0001,  0.0008,

  // Sn  ---------------------------------------------------------------------
   29.2000,  4.4650,  4.1560,  3.9290,  0.8847,  0.7565,  0.7146,
  0.4932,  0.4849,  0.1371,  0.0836,  0.0836,  0.0249,  0.0239,
  0.0009,  0.0011,

  // Sb  ---------------------------------------------------------------------
   30.4910,  4.6980,  4.3800,  4.1320,  0.9460,  0.8127,  0.7664,
  0.5375,  0.5282,  0.1532,  0.0956,  0.0956,  0.0333,  0.0321,
  0.0067,  0.0022,  0.0020,

  // Te  ---------------------------------------------------------------------
   31.8140,  4.9390,  4.6120,  4.3410,  1.0060,  0.8708,  0.8200,
  0.5834,  0.5730,  0.1694,  0.1033,  0.1033,  0.0419,  0.0404,
  0.0116,  0.0026,  0.0020,

  // I   ---------------------------------------------------------------------
   33.1690,  5.1880,  4.8520,  4.5570,  1.0720,  0.9310,  0.8750,
  0.6308,  0.6193,  0.1860,  0.1230,  0.1230,  0.0506,  0.0489,
  0.0136,  0.0038,  0.0029,

  // Xe  ---------------------------------------------------------------------
   34.5610,  5.4530,  5.1070,  4.7860,  1.1487,  1.0021,  0.9406,
  0.6890,  0.6764,  0.2132,  0.1467,  0.1455,  0.0695,  0.0675,
  0.0233,  0.0134,  0.0121,

  // Cs  ---------------------------------------------------------------------
   35.9850,  5.7140,  5.3590,  5.0120,  1.2110,  1.0710,  1.0030,
  0.7405,  0.7266,  0.2323,  0.1724,  0.1613,  0.0798,  0.0775,
  0.0227,  0.0142,  0.0121,  0.004,

  // Ba  ---------------------------------------------------------------------
   37.4410,  5.9890,  5.6240,  5.2470,  1.2930,  1.1370,  1.0630,
  0.7957,  0.7805,  0.2535,  0.1920,  0.1786,  0.0926,  0.0899,
  0.0303,  0.0170,  0.0148,  0.0050,

  // La  ---------------------------------------------------------------------
   38.9250,  6.2660,  5.8910,  5.4830,  1.3620,  1.2090,  1.1280,
  0.8530,  0.8360,  0.2747,  0.2058,  0.1960,  0.1053,  0.1025,
  0.0343,  0.0193,  0.0168,  0.0060,  0.0050,

  // Ce  ---------------------------------------------------------------------
   40.4430,  6.5490,  6.1640,  5.7230,  1.4360,  1.2740,  1.1870,
  0.9024,  0.8838,  0.2910,  0.2232,  0.2065,  0.1090,  0.1076,
  0.0001,  0.0001,  0.0378,  0.0198,  0.0170,  0.0060,  0.0050,

  // Pr  ---------------------------------------------------------------------
   41.9910,  6.8350,  6.4400,  5.9640,  1.5110,  1.3370,  1.2429,
  0.9483,  0.9288,  0.3045,  0.2363,  0.2176,  0.1151,  0.1151,
  0.0020,  0.0020,  0.0374,  0.0223,  0.0223,  0.0060,  0.0050,

  // Nd  ---------------------------------------------------------------------
   43.5690,  7.1260,  6.7220,  6.2080,  1.5750,  1.4030,  1.2970,
  1.0033,  0.9804,  0.3192,  0.2433,  0.2246,  0.1205,  0.1205,
  0.0015,  0.0015,  0.0375,  0.0211,  0.0211,  0.0050,

  // Pm  ---------------------------------------------------------------------
   45.1840,  7.4280,  7.0130,  6.4590,  1.6486,  1.4710,  1.3570,
  1.0520,  1.0270,  0.3314,  0.2420,  0.2420,  0.1200,  0.1200,
  0.0035,  0.0360,  0.0245,  0.0201,  0.0050,

  // Sm  ---------------------------------------------------------------------
   46.8340,  7.7370,  7.3120,  6.7160,  1.7230,  1.5410,  1.4200,
  1.1109,  1.0834,  0.3472,  0.2656,  0.2474,  0.1290,  0.1290,
  0.0052,  0.0052,  0.0374,  0.0213,  0.0213,  0.0050,

  // Eu  ---------------------------------------------------------------------
   48.5190,  8.0520,  7.6170,  6.9770,  1.8000,  1.6140,  1.4810,
  1.1586,  1.1275,  0.3600,  0.2840,  0.2570,  0.1330,  0.1277,
  0.0000,  0.0000,  0.0320,  0.0220,  0.0220,  0.0060,

  // Gd  ---------------------------------------------------------------------
   50.2390,  8.3760,  7.9300,  7.2430,  1.8810,  1.6880,  1.5440,
  1.2219,  1.1896,  0.3786,  0.2860,  0.2710,  0.1495,  0.1426,
  0.0086,  0.0086,  0.0360,  0.0280,  0.0210,  0.0060,  0.0060,

  // Tb  ---------------------------------------------------------------------
   51.9960,  8.7080,  8.2520,  7.5140,  1.9680,  1.7680,  1.6110,
  1.2769,  1.2411,  0.3960,  0.3224,  0.2841,  0.1505,  0.1505,
  0.0077,  0.0024,  0.0456,  0.0287,  0.0226,  0.0060,  0.0060,

  // Dy  ---------------------------------------------------------------------
   53.7890,  9.0460,  8.5810,  7.7900,  2.0470,  1.8420,  1.6760,
  1.3330,  1.2926,  0.4142,  0.3335,  0.2932,  0.1536,  0.1536,
  0.0080,  0.0043,  0.0499,  0.0263,  0.0263,  0.0060,

  // Ho  ---------------------------------------------------------------------
   55.6180,  9.3940,  8.9180,  8.0710,  2.1280,  1.9230,  1.7410,
  1.3920,  1.3510,  0.4324,  0.3435,  0.3082,  0.1600,  0.1600,
  0.0086,  0.0052,  0.0493,  0.0308,  0.0241,  0.0060,

  // Er  ---------------------------------------------------------------------
   57.4860,  9.7510,  9.2640,  8.3580,  2.2070,  2.0060,  1.8120,
  1.4530,  1.4090,  0.4498,  0.3662,  0.3202,  0.1676,  0.1676,
  0.0053,  0.0047,  0.0506,  0.0314,  0.0247,  0.0060,

  // Tm  ---------------------------------------------------------------------
   59.3900,   10.1160,  9.6170,  8.6480,  2.3070,  2.0900,  1.8850,
  1.5150,  1.4680,  0.4709,  0.3859,  0.3326,  0.1755,  0.1755,
  0.0062,  0.0046,  0.0547,  0.0318,  0.0250,  0.0060,

  // Yb  ---------------------------------------------------------------------
   61.3320,   10.4860,  9.9780,  8.9440,  2.3980,  2.1730,  1.9500,
  1.5760,  1.5280,  0.4805,  0.3887,  0.3397,  0.1912,  0.1824,
  0.0025,  0.0013,  0.0520,  0.0303,  0.0241,  0.0060,

  // Lu  ---------------------------------------------------------------------
   63.3140,   10.8700,   10.3490,  9.2440,  2.4910,  2.2640,  2.0240,
  1.6390,  1.5890,  0.5068,  0.4124,  0.3592,  0.2061,  0.1963,
  0.0089,  0.0075,  0.0573,  0.0336,  0.0267,  0.0046,  0.0070,

  // Hf  ---------------------------------------------------------------------
   65.3510,   11.2710,   10.7390,  9.5610,  2.6010,  2.3650,  2.1080,
  1.7160,  1.6620,  0.5380,  0.4382,  0.3807,  0.2200,  0.2115,
  0.0159,  0.0142,  0.0642,  0.0380,  0.0299,  0.0066,  0.0070,

  // Ta  ---------------------------------------------------------------------
   67.4160,   11.6820,   11.1360,  9.8810,  2.7080,  2.4690,  2.1940,
  1.7930,  1.7350,  0.5634,  0.4634,  0.4009,  0.2379,  0.2264,
  0.0235,  0.0216,  0.0697,  0.0422,  0.0327,  0.0057,  0.0080,

  // W   ---------------------------------------------------------------------
   69.5250,   12.1000,   11.5440,   10.2070,  2.8200,  2.5750,  2.2810,
  1.8720,  1.8090,  0.5941,  0.4904,  0.4236,  0.2559,  0.2435,
  0.0336,  0.0314,  0.0756,  0.0453,  0.0368,  0.0061,  0.0080,

  // Re  ---------------------------------------------------------------------
   71.6760,   12.5270,   11.9590,   10.5350,  2.9320,  2.6820,  2.3670,
  1.9490,  1.8830,  0.6254,  0.5187,  0.4468,  0.2739,  0.2605,
  0.0429,  0.0405,  0.0830,  0.0456,  0.0346,  0.0038,  0.0025,
  0.0080,

  // Os  ---------------------------------------------------------------------
   73.8710,   12.9680,   12.3850,   10.8710,  3.0490,  2.7920,  2.4570,
  2.0310,  1.9600,  0.6582,  0.5491,  0.4707,  0.2931,  0.2785,
  0.0534,  0.0507,  0.0840,  0.0580,  0.0445,  0.0009,  0.0004,
  0.0080,

  // Ir  ---------------------------------------------------------------------
   76.1110,   13.4190,   12.8240,   11.2150,  3.1740,  2.9090,  2.5510,
  2.1160,  2.0400,  0.6911,  0.5778,  0.4958,  0.3119,  0.2963,
  0.0638,  0.0608,  0.0952,  0.0630,  0.0480,  0.0042,  0.0032,
  0.0090,

  // Pt  ---------------------------------------------------------------------
   78.3950,   13.8800,   13.2730,   11.5640,  3.2960,  3.0270,  2.6450,
  2.2020,  2.1220,  0.7254,  0.6091,  0.5194,  0.3316,  0.3146,
  0.0745,  0.0712,  0.1017,  0.0653,  0.0517,  0.0028,  0.0014,
  0.0090,

  // Au  ---------------------------------------------------------------------
   80.7250,   14.3530,   13.7340,   11.9190,  3.4250,  3.1480,  2.7430,
  2.2910,  2.2060,  0.7621,  0.6427,  0.5463,  0.3532,  0.3351,
  0.0876,  0.0840,  0.1072,  0.0742,  0.0572,  0.0033,  0.0018,
  0.0090,

  // Hg  ---------------------------------------------------------------------
   83.1020,   14.8390,   14.2090,   12.2840,  3.5620,  3.2790,  2.8470,
  2.3850,  2.2950,  0.8022,  0.6802,  0.5766,  0.3782,  0.3588,
  0.1040,  0.0999,  0.1270,  0.0831,  0.0645,  0.0096,  0.0078,
  0.0090,

  // Tl   --------------------------------------------------------------------
   85.5300,   15.3470,   14.6980,   12.6580,  3.7040,  3.4160,  2.9570,
  2.4850,  2.3890,  0.8462,  0.7205,  0.6095,  0.4057,  0.3850,
  0.1222,  0.1178,  0.1360,  0.0946,  0.0735,  0.0147,  0.0125,
  0.0060,  0.0008,

  // Pb   --------------------------------------------------------------------
   88.0050,   15.8610,   15.200,  13.0350,  3.8510,  3.5540,  3.0660,
  2.5860,  2.4840,  0.8918,  0.7619,  0.6435,  0.4343,  0.4122,
  0.1417,  0.1369,  0.1470,  0.1064,  0.0833,  0.0207,  0.0181,
  0.0031,  0.0007,

  // Bi   --------------------------------------------------------------------
   90.5240,   16.3880,   15.7110,   13.4190,  3.9990,  3.6960,  3.1770,
  2.6880,  2.5800,  0.9390,  0.8052,  0.6788,  0.4640,  0.4401,
  0.1623,  0.1570,  0.1593,  0.1190,  0.0926,  0.0269,  0.0238,
  0.0075,  0.0012,  0.0002,

  // Po   --------------------------------------------------------------------
   93.1050,   16.9390,   16.2440,   13.8140,  4.1490,  3.8540,  3.3020,
  2.7980,  2.6830,  0.9950,  0.8510,  0.7050,  0.5000,  0.4730,
  0.1840,  0.1840,  0.1770,  0.1320,  0.1040,  0.0310,  0.0310,
  0.0110,  0.0032,  0.0014,

  // At   --------------------------------------------------------------------
   95.7300,   17.4930,   16.7850,   14.2140,  4.3170,  4.0080,  3.4260,
  2.9090,  2.7870,  1.0420,  0.8860,  0.7400,  0.5330,  0.5070,
  0.2100,  0.2100,  0.1950,  0.1480,  0.1150,  0.0400,  0.0400,
  0.0150,  0.0057,  0.0028,

  // Rn   --------------------------------------------------------------------
   98.4040,   18.0490,   17.3370,   14.6190,  4.4820,  4.1590,  3.5380,
  3.0220,  2.8920,  1.0970,  0.9290,  0.7680,  0.5670,  0.5410,
  0.2380,  0.2380,  0.2140,  0.1640,  0.1270,  0.0480,  0.0480,
  0.0260,  0.0076,  0.0041,

  // Fr   --------------------------------------------------------------------
  101.1370,   18.6390,   17.9070,   15.0310,  4.6520,  4.3270,  3.6630,
  3.1360,  3.0000,  1.1530,  0.9800,  0.8100,  0.6030,  0.5770,
  0.2680,  0.2680,  0.2340,  0.1820,  0.1400,  0.0580,  0.0580,
  0.0340,  0.0150,  0.0150,  0.0040,

  // Ra   --------------------------------------------------------------------
  103.9220,   19.2370,   18.4840,   15.4440,  4.8220,  4.4900,  3.7920,
  3.2480,  3.1050,  1.2080,  1.0580,  0.8790,  0.6360,  0.6030,
  0.2990,  0.2990,  0.2540,  0.2000,  0.1530,  0.0680,  0.0680,
  0.0440,  0.0190,  0.0190,  0.0050,

  // Ac   --------------------------------------------------------------------
  106.7550,   19.8400,   19.0830,   15.8710,  5.0020,  4.6560,  3.9090,
  3.3700,  3.2190,  1.2690,  1.0800,  0.8900,  0.6750,  0.6390,
  0.3190,  0.3190,  0.2720,  0.2150,  0.1670,  0.0800,  0.0800,
  0.0398,  0.0241,  0.0170,  0.0060,  0.0060,

  // Th   --------------------------------------------------------------------
  109.6510,   20.4720,   19.6930,   16.3000,  5.1820,  4.8300,  4.0460,
  3.4910,  3.3320,  1.3300,  1.1680,  0.9664,  0.7121,  0.6752,
  0.3424,  0.3331,  0.2900,  0.2290,  0.1820,  0.0925,  0.0854,
  0.0414,  0.0245,  0.0166,  0.0060,  0.0060,

  // Pa   --------------------------------------------------------------------
  112.6010,   21.1050,   20.3140,   16.7330,  5.3670,  5.0010,  4.1740,
  3.6110,  3.4420,  1.3870,  1.2240,  1.0070,  0.7430,  0.7080,
  0.3710,  0.3600,  0.3100,  0.2320,  0.2320,  0.0940,  0.0940,
  0.0060,  0.0467,  0.0281,  0.0189,  0.0060,  0.0060,

  // U    --------------------------------------------------------------------
  115.6060,   21.7570,   20.9480,   17.1660,  5.5480,  5.1820,  4.3030,
  3.7280,  3.5520,  1.4390,  1.2710,  1.0430,  0.7783,  0.7362,
  0.3882,  0.3774,  0.3210,  0.2570,  0.1920,  0.1028,  0.0942,
  0.0060,  0.0439,  0.0268,  0.0168,  0.0060,  0.0060,

  // Np   --------------------------------------------------------------------
  118.6690,   22.4281,   21.6013,   17.6106,  5.7396,  5.3667,  4.4334,
  3.8498,  3.6652,  1.5001,  1.3277,  1.0860,  0.8161,  0.7708,
  0.4143,  0.4034,  0.3398,  0.2834,  0.2062,  0.1093,  0.1012,
  0.0060,  0.0500,  0.0293,  0.0175,  0.0060,  0.0060,

  // Pu   --------------------------------------------------------------------
  121.7910,   23.0978,   22.2668,   18.0570,  5.9329,  5.5412,  4.5566,
  3.9726,  3.7781,  1.5593,  1.3774,  1.1209,  0.8489,  0.8015,
  0.4374,  0.4252,  0.3519,  0.2825,  0.2153,  0.1160,  0.1052,
  0.0060,  0.0486,  0.0306,  0.0184,  0.0060,

  // Am   --------------------------------------------------------------------
  124.9810,   23.8051,   22.9494,   18.5062,  6.1326,  5.7470,  4.7060,
  4.0921,  3.8869,  1.6192,  1.4351,  1.1680,  0.8804,  0.8300,
  0.4633,  0.4490,  0.3730,  0.3030,  0.2164,  0.1180,  0.1079,
  0.0060,  0.0060,  0.0504,  0.0311,  0.0181,  0.0060,

  // Cm   --------------------------------------------------------------------
  128.2000,   24.5200,   23.6600,   18.9700,  6.3350,  5.9400,  4.8500,
  4.2300,  4.0150,  1.6850,  1.4950,  1.2050,  0.9250,  0.8700,
  0.4950,  0.4850,  0.3970,  0.2350,  0.1350,  0.1200,  0.0920,
  0.0060,  0.0060,  0.0670,  0.0500,  0.0060,  0.0060,  0.0970,

  // Bk   --------------------------------------------------------------------
  131.6000,   25.2600,   24.3800,   19.4400,  6.5450,  6.1450,  4.9900,
  4.3600,  4.1350,  1.7450,  1.5550,  1.2450,  0.9600,  0.9000,
  0.5250,  0.5100,  0.4150,  0.3300,  0.2430,  0.1400,  0.1250,
  0.0060,  0.0060,  0.0960,  0.0700,  0.0500,  0.0044,  0.0060,

  // Cf   --------------------------------------------------------------------
  135.0000,   26.0100,   25.1200,   19.9100,  6.7550,  6.3500,  5.1350,
  4.4950,  4.2600,  1.8100,  1.6150,  1.2850,  0.9950,  0.9300,
  0.5550,  0.5400,  0.4300,  0.3450,  0.2500,  0.1450,  0.1300,
  0.0060,  0.0060,  0.1000,  0.0700,  0.0500,  0.006,

  // Es   --------------------------------------------------------------------
  138.4000,   26.7800,   25.8800,   20.3900,  6.9750,  6.5600,  5.2800,
  4.6300,  4.3850,  1.8750,  1.6750,  1.3250,  1.0300,  0.9650,
  0.5850,  0.5700,  0.4450,  0.3600,  0.2600,  0.1550,  0.1350,
  0.0060,  0.0060,  0.1000,  0.0700,  0.0500,  0.0060,

  // Fm   --------------------------------------------------------------------
  142.0000,   27.5700,   26.6600,   20.8700,  7.2000,  6.7800,  5.4250,
  4.7650,  4.5100,  1.9400,  1.7400,  1.3700,  1.0650,  1.0000,
  0.6150,  0.6000,  0.4600,  0.3750,  0.2700,  0.1650,  0.1400,
  0.0060,  0.0060,  0.1000,  0.0800,  0.0500,  0.0060,

  // Md   --------------------------------------------------------------------
  145.6000,   28.3800,   27.4600,   21.3600,  7.4300,  7.0000,  5.5750,
  4.9050,  4.6330,  2.0050,  1.8050,  1.4150,  1.1050,  1.0350,
  0.6450,  0.6300,  0.4800,  0.3900,  0.2800,  0.1750,  0.1450,
  0.0070,  0.0070,  0.1100,  0.0800,  0.0500,  0.0060,

  // No   --------------------------------------------------------------------
  149.3000,   29.2220,   28.2800,   21.8500,  7.6700,  7.2300,  5.7300,
  5.0500,  4.7650,  2.0750,  1.8750,  1.4600,  1.1450,  1.0700,
  0.6800,  0.6500,  0.5000,  0.4100,  0.2900,  0.1850,  0.1550,
  0.0100,  0.0100,  0.1100,  0.0800,  0.0500,  0.0060,

  // Lr   --------------------------------------------------------------------
  153.0000,   30.0800,   29.1300,   22.3500,  7.9200,  7.4700,  5.8900,
  5.2000,  4.9000,  2.1500,  1.9500,  1.5050,  1.1900,  1.1100,
  0.7200,  0.6900,  0.5200,  0.4300,  0.3000,  0.2000,  0.1600,
  0.0150,  0.0150,  0.1200,  0.0900,  0.0600,  0.0070,  0.0070,

  // Rf   --------------------------------------------------------------------
  156.9000,   30.9600,   30.0000,   22.8600,  8.1700,  7.7200,  6.0550,
  5.3500,  5.0400,  2.2250,  2.0250,  1.5550,  1.2350,  1.1500,
  0.7600,  0.7200,  0.5400,  0.4550,  0.3150,  0.2150,  0.1700,
  0.0200,  0.0200,  0.1200,  0.0900,  0.0600,  0.0080,  0.0080,

  // Db   --------------------------------------------------------------------
  160.8000,   31.8700,   30.9000,   23.3800,  8.4300,  7.9800,  6.6250,
  5.5050,  5.1850,  2.3050,  2.1050,  1.6050,  1.2800,  1.1900,
  0.8000,  0.7500,  0.5600,  0.4800,  0.3300,  0.2300,  0.1800,
  0.0250,  0.0250,  0.1300,  0.1000,  0.0600,  0.0090,  0.0080,

  // Sg   --------------------------------------------------------------------
  164.9000,   32.8000,   31.8200,   23.9100,  8.7000,  8.2400,  6.4000,
  5.6650,  5.3300,  2.3850,  2.1900,  1.6600,  1.3250,  1.2350,
  0.8400,  0.7800,  0.5850,  0.5050,  0.3450,  0.2450,  0.1900,
  0.0300,  0.0300,  0.1400,  0.1100,  0.0600,  0.0090,  0.0080,

  // Bh   --------------------------------------------------------------------
  169.0000,   33.7600,   32.7700,   24.4400,  8.9800,  8.5100,  6.5800,
  5.8300,  5.4750,  2.4700,  2.2750,  1.7150,  1.3700,  1.2800,
  0.8800,  0.8200,  0.6100,  0.5300,  0.3600,  0.2600,  0.2000,
  0.0400,  0.0400,  0.1400,  0.1100,  0.0700,  0.0100,  0.0100,
  0.0090,

  // Hs   --------------------------------------------------------------------
  173.2000,   34.7500,   33.7400,   24.9200,  9.2700,  8.7900,  6.7600,
  5.9950,  5.6200,  2.5550,  2.3650,  1.7700,  1.4200,  1.3250,
  0.9200,  0.8600,  0.6350,  0.5550,  0.3750,  0.2750,  0.2100,
  0.0500,  0.0500,  0.1500,  0.1200,  0.0700,  0.0100,  0.0100,
  0.0090,

  // Mt   --------------------------------------------------------------------
  177.6000,   35.7700,   34.7400,   25.5200,  9.5700,  9.0800,  6.9400,
  6.1600,  5.7700,  2.6450,  2.4600,  1.8250,  1.4700,  1.3700,
  0.9600,  0.9000,  0.6600,  0.5800,  0.3900,  0.2900,  0.2200,
  0.0600,  0.0600,  0.1600,  0.1200,  0.0700,  0.0100,  0.0100,
  0.0100,

  // Ds   --------------------------------------------------------------------
  182.0000,   36.8100,   35.7700,   26.0700,  9.8700,  9.3700,  7.1200,
  6.3300,  5.9200,  2.7350,  2.5600,  1.8800,  1.5200,  1.4150,
  1.0000,  0.9400,  0.6900,  0.6100,  0.4050,  0.3050,  0.2300,
  0.0700,  0.0700,  0.1600,  0.1300,  0.0800,  0.0100,  0.0100,
  0.0100,

  // Rg   --------------------------------------------------------------------
  186.1360,   37.8810,   36.7990,   26.6480,   10.1870,  9.6870,  7.2240,
  6.4470,  6.0250,  2.9260,  2.6730,  1.9780,  1.5970,  1.4830,
  0.9604,  0.9267,  0.7283,  0.6450,  0.2810,  0.2510,  0.2445,
  0.0671,  0.0614,  0.1267,  0.0901,  0.0498,  0.0094,  0.0066,
  0.0094,

  // Cp   --------------------------------------------------------------------
  190.7170,   38.9840,   37.8960,   27.2130,   10.5080,   10.0020,  7.4060,
  6.6180,  6.1780,  3.0330,  2.7760,  2.0390,  1.6520,  1.5320,
  1.0016,  0.9662,  0.7624,  0.6770,  0.2960,  0.2650,  0.2577,
  0.0753,  0.0690,  0.1349,  0.0969,  0.0528,  0.0104,  0.0073,
  0.0098,

  // Uut  --------------------------------------------------------------------
  195.4100,   40.1210,   39.0340,   27.7880,   10.8420,   10.3310,  7.5930,
  6.7930,  6.3350,  3.1460,  2.8860,  2.1070,  1.7120,  1.5870,
  1.0464,  1.0092,  0.8006,  0.7140,  0.3150,  0.2820,  0.2740,
  0.0866,  0.0798,  0.1464,  0.1069,  0.0586,  0.0138,  0.0101,
  0.0116,  0.0049,

  // Fl   --------------------------------------------------------------------
  200.2140,   41.2940,   40.2070,   28.3700,   11.1840,   10.6720,  7.7830,
  6.9720,  6.4950,  3.2640,  2.9990,  2.1740,  1.7740,  1.6420,
  1.0923,  1.0533,  0.8409,  0.7530,  0.3350,  0.3000,  0.2910,
  0.0984,  0.0911,  0.1583,  0.1174,  0.0646,  0.0173,  0.0130,
  0.0135,  0.0057,

  // Uup  --------------------------------------------------------------------
  205.1360,   42.5010,   41.4200,   28.9590,   11.5410,   11.0220,  7.9790,
  7.1550,  6.6580,  3.3860,  3.1180,  2.2450,  1.8380,  1.7010,
  1.1410,  1.1000,  0.8831,  0.7940,  0.3570,  0.3200,  0.3100,
  0.1124,  0.1045,  0.1726,  0.1301,  0.0724,  0.0227,  0.0177,
  0.0169,  0.0078,  0.0038,

  // Lv   --------------------------------------------------------------------
  210.1770,   43.7500,   42.6740,   29.5560,   11.9070,   11.3870,  8.1760,
  7.3410,  6.8240,  3.5130,  3.2410,  2.3160,  1.9030,  1.7590,
  1.1907,  1.1477,  0.9275,  0.8380,  0.3790,  0.3400,  0.3296,
  0.1269,  0.1184,  0.1874,  0.1434,  0.0805,  0.0282,  0.0226,
  0.0203,  0.0101,  0.0044,

  // Uus  --------------------------------------------------------------------
  215.3370,   44.0310,   43.9750,   30.1580,   12.2830,   11.7620,  8.3760,
  7.5300,  6.9910,  3.6430,  3.4690,  2.3900,  1.9700,  1.8190,
  1.2413,  1.1962,  0.9733,  0.8820,  0.4020,  0.3610,  0.3496,
  0.1417,  0.1327,  0.2026,  0.1571,  0.0886,  0.0337,  0.0275,
  0.0237,  0.0124,  0.0052,

  // Uuo  --------------------------------------------------------------------
  220.6300,   46.3540,   45.3540,   30.7670,   12.6700,   12.1510,  8.5790,
  7.7200,  7.1610,  3.7780,  3.5000,  2.4640,  2.0370,  1.8800,
  1.2928,  1.2455,  1.0205,  0.9280,  0.4250,  0.3820,  0.3699,
  0.1570,  0.1472,  0.2183,  0.1714,  0.0968,  0.0394,  0.0324,
  0.0272,  0.0149,  0.0060,

  // Uue  --------------------------------------------------------------------
  226.0630,   47.7240,   46.7140,   31.3860,   13.0740,   12.5560,  8.7890,
  7.9180,  7.3360,  3.9200,  3.6390,  2.5430,  2.1090,  1.9440,
  1.3476,  1.2982,  1.0720,  0.9800,  0.4520,  0.4060,  0.3931,
  0.1751,  0.1646,  0.2371,  0.1887,  0.1075,  0.0476,  0.0399,
  0.0331,  0.0197,  0.0084,  0.0036,

  // Ubn  --------------------------------------------------------------------
  231.6340,   49.1390,   48.1580,   32.0130,   13.4890,   12.9750,  9.0000,
  8.1170,  7.5130,  4.0660,  3.7840,  2.6220,  2.1820,  2.0100,
  1.4040,  1.3523,  1.1256,  1.0330,  0.4790,  0.4310,  0.4173,
  0.1941,  0.1830,  0.2570,  0.2071,  0.1190,  0.0565,  0.0479,
  0.0396,  0.0251,  0.0113,  0.0042
};

const G4int G4AtomicShells_XDB_EADL::fNumberOfElectrons[2171] =
{
  0,  // nonexistent zero element

  // H  ---------------------------------------------------------
  1,

  // He ---------------------------------------------------------
  2,

  // Li  --------------------------------------------------------
  2,   1,

  // Be  --------------------------------------------------------
  2,   2,

  // B   --------------------------------------------------------
  2,   2,   1,

  // C  ---------------------------------------------------------
  2,   2,   2,

  // N  ---------------------------------------------------------
  2,   2,   2,   1,

  // O  ---------------------------------------------------------
  2,   2,   2,   2,

  // F  ---------------------------------------------------------
  2,   2,   2,   3, 

  // Ne ---------------------------------------------------------
  2,   2,   2,   4,

  // Na ----------------------------------------------
  2,   2,   2,   4,   1,

  // Mg ----------------------------------------------
  2,   2,   2,   4,   2,

  // Al ----------------------------------------------
  2,   2,   2,   4,   2,   1,

  // Si ----------------------------------------------
  2,   2,   2,   4,   2,   2,

  // P  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   1,

  // S  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   2,

  // Cl ----------------------------------------------
  2,   2,   2,   4,   2,   2,   3,

  // Ar ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,

  // K  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   1,

  // Ca ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   2,

  // Sc ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   1,   2,

  // Ti ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   2,   2,

  // V  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   3,   2,

  // Cr ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   1,   1,

  // Mn ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   1,   2,

  // Fe ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   2,   2,

  // Co ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   3,   2,

  // Ni ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   4,   2,

  // Cu ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   1,

  // Zn ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,

  // Ga ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  1,

  // Ge ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,

  // As ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   1,

  // Se ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   2,
  
  // Br ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   3,

  // Kr ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,

  // Rb ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   1,

  // Sr ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   2,

  // Y  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   1,   2,

  // Zr ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   2,   2,

  // Nb ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   1,

  // Mo ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   1,   1,

  // Tc ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   1,   2,

  // Ru ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   3,   1,

  // Rh ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   4,   1, 

  // Pd ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,

  // Ag ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   1,

  // Cd ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,

  // In ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   1,

  // Sn ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,

  // Sb ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,   1,

  // Te ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,   2,

  // I  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,   3,

  // Xe ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,   4,

  // Cs ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,   4,   1,

  // Ba ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,   4,   2,

  // La ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   2,   4,   1,   2,

  // Ce ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   1,   1,   2,   2,   4,   1,
  1,

  // Pr ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   2,   1,   2,   2,   4,   1,
  1,

  // Nd ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   4,   1,   2,   2,   4,   1,

  // Pm ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   5,   2,   2,   4,   2,

  // Sm ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   1,   2,   2,   4,   1,

  // Eu ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   1,   2,   2,   4,   2,

  // Gd ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   1,   2,   2,   4,   1,
  2,

  // Tb ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   2,   2,   2,   4,   1,
  2,

  // Dy ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   4,   2,   2,   4,   2,

  // Ho ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   5,   2,   2,   4,   2,

  // Er ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   6,   2,   2,   4,   2,

  // Tm ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   7,   2,   2,   4,   2,

  // Yb ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   2,

  // Lu ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   1, 
  2,

  // Hf ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   2,
  2,

  // Ta ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   3,
  2,

  // W  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  2,

  // Re ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  1,   2,

  // Os ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  2,   2,

  // Ir ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4, 
  3,   2,

  // Pt ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  5,   1,

  // Au ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   1,

  // Hg ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,

  // Tl ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   1,

  // Pb ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,

  // Bi ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   1,

  // Po ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   2,

  // At ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   3,

  // Rn ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   4,

  // Fr ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   4,   1,

  // Ra ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   4,   2,

  // Ac ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   4,   1,   2,

  // Th ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   4,   2,   2,

  // Pa ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   2,   2,   2,   4,   1,   2,

  // U  ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   3,   2,   2,   4,   1,   2,

  // Np ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   4,   2,   2,   4,   1,   2,

  // Pu ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   2,   2,   4,   2,

  // Am ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   1,   2,   2,   4,   2,  

  // Cm ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   1,   2,   2,   4,   1,   2,

  // Bk ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   2,   2,   2,   4,   1,   2, 

  // Cf ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   4,   2,   2,   4,   2,

  // Es ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   5,   2,   2,   4,   2,

  // Fm ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   6,   2,   2,   4,   2,

  // Md ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   7,   2,   2,   4,   2,

  // No ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   2,

  // Lr ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   1,   2, 

  // Rf ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   2,   2,

  // Db ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   3,   2,

  // Sg ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   2,

  // Bh ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   1,   2,

  // Hs ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   2,   2,

  // Mt ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   3,   2,

  // Ds ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   5,   1,

  // Rg ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   1,

  // Cp ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,

  // Uut ---------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   1,

  // Fl ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   2,

  // Uup ---------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   2,
  1,

  // Lv ----------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   2,
  2,

  // Uus ---------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   2,
  3,

  // Uuo ---------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   2,
  4,

  // Uue ---------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   2,
  4,   1,

  // Ubn ---------------------------------------------
  2,   2,   2,   4,   2,   2,   4,   4,   6,   2,
  2,   4,   4,   6,   6,   8,   2,   2,   4,   4,
  6,   6,   8,   2,   2,   4,   4,   6,   2,   2,
  4,   2
};
// clang-format on

G4int G4AtomicShells_XDB_EADL::GetNumberOfShells(G4int Z)
{
#ifdef G4VERBOSE
  if (Z < 0 || Z > 120) {
    Z = PrintErrorZ(Z, "GetNumberOfShells");
  }
#endif
  return fNumberOfShells[Z];
}

G4double G4AtomicShells_XDB_EADL::GetBindingEnergy(G4int Z, G4int ShellNb)
{
#ifdef G4VERBOSE
  if (Z < 0 || Z > 120) {
    Z = PrintErrorZ(Z, "GetBindingEnergy");
  }
  if (ShellNb < 0 || ShellNb >= fNumberOfShells[Z]) {
    ShellNb = PrintErrorShell(Z, ShellNb, "GetBindingEnergy");
  }
#endif
  return fBindingEnergies[fIndexOfShells[Z] + ShellNb] * CLHEP::keV;
}

G4int G4AtomicShells_XDB_EADL::GetNumberOfElectrons(G4int Z, G4int ShellNb)
{
#ifdef G4VERBOSE
  if (Z < 0 || Z > 120) {
    Z = PrintErrorZ(Z, "GetNumberOfElectrons");
  }
  if (ShellNb < 0 || ShellNb >= fNumberOfShells[Z]) {
    ShellNb = PrintErrorShell(Z, ShellNb, "GetNumberOfElectrons");
  }
#endif
  return fNumberOfElectrons[fIndexOfShells[Z] + ShellNb];
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

G4int G4AtomicShells_XDB_EADL::GetNumberOfFreeElectrons(G4int Z, G4double th)
{
#ifdef G4VERBOSE
  if (Z < 0 || Z > 120) {
    Z = PrintErrorZ(Z, "GetNumberOfFreeElectrons");
  }
#endif
  G4int idx = fIndexOfShells[Z];
  G4int idxmax = idx + fNumberOfShells[Z];
  G4int n = 0;
  for (G4int i = idx; i < idxmax; ++i) {
    if (fBindingEnergies[i] * CLHEP::keV <= th) {
      n += fNumberOfElectrons[i];
    }
  }
  return n;
}

G4double G4AtomicShells_XDB_EADL::GetTotalBindingEnergy(G4int Z)
{
#ifdef G4VERBOSE
  if (Z < 0 || Z > 120) {
    Z = PrintErrorZ(Z, "GetTotalBindingEnergy");
  }
#endif
  G4int idx = fIndexOfShells[Z];
  G4int idxmax = idx + fNumberOfShells[Z];
  G4double energy = 0.0;
  for (G4int i = idx; i < idxmax; ++i) {
    energy += fBindingEnergies[i];
  }
  return energy * CLHEP::keV;
}

#ifdef G4VERBOSE

G4int G4AtomicShells_XDB_EADL::PrintErrorZ(G4int Z, const G4String& ss)
{
  G4String sss = "G4AtomicShells::" + ss + "()";
  G4ExceptionDescription ed;
  ed << "Atomic number out of range Z= " << Z;
  G4Exception(sss, "mat060", FatalException, ed, "");
  return 1;
}

G4int G4AtomicShells_XDB_EADL::PrintErrorShell(G4int Z, G4int n, const G4String& ss)
{
  G4String sss = "G4AtomicShells::" + ss + "()";
  G4ExceptionDescription ed;
  ed << "Shell number out of range Nshell= " << n << "  Z= " << Z;
  G4Exception(sss, "mat061", FatalException, ed, "");
  return 0;
}
#endif
