// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewDeleteSentinelPolicyParams creates a new DeleteSentinelPolicyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteSentinelPolicyParams() *DeleteSentinelPolicyParams {
	return &DeleteSentinelPolicyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteSentinelPolicyParamsWithTimeout creates a new DeleteSentinelPolicyParams object
// with the ability to set a timeout on a request.
func NewDeleteSentinelPolicyParamsWithTimeout(timeout time.Duration) *DeleteSentinelPolicyParams {
	return &DeleteSentinelPolicyParams{
		timeout: timeout,
	}
}

// NewDeleteSentinelPolicyParamsWithContext creates a new DeleteSentinelPolicyParams object
// with the ability to set a context for a request.
func NewDeleteSentinelPolicyParamsWithContext(ctx context.Context) *DeleteSentinelPolicyParams {
	return &DeleteSentinelPolicyParams{
		Context: ctx,
	}
}

// NewDeleteSentinelPolicyParamsWithHTTPClient creates a new DeleteSentinelPolicyParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteSentinelPolicyParamsWithHTTPClient(client *http.Client) *DeleteSentinelPolicyParams {
	return &DeleteSentinelPolicyParams{
		HTTPClient: client,
	}
}

/*
DeleteSentinelPolicyParams contains all the parameters to send to the API endpoint

	for the delete sentinel policy operation.

	Typically these are written to a http.Request.
*/
type DeleteSentinelPolicyParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125DeleteSentinelPolicyRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete sentinel policy params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteSentinelPolicyParams) WithDefaults() *DeleteSentinelPolicyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete sentinel policy params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteSentinelPolicyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) WithTimeout(timeout time.Duration) *DeleteSentinelPolicyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) WithContext(ctx context.Context) *DeleteSentinelPolicyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) WithHTTPClient(client *http.Client) *DeleteSentinelPolicyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) WithBody(body *models.HashicorpCloudVault20201125DeleteSentinelPolicyRequest) *DeleteSentinelPolicyParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) SetBody(body *models.HashicorpCloudVault20201125DeleteSentinelPolicyRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) WithClusterID(clusterID string) *DeleteSentinelPolicyParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) WithLocationOrganizationID(locationOrganizationID string) *DeleteSentinelPolicyParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) WithLocationProjectID(locationProjectID string) *DeleteSentinelPolicyParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the delete sentinel policy params
func (o *DeleteSentinelPolicyParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteSentinelPolicyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
