/*
 * Decompiled with CFR 0.152.
 */
package JFlex.anttask;

import JFlex.GeneratorException;
import JFlex.anttask.BuildException;
import JFlex.anttask.JFlexWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class JFlexTask {
    private File destinationDir;
    private File inputFile;
    private JFlexWrapper wrapper = new JFlexWrapper();
    private boolean verbose = false;
    private boolean generateDot = false;
    private boolean skipMin = false;
    private boolean displayTime = false;
    private File skeletonFile = null;

    public void execute() throws BuildException {
        try {
            if (this.inputFile == null) {
                throw new BuildException("You must specify the input file for JFlex!");
            }
            this.processFile(this.inputFile);
        }
        catch (GeneratorException generatorException) {
            throw new BuildException("JFlex: generation failed!");
        }
    }

    public void setDestdir(File file) {
        this.destinationDir = file;
    }

    public void setFile(File file) {
        this.inputFile = file;
    }

    public void setGenerateDot(boolean bl) {
        this.generateDot = bl;
    }

    public void setTimeStatistics(boolean bl) {
        this.displayTime = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setSkeleton(File file) {
        this.skeletonFile = file;
    }

    public void setSkipMinimization(boolean bl) {
        this.skipMin = bl;
    }

    protected void processFile(File file) throws BuildException {
        try {
            Object object;
            String string = null;
            String string2 = null;
            Object object2 = new LineNumberReader(new InputStreamReader(new FileInputStream(file)));
            while ((object = ((LineNumberReader)object2).readLine()) != null) {
                int n;
                int n2;
                if (string == null && (n2 = ((String)object).indexOf("package")) != -1 && (n = ((String)object).indexOf(59, n2 += 7)) != -1) {
                    string = ((String)object).substring(n2, n);
                    string = string.trim();
                }
                if (string2 == null && (n2 = ((String)object).indexOf("%class")) != -1) {
                    string2 = ((String)object).substring(n2 += 6);
                    string2 = string2.trim();
                }
                if (string2 == null || string == null) continue;
            }
            if (string2 == null) {
                string2 = "Yylex";
            }
            object2 = new StringBuffer();
            if (this.destinationDir != null) {
                ((StringBuffer)object2).append(this.destinationDir.getAbsolutePath());
                if (string != null) {
                    ((StringBuffer)object2).append(File.separatorChar);
                    object = string.replace('.', File.separatorChar);
                    ((StringBuffer)object2).append((String)object);
                }
            } else {
                ((StringBuffer)object2).append(file.getParent());
            }
            object = new File(((StringBuffer)object2).toString() + File.separator + string2 + ".java");
            if (file.lastModified() > ((File)object).lastModified()) {
                this.wrapper.setTimeStatistics(this.displayTime);
                this.wrapper.setVerbose(this.verbose);
                this.wrapper.setGenerateDot(this.generateDot);
                this.wrapper.setSkipMinimization(this.skipMin);
                this.wrapper.setSkeleton(this.skeletonFile);
                this.wrapper.setDestinationDir(((StringBuffer)object2).toString());
                this.wrapper.generate(file);
                if (!this.verbose) {
                    System.out.println("Generated: " + ((File)object).getName());
                }
            }
        }
        catch (IOException iOException) {
            throw new BuildException("IOException: " + iOException.toString());
        }
    }
}

