/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.net.URISyntaxException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.MultiRequestClient;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.FlatClassLoaderStructure;
import org.gradle.workers.internal.TransportableActionExecutionSpec;
import org.gradle.workers.internal.TransportableActionExecutionSpecSerializer;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonServer;

public class WorkerDaemonStarter {
    private static final Logger LOG = Logging.getLogger(WorkerDaemonStarter.class);
    private final WorkerProcessFactory workerDaemonProcessFactory;
    private final LoggingManager loggingManager;
    private final ClassPathRegistry classPathRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public WorkerDaemonStarter(WorkerProcessFactory workerDaemonProcessFactory, LoggingManager loggingManager, ClassPathRegistry classPathRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workerDaemonProcessFactory = workerDaemonProcessFactory;
        this.loggingManager = loggingManager;
        this.classPathRegistry = classPathRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    WorkerDaemonClient startDaemon(DaemonForkOptions forkOptions) {
        LOG.debug("Starting Gradle worker daemon with fork options {}.", (Object)forkOptions);
        Timer clock = Time.startTimer();
        MultiRequestWorkerProcessBuilder builder = this.workerDaemonProcessFactory.multiRequestWorker(WorkerDaemonServer.class);
        builder.setBaseName("Gradle Worker Daemon");
        builder.setLogLevel(this.loggingManager.getLevel());
        builder.sharedPackages(new String[]{"org.gradle", "javax.inject"});
        builder.withoutAutomaticImplementationClasspath();
        builder.applicationClasspath((Iterable)this.classPathRegistry.getClassPath("DAEMON_SERVER_WORKER").getAsFiles());
        if (forkOptions.getClassLoaderStructure() instanceof FlatClassLoaderStructure) {
            FlatClassLoaderStructure flatClassLoaderStructure = (FlatClassLoaderStructure)forkOptions.getClassLoaderStructure();
            Iterable<File> workClasspath = WorkerDaemonStarter.toFiles(flatClassLoaderStructure.getSpec());
            builder.applicationClasspath(workClasspath);
        }
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        forkOptions.copyTo(javaCommand);
        builder.registerArgumentSerializer(TransportableActionExecutionSpec.class, (Serializer)new TransportableActionExecutionSpecSerializer());
        MultiRequestClient workerDaemonProcess = builder.build();
        WorkerProcess workerProcess = workerDaemonProcess.start();
        WorkerDaemonClient client = new WorkerDaemonClient(forkOptions, (MultiRequestClient<TransportableActionExecutionSpec, DefaultWorkResult>)workerDaemonProcess, workerProcess, this.loggingManager.getLevel(), this.actionExecutionSpecFactory);
        LOG.info("Started Gradle worker daemon ({}) with fork options {}.", (Object)clock.getElapsed(), (Object)forkOptions);
        return client;
    }

    private static Iterable<File> toFiles(VisitableURLClassLoader.Spec spec) {
        return CollectionUtils.collect((Iterable)spec.getClasspath(), url -> {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        });
    }
}

