/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.ConcurrentModificationException;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueState;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.SupportsConvention;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.state.ModelObject;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractProperty<T, S extends ValueSupplier>
extends AbstractMinimalProvider<T>
implements PropertyInternal<T> {
    private static final DisplayName DEFAULT_DISPLAY_NAME = Describables.of((Object)"this property");
    private static final DisplayName DEFAULT_VALIDATION_DISPLAY_NAME = Describables.of((Object)"a property");
    private ModelObject producer;
    private DisplayName displayName;
    private ValueState<S> state;
    private S value;

    public AbstractProperty(PropertyHost host) {
        this.state = ValueState.newState(host);
    }

    protected void init(S initialValue, S convention) {
        this.value = initialValue;
        this.state.setConvention(convention);
    }

    protected void init(S initialValue) {
        this.init(initialValue, initialValue);
    }

    @Override
    public boolean isFinalized() {
        return this.state.isFinalized();
    }

    protected boolean isExplicit() {
        return this.state.isExplicit();
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext context = this.openScope();){
            this.beforeRead(context, consumer);
            try {
                boolean bl = this.getSupplier(context).calculatePresence(consumer);
                return bl;
            }
            catch (Exception e) {
                if (this.displayName != null) {
                    throw new PropertyQueryException(String.format("Failed to query the value of %s.", this.displayName), e);
                }
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    @Override
    public void attachOwner(@Nullable ModelObject owner, DisplayName displayName) {
        this.displayName = displayName;
    }

    @Override
    protected @Nullable DisplayName getDeclaredDisplayName() {
        return this.displayName;
    }

    @Override
    protected DisplayName getTypedDisplayName() {
        return DEFAULT_DISPLAY_NAME;
    }

    @Override
    protected DisplayName getDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_DISPLAY_NAME;
        }
        return this.displayName;
    }

    protected DisplayName getValidationDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_VALIDATION_DISPLAY_NAME;
        }
        return this.displayName;
    }

    @Override
    public void attachProducer(ModelObject owner) {
        if (this.producer == null) {
            this.producer = owner;
        } else if (this.producer != owner) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(this.getDisplayName().getCapitalizedDisplayName());
            formatter.append((CharSequence)" is already declared as an output property of ");
            this.format(this.producer, formatter);
            formatter.append((CharSequence)". Cannot also declare it as an output property of ");
            this.format(owner, formatter);
            formatter.append((CharSequence)".");
            throw new IllegalStateException(formatter.toString());
        }
    }

    protected final S getSupplier(EvaluationScopeContext context) {
        return this.value;
    }

    protected S getConventionSupplier() {
        return (S)((ValueSupplier)this.state.convention());
    }

    protected final String describeValue() {
        return this.value.toString();
    }

    protected ValueSupplier.Value<? extends T> calculateOwnValueNoProducer(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext context = this.openScope();){
            this.beforeReadNoProducer(context, consumer);
            ValueSupplier.Value<T> value = this.doCalculateValue(context, consumer);
            return value;
        }
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext context = this.openScope();){
            this.beforeRead(context, consumer);
            ValueSupplier.Value<T> value = this.doCalculateValue(context, consumer);
            return value;
        }
    }

    private @NonNull ValueSupplier.Value<? extends T> doCalculateValue(EvaluationScopeContext context, ValueSupplier.ValueConsumer consumer) {
        try {
            return this.calculateValueFrom(context, this.value, consumer);
        }
        catch (Exception e) {
            if (this.displayName != null) {
                throw new PropertyQueryException(String.format("Failed to query the value of %s.", this.displayName), e);
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    protected ConcurrentModificationException failWithCorruptedStateException(@Nullable Throwable reason) {
        throw new ConcurrentModificationException("State of " + this.getDisplayName().getDisplayName() + " is corrupted. This may be caused by unsafe concurrent modifications with parallel configuration or execution enabled.", reason);
    }

    protected abstract ValueSupplier.Value<? extends T> calculateValueFrom(EvaluationScopeContext var1, S var2, ValueSupplier.ValueConsumer var3);

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        try (EvaluationScopeContext context = this.openScope();){
            ValueSupplier.ExecutionTimeValue<T> value = this.calculateOwnExecutionTimeValue(context, this.value);
            if (this.getProducerTask() == null) {
                ValueSupplier.ExecutionTimeValue<T> executionTimeValue = value;
                return executionTimeValue;
            }
            ValueSupplier.ExecutionTimeValue<T> executionTimeValue = value.withChangingContent();
            return executionTimeValue;
        }
    }

    protected abstract ValueSupplier.ExecutionTimeValue<? extends T> calculateOwnExecutionTimeValue(EvaluationScopeContext var1, S var2);

    protected abstract String describeContents();

    @Override
    protected final String toStringNoReentrance() {
        if (this.displayName != null) {
            return this.displayName.toString();
        }
        return this.describeContents();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        Task task = this.getProducerTask();
        if (task != null) {
            return ValueSupplier.ValueProducer.task(task);
        }
        try (EvaluationScopeContext context = this.openScope();){
            ValueSupplier.ValueProducer valueProducer = this.getSupplier(context).getProducer();
            return valueProducer;
        }
    }

    public void finalizeValue() {
        if (this.state.shouldFinalize((Describable)this.getDisplayName(), this.producer)) {
            try (EvaluationScopeContext context = this.openScope();){
                this.finalizeNow(context, ValueSupplier.ValueConsumer.IgnoreUnsafeRead);
            }
        }
    }

    public void disallowChanges() {
        this.state.disallowChanges();
    }

    public void finalizeValueOnRead() {
        this.state.finalizeOnNextGet();
    }

    @Override
    public void implicitFinalizeValue() {
        if (this.state.isUpgradedPropertyValue()) {
            this.state.warnOnUpgradedPropertyValueChanges();
        } else {
            this.state.disallowChangesAndFinalizeOnNextGet();
        }
    }

    @Override
    public void markAsUpgradedProperty() {
        this.state.markAsUpgradedPropertyValue();
    }

    public void disallowUnsafeRead() {
        this.state.disallowUnsafeRead();
    }

    protected abstract S finalValue(EvaluationScopeContext var1, S var2, ValueSupplier.ValueConsumer var3);

    protected void setSupplier(S supplier) {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.explicitValue(supplier);
    }

    protected void setConvention(S convention) {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.applyConvention(this.value, convention);
    }

    protected void beforeRead(EvaluationScopeContext context, ValueSupplier.ValueConsumer consumer) {
        this.beforeRead(context, this.producer, consumer);
    }

    protected void beforeReadNoProducer(EvaluationScopeContext context, ValueSupplier.ValueConsumer consumer) {
        this.beforeRead(context, null, consumer);
    }

    private void beforeRead(EvaluationScopeContext context, @Nullable ModelObject effectiveProducer, ValueSupplier.ValueConsumer consumer) {
        this.state.finalizeOnReadIfNeeded((Describable)this.getDisplayName(), effectiveProducer, consumer, (Action<ValueSupplier.ValueConsumer>)((Action)effectiveConsumer -> this.finalizeNow(context, (ValueSupplier.ValueConsumer)((Object)effectiveConsumer))));
    }

    private void finalizeNow(EvaluationScopeContext context, ValueSupplier.ValueConsumer consumer) {
        try {
            this.value = this.finalValue(context, this.value, this.state.forUpstream(consumer));
        }
        catch (Exception e) {
            if (this.displayName != null) {
                throw new PropertyQueryException(String.format("Failed to calculate the value of %s.", this.displayName), e);
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.state = this.state.finalState();
    }

    protected S getExplicitValue(S defaultValue) {
        return (S)((ValueSupplier)this.state.explicitValue(this.value, defaultValue));
    }

    protected void discardValue() {
        this.assertCanMutate();
        if (this.isDefaultConvention()) {
            this.state.implicitValue(this.getDefaultConvention());
            this.value = this.getDefaultValue();
        } else {
            this.value = this.state.implicitValue((ValueSupplier)this.state.convention());
        }
    }

    protected void discardConvention() {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.applyConvention(this.value, this.getDefaultConvention());
    }

    public SupportsConvention unsetConvention() {
        this.discardConvention();
        return this;
    }

    public SupportsConvention unset() {
        this.discardValue();
        return this;
    }

    protected SupportsConvention setToConvention() {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.setToConvention();
        return this;
    }

    protected SupportsConvention setToConventionIfUnset() {
        this.assertCanMutate();
        if (!this.isDefaultConvention()) {
            this.value = (ValueSupplier)this.state.setToConventionIfUnset(this.value);
        }
        return this;
    }

    protected abstract S getDefaultValue();

    protected abstract S getDefaultConvention();

    protected abstract boolean isDefaultConvention();

    protected void assertCanMutate() {
        this.state.beforeMutate((Describable)this.getDisplayName());
    }

    private @Nullable Task getProducerTask() {
        if (this.producer == null) {
            return null;
        }
        Task task = this.producer.getTaskThatOwnsThisObject();
        if (task == null) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(this.getDisplayName().getCapitalizedDisplayName());
            formatter.append((CharSequence)" is declared as an output property of ");
            this.format(this.producer, formatter);
            formatter.append((CharSequence)" but does not have a task associated with it.");
            throw new IllegalStateException(formatter.toString());
        }
        return task;
    }

    private void format(ModelObject modelObject, TreeFormatter formatter) {
        if (modelObject.getModelIdentityDisplayName() != null) {
            formatter.append((CharSequence)modelObject.getModelIdentityDisplayName().getDisplayName());
            formatter.append((CharSequence)" (type ");
            formatter.appendType(modelObject.getClass());
            formatter.append((CharSequence)")");
        } else if (modelObject.hasUsefulDisplayName()) {
            formatter.append((CharSequence)modelObject.toString());
            formatter.append((CharSequence)" (type ");
            formatter.appendType(modelObject.getClass());
            formatter.append((CharSequence)")");
        } else {
            formatter.append((CharSequence)"an object with type ");
            formatter.appendType(modelObject.getClass());
        }
    }

    public ProviderInternal<T> shallowCopy() {
        return new ShallowCopyProvider();
    }

    @Contextual
    public static class PropertyQueryException
    extends RuntimeException {
        public PropertyQueryException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private class ShallowCopyProvider
    extends AbstractMinimalProvider<T> {
        private final S copiedValue;

        private ShallowCopyProvider() {
            this.copiedValue = AbstractProperty.this.value;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            try (EvaluationScopeContext ignored = this.openScope();){
                ValueSupplier.ValueProducer valueProducer = this.copiedValue.getProducer();
                return valueProducer;
            }
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
            try (EvaluationScopeContext context = this.openScope();){
                ValueSupplier.ExecutionTimeValue executionTimeValue = AbstractProperty.this.calculateOwnExecutionTimeValue(context, this.copiedValue);
                return executionTimeValue;
            }
        }

        @Override
        protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            try (EvaluationScopeContext context = this.openScope();){
                ValueSupplier.Value value = AbstractProperty.this.calculateValueFrom(context, this.copiedValue, consumer);
                return value;
            }
        }

        @Override
        public @Nullable Class<T> getType() {
            return AbstractProperty.this.getType();
        }
    }
}

