/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.properties.BorderProperty;
import java.awt.Component;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class CompoundBorderProperty
extends BorderProperty
implements Externalizable {
    static final long serialVersionUID = -8513525079430361312L;
    public static final int VERSION = 1;
    private LinkedList m_borders = new LinkedList();

    public CompoundBorderProperty() {
    }

    public CompoundBorderProperty(BorderProperty borderProperty) {
        this.addBorder(borderProperty);
    }

    public void addBorder(BorderProperty borderProperty) {
        if (borderProperty != null) {
            this.m_borders.addLast(borderProperty);
        }
    }

    public Border createBorder(Component component) {
        if (this.m_borders.size() == 0) {
            return null;
        }
        if (this.m_borders.size() == 1) {
            BorderProperty borderProperty = (BorderProperty)this.m_borders.getFirst();
            return borderProperty.createBorder(component);
        }
        Border border = null;
        Iterator iterator = this.m_borders.iterator();
        while (iterator.hasNext()) {
            BorderProperty borderProperty = (BorderProperty)iterator.next();
            Border border2 = borderProperty.createBorder(component);
            if (border == null) {
                border = border2;
                continue;
            }
            border = BorderFactory.createCompoundBorder(border, border2);
        }
        return border;
    }

    public Iterator iterator() {
        return this.m_borders.iterator();
    }

    public int size() {
        return this.m_borders.size();
    }

    public void setValue(Object object) {
        if (object instanceof CompoundBorderProperty) {
            CompoundBorderProperty compoundBorderProperty = (CompoundBorderProperty)object;
            this.m_borders.clear();
            this.m_borders.addAll(compoundBorderProperty.m_borders);
        }
    }

    public void updateBean(JETABean jETABean) {
        if (this.m_borders != null) {
            super.updateBean(jETABean);
        }
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_borders = (LinkedList)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.m_borders);
    }

    public String toString() {
        if (this.m_borders.size() == 0) {
            return "NO BORDER";
        }
        if (this.m_borders.size() == 1) {
            BorderProperty borderProperty = (BorderProperty)this.m_borders.getFirst();
            return borderProperty.toString();
        }
        return "COMPOUND";
    }
}

