/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.mac;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sourceforge.subsonic.booter.Main;
import net.sourceforge.subsonic.booter.deployer.SubsonicDeployerService;
import net.sourceforge.subsonic.booter.mac.StatusPanel;

public class SubsonicFrame
extends JFrame {
    private final SubsonicDeployerService deployer;
    private StatusPanel statusPanel;
    private JButton hideButton;
    private JButton exitButton;

    public SubsonicFrame(SubsonicDeployerService deployer) {
        super("Subsonic");
        this.deployer = deployer;
        this.createComponents();
        this.layoutComponents();
        this.addBehaviour();
        URL url = Main.class.getResource("/images/subsonic-512.png");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(url));
    }

    public void setActive(boolean active) {
        if (active) {
            this.pack();
            this.centerComponent();
            this.setVisible(true);
            this.toFront();
        } else {
            this.dispose();
        }
    }

    private void centerComponent() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
    }

    private void createComponents() {
        this.statusPanel = new StatusPanel(this.deployer);
        this.hideButton = new JButton("Hide");
        this.exitButton = new JButton("Exit");
    }

    private void layoutComponents() {
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(new BorderLayout(10, 10));
        pane.add((Component)this.statusPanel, "Center");
        pane.add((Component)ButtonBarFactory.buildRightAlignedBar(this.hideButton, this.exitButton), "South");
        pane.setBorder(Borders.DIALOG_BORDER);
    }

    private void addBehaviour() {
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubsonicFrame.this.setActive(false);
            }
        });
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }
}

