/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class DelegatingTimerTask
extends TimerTask {
    private static final Log logger = LogFactory.getLog(DelegatingTimerTask.class);
    private final Runnable delegate;

    public DelegatingTimerTask(Runnable delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
    }

    public final Runnable getDelegate() {
        return this.delegate;
    }

    public void run() {
        try {
            this.delegate.run();
        }
        catch (Throwable ex) {
            logger.error("Unexpected exception thrown from Runnable: " + this.delegate, ex);
        }
    }
}

