/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MutableBoolean;
import proguard.optimize.info.ProgramFieldOptimizationInfo;

public class ReadWriteFieldMarker
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final Logger logger = LogManager.getLogger(ReadWriteFieldMarker.class);
    private final MutableBoolean repeatTrigger;
    private final boolean markReading;
    private final boolean markWriting;
    private boolean reading = true;
    private boolean writing = true;

    public ReadWriteFieldMarker(MutableBoolean repeatTrigger) {
        this(repeatTrigger, true, true);
    }

    public ReadWriteFieldMarker(MutableBoolean repeatTrigger, boolean markReading, boolean markWriting) {
        this.repeatTrigger = repeatTrigger;
        this.markReading = markReading;
        this.markWriting = markWriting;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        switch (opcode) {
            case 18: 
            case 19: {
                this.reading = true;
                this.writing = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -78: 
            case -76: {
                this.reading = true;
                this.writing = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -77: 
            case -75: {
                this.reading = false;
                this.writing = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedMemberAccept(this);
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        fieldrefConstant.referencedFieldAccept(this);
    }

    @Override
    public void visitAnyMember(Clazz Clazz2, Member member) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.markReading && this.reading) {
            this.markAsRead(programClass, programField);
        }
        if (this.markWriting && this.writing) {
            this.markAsWritten(programClass, programField);
        }
    }

    private void markAsRead(Clazz clazz, Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (!fieldOptimizationInfo.isRead() && fieldOptimizationInfo instanceof ProgramFieldOptimizationInfo) {
            logger.debug("ReadWriteFieldMarker: marking as read: {}.{}", (Object)clazz.getName(), (Object)field.getName(clazz));
            ((ProgramFieldOptimizationInfo)fieldOptimizationInfo).setRead();
            this.repeatTrigger.set();
        }
    }

    public static boolean isRead(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).isRead();
    }

    private void markAsWritten(Clazz clazz, Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (!fieldOptimizationInfo.isWritten() && fieldOptimizationInfo instanceof ProgramFieldOptimizationInfo) {
            logger.debug("ReadWriteFieldMarker: marking as written: {}.{}", (Object)clazz.getName(), (Object)field.getName(clazz));
            ((ProgramFieldOptimizationInfo)fieldOptimizationInfo).setWritten();
            this.repeatTrigger.set();
        }
    }

    public static boolean isWritten(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).isWritten();
    }
}

