/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import king.core.AGE;
import king.core.AHE;
import king.core.KIterator;
import king.core.KPoint;
import king.core.Kinemage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterGroup
extends AGE<Kinemage, AHE> {
    public int pm_mask = 0;
    protected boolean indent = false;
    protected boolean forceOnOff = false;

    public MasterGroup(Kinemage kinemage, String string) {
        this.setParent(kinemage);
        this.setName(string);
    }

    @Override
    public void setOn(boolean bl) {
        super.setOn(bl);
        this.touchMaster(bl);
        if (this.pm_mask != 0) {
            this.pmHit(this.pm_mask, bl);
        }
    }

    public void setOnLimited(boolean bl) {
        super.setOn(bl);
    }

    public void setOnForced(boolean bl) {
        this.setOnLimited(bl);
        this.forceOnOff = true;
    }

    private void touchMaster(boolean bl) {
        if (this.parent == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MasterGroup object2 : this.getKinemage().masterList()) {
            if (object2.isOn()) continue;
            arrayList.add(object2.getName());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String string = this.getName();
        block1: for (AGE aGE : KIterator.allNonPoints(this.getKinemage())) {
            Collection<String> collection = aGE.getMasters();
            if (!collection.contains(string) || aGE.isOn() == bl) continue;
            if (bl) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (collection.contains(stringArray[i])) continue block1;
                }
                aGE.setOn(true);
                continue;
            }
            aGE.setOn(false);
        }
    }

    public void syncState() {
        if (this.parent == null) {
            return;
        }
        if (this.forceOnOff) {
            this.setOn(this.isOn());
        } else if (this.isOn()) {
            boolean bl = false;
            String string = this.getName();
            for (AGE aHE : KIterator.allNonPoints(this.getKinemage())) {
                if (aHE.getMasters().contains(string)) {
                    bl |= aHE.isOn();
                }
                if (!bl) continue;
                break;
            }
            if (this.pm_mask != 0) {
                KPoint kPoint;
                Iterator iterator = KIterator.allPoints(this.getKinemage()).iterator();
                while (iterator.hasNext() && !(bl |= (kPoint = (KPoint)iterator.next()).pmWouldHit(this.pm_mask))) {
                }
            }
            this.setOnLimited(bl);
        }
    }

    public int getPmMask() {
        return this.pm_mask;
    }

    public void setPmMask(String string) {
        this.pm_mask = this.getKinemage().toPmBitmask(string, true, false);
    }

    public void pmHit(int n, boolean bl) {
        if (this.parent == null) {
            return;
        }
        int n2 = 0;
        for (MasterGroup aHE : this.getKinemage().masterList()) {
            if (aHE.isOn()) continue;
            n2 |= aHE.pm_mask;
        }
        if (bl && (n & ~n2) == 0) {
            return;
        }
        for (KPoint kPoint : KIterator.allPoints(this.getKinemage())) {
            kPoint.pmHit(n, n2, bl);
        }
    }

    @Override
    public void addMaster(String string) {
        throw new UnsupportedOperationException("Not supported by MasterGroup");
    }

    @Override
    public void removeMaster(String string) {
        throw new UnsupportedOperationException("Not supported by MasterGroup");
    }

    @Override
    public Collection<String> getMasters() {
        throw new UnsupportedOperationException("Not supported by MasterGroup");
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }
}

