/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dangle;

import chiropraxis.dangle.AtomSpec;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.LsqPlane;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.util.ArrayList;
import java.util.Collection;

public abstract class XyzSpec {
    public abstract Tuple3 get(Model var1, ModelState var2, Residue var3);

    public abstract String toString();

    public static class Normal
    extends XyzSpec {
        Collection<XyzSpec> specs = new ArrayList<XyzSpec>();

        public Normal add(XyzSpec xyzSpec) {
            this.specs.add(xyzSpec);
            return this;
        }

        public Tuple3 get(Model model, ModelState modelState, Residue residue) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (XyzSpec xyzSpec : this.specs) {
                Object object;
                if (xyzSpec instanceof AtomSpec) {
                    object = ((AtomSpec)xyzSpec).getAll(model, modelState, residue);
                    if (object.isEmpty()) {
                        return null;
                    }
                    arrayList.addAll((Collection<Object>)object);
                    continue;
                }
                object = xyzSpec.get(model, modelState, residue);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
            }
            if (arrayList.size() < 3) {
                return null;
            }
            return new LsqPlane(arrayList).getNormal();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("normal( ");
            for (XyzSpec xyzSpec : this.specs) {
                stringBuffer.append(xyzSpec);
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class Vector
    extends XyzSpec {
        XyzSpec from;
        XyzSpec to;

        public Vector(XyzSpec xyzSpec, XyzSpec xyzSpec2) {
            this.from = xyzSpec;
            this.to = xyzSpec2;
        }

        public Tuple3 get(Model model, ModelState modelState, Residue residue) {
            Tuple3 tuple3 = this.from.get(model, modelState, residue);
            Tuple3 tuple32 = this.to.get(model, modelState, residue);
            if (tuple3 == null || tuple32 == null) {
                return null;
            }
            return new Triple().likeVector(tuple3, tuple32);
        }

        public String toString() {
            return "vector(" + this.from + ", " + this.to + ")";
        }
    }

    public static class IdealTetrahedral
    extends XyzSpec {
        XyzSpec left;
        XyzSpec right;
        XyzSpec center;
        double length;
        double angle1;
        double angle2;
        double dihedral1;
        double dihedral2;

        public IdealTetrahedral(XyzSpec xyzSpec, XyzSpec xyzSpec2, XyzSpec xyzSpec3, double d, double d2, double d3, double d4, double d5) {
            this.left = xyzSpec;
            this.right = xyzSpec2;
            this.center = xyzSpec3;
            this.length = d;
            this.angle1 = d2;
            this.angle2 = d3;
            this.dihedral1 = d4;
            this.dihedral2 = d5;
        }

        public Tuple3 get(Model model, ModelState modelState, Residue residue) {
            Triple triple = new Triple();
            Builder builder = new Builder();
            Tuple3 tuple3 = this.left.get(model, modelState, residue);
            Tuple3 tuple32 = this.right.get(model, modelState, residue);
            Tuple3 tuple33 = this.center.get(model, modelState, residue);
            if (tuple3 == null || tuple32 == null || tuple33 == null) {
                return null;
            }
            Triple triple2 = builder.construct4(tuple3, tuple32, tuple33, this.length, this.angle1, this.dihedral1);
            Triple triple3 = builder.construct4(tuple32, tuple3, tuple33, this.length, this.angle2, this.dihedral2);
            triple.likeMidpoint(triple2, triple3);
            triple.sub(tuple33).unit().mult(this.length).add(tuple33);
            return triple;
        }

        public String toString() {
            return "idealtet(" + this.left + ", " + this.right + ", " + this.center + ", " + this.length + ", " + this.angle1 + ", " + this.angle2 + ", " + this.dihedral1 + ", " + this.dihedral2 + ")";
        }
    }

    public static class Average
    extends XyzSpec {
        Collection<XyzSpec> specs = new ArrayList<XyzSpec>();

        public Average add(XyzSpec xyzSpec) {
            this.specs.add(xyzSpec);
            return this;
        }

        public Tuple3 get(Model model, ModelState modelState, Residue residue) {
            Triple triple = new Triple();
            for (XyzSpec xyzSpec : this.specs) {
                Tuple3 tuple3 = xyzSpec.get(model, modelState, residue);
                if (tuple3 == null) {
                    return null;
                }
                triple.add(tuple3);
            }
            triple.div(this.specs.size());
            return triple;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("avg( ");
            for (XyzSpec xyzSpec : this.specs) {
                stringBuffer.append(xyzSpec);
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

