/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.forcefield;

import chiropraxis.forcefield.StateManager;
import java.text.DecimalFormat;

public class GradientMinimizer {
    static DecimalFormat df = new DecimalFormat("0.###E0");
    static final double GOLD = (3.0 - Math.sqrt(5.0)) / 2.0;
    static final double GOLDEN = 2.0 - GOLD;
    StateManager system;
    double prevEnergy;
    double[] prevGrad;
    double prevGMag;
    double[] prevPath;
    double prevPMag;
    double currEnergy;
    double[] currGrad;
    double currGMag;
    double[] currPath;
    double currPMag;
    int nSteps = 0;
    int eval = 0;
    boolean hitBottom = false;

    public GradientMinimizer(StateManager stateManager) {
        this.system = stateManager;
        this.currEnergy = this.prevEnergy = this.system.accept();
        this.prevGrad = (double[])this.system.gradient.clone();
        this.prevPath = (double[])this.system.gradient.clone();
        this.currGrad = (double[])this.system.gradient.clone();
        this.currPath = (double[])this.system.gradient.clone();
        this.prevGMag = this.prevPMag = this.getMagnitude(this.system.gradient);
        this.currPMag = this.prevPMag;
        this.currGMag = this.prevPMag;
    }

    public boolean step() {
        if (this.hitBottom) {
            return false;
        }
        this.prevEnergy = this.currEnergy;
        this.prevGMag = this.currGMag;
        this.prevPMag = this.currPMag;
        double[] dArray = this.prevGrad;
        this.prevGrad = this.currGrad;
        this.currGrad = dArray;
        dArray = this.prevPath;
        this.prevPath = this.currPath;
        this.currPath = dArray;
        this.makeSearchVector();
        if (this.currGMag > 0.0 && this.currPMag > 0.0) {
            this.doLineMinimization();
        } else {
            this.hitBottom = true;
        }
        if (this.hitBottom) {
            this.currGMag = 0.0;
        }
        ++this.nSteps;
        return true;
    }

    void makeSearchVector() {
        int n = this.system.gradient.length;
        System.arraycopy(this.system.gradient, 0, this.currGrad, 0, n);
        this.currGMag = this.getMagnitude(this.currGrad);
        if (this.nSteps % n != 0) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += (this.currGrad[n2] - this.prevGrad[n2]) * this.currGrad[n2];
            }
            d /= this.prevGMag * this.prevGMag;
            for (n2 = 0; n2 < n; ++n2) {
                this.currPath[n2] = this.currGrad[n2] + d * this.prevPath[n2];
            }
            this.currPMag = this.getMagnitude(this.currPath);
        } else {
            System.arraycopy(this.currGrad, 0, this.currPath, 0, n);
            this.currPMag = this.currGMag;
        }
    }

    double getMagnitude(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        d = Math.sqrt(d);
        return d;
    }

    void doLineMinimization() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        this.eval = 0;
        double[] dArray = this.currPath;
        double d6 = 0.0;
        double d7 = this.prevEnergy;
        double d8 = 0.01;
        while (true) {
            d5 = this.system.test(-d8, dArray);
            ++this.eval;
            if (d5 < d7) break;
            if (d8 < 1.0E-20) {
                if (this.currGMag / Math.sqrt(dArray.length) < 1.0E-6 * (1.0 + Math.abs(d7)) || this.currGMag == this.prevGMag) {
                    this.hitBottom = true;
                    return;
                }
                this.currEnergy = this.system.accept();
                ++this.eval;
                return;
            }
            d8 /= 8.0;
        }
        double d9 = d8 + (d8 - d6) * GOLDEN;
        double d10 = this.system.test(-d9, dArray);
        ++this.eval;
        while (d10 < d5) {
            d4 = d9 + (d9 - d8) * GOLDEN;
            d3 = this.system.test(-d4, dArray);
            ++this.eval;
            d6 = d8;
            d8 = d9;
            d9 = d4;
            d7 = d5;
            d5 = d10;
            d10 = d3;
        }
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = d2 = d8;
        d4 = d2;
        double d14 = d = d5;
        d3 = d;
        d8 = d9;
        for (int i = 0; i < 100; ++i) {
            double d15;
            double d16 = (d6 + d8) / 2.0;
            double d17 = 1.0E-4 * d4 + 1.0E-10;
            double d18 = 2.0 * d17;
            if (Math.abs(d4 - d16) <= d18 - (d8 - d6) / 2.0) {
                this.currEnergy = this.system.accept(-d4, dArray);
                ++this.eval;
                return;
            }
            if (Math.abs(d12) > d17) {
                double d19 = (d4 - d13) * (d3 - d);
                double d20 = (d4 - d2) * (d3 - d14);
                double d21 = (d4 - d2) * d20 - (d4 - d13) * d19;
                if ((d20 = 2.0 * (d20 - d19)) > 0.0) {
                    d21 = -d21;
                } else {
                    d20 = -d20;
                }
                if (Math.abs(d21) >= Math.abs(0.5 * d20 * d12) || d21 <= d20 * (d6 - d4) || d21 >= d20 * (d8 - d4)) {
                    d12 = d4 >= d16 ? d6 - d4 : d8 - d4;
                    d11 = GOLD * d12;
                } else {
                    d12 = d11;
                    d11 = d21 / d20;
                    d15 = d4 + d11;
                    if (d15 - d6 < d18 || d8 - d15 < d18) {
                        d11 = d16 - d4 >= 0.0 ? d17 : -d17;
                    }
                }
            } else {
                d12 = d4 >= d16 ? d6 - d4 : d8 - d4;
                d11 = GOLD * d12;
            }
            d15 = Math.abs(d11) >= d17 ? d4 + d11 : d4 + (d11 >= 0.0 ? d17 : -d17);
            double d22 = this.system.test(-d15, dArray);
            ++this.eval;
            if (d22 <= d3) {
                if (d15 >= d4) {
                    d6 = d4;
                } else {
                    d8 = d4;
                }
                d2 = d13;
                d13 = d4;
                d4 = d15;
                d = d14;
                d14 = d3;
                d3 = d22;
                continue;
            }
            if (d15 < d4) {
                d6 = d15;
            } else {
                d8 = d15;
            }
            if (d22 <= d14 || d13 == d4) {
                d2 = d13;
                d13 = d15;
                d = d14;
                d14 = d22;
                continue;
            }
            if (!(d22 <= d) && d2 != d4 && d2 != d13) continue;
            d2 = d15;
            d = d22;
        }
        System.err.println("GradientMinimizer.doLineMinimization(): Failed to minimize after 100 loops through Brent!");
        this.currEnergy = this.system.accept(-d4, dArray);
        ++this.eval;
    }

    public double getEnergy() {
        return this.currEnergy;
    }

    public double getDeltaEnergy() {
        return this.currEnergy - this.prevEnergy;
    }

    public double getFracDeltaEnergy() {
        return (this.currEnergy - this.prevEnergy) / this.prevEnergy;
    }

    public double getGradMag() {
        return this.currGMag;
    }

    public double getDeltaGradMag() {
        return this.currGMag - this.prevGMag;
    }

    public int getFuncEvals() {
        return this.eval;
    }
}

