/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.forcefield;

import chiropraxis.forcefield.AngleTerm;
import chiropraxis.forcefield.BondTerm;
import chiropraxis.forcefield.GradientMinimizer;
import chiropraxis.forcefield.NonbondedTerm;
import chiropraxis.forcefield.StateManager;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import driftwood.r3.MutableTuple3;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.ReflectiveRunnable;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.BasicTool;
import king.ToolBox;
import king.core.AGE;
import king.core.AHE;
import king.core.KGroup;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KPoint;
import king.core.KView;
import king.core.Kinemage;
import king.points.VectorPoint;

public class RubberBandTool
extends BasicTool
implements Runnable,
ChangeListener {
    static final KPaint[] colors = new KPaint[]{KPalette.red, KPalette.orange, KPalette.gold, KPalette.yellow, KPalette.lime, KPalette.green, KPalette.sea, KPalette.cyan, KPalette.sky, KPalette.blue, KPalette.purple};
    Triple endpoint0 = new Triple(0.0, 0.0, 0.0);
    Triple endpoint1 = new Triple(10.0, 10.0, 10.0);
    Triple mouseTug = new Triple();
    KList rubberBand;
    StateManager stateMan;
    GradientMinimizer minimizer;
    Collection bondTerms;
    Collection angleTerms;
    Collection nbTerms;
    Collection extraTerms = new HashSet();
    KPoint draggedPoint = null;
    KPoint[] allPoints = null;
    volatile boolean runMin = false;
    TablePane2 toolPane;
    JCheckBox cbRunMinimizer;
    JCheckBox cbUseBonds;
    JCheckBox cbUseAngles;
    JCheckBox cbUseVDW;
    JSlider slBonds;
    JSlider slAngles;
    JSlider slVDW;

    public RubberBandTool(ToolBox toolBox) {
        super(toolBox);
        this.rubberBand = this.makeRandomConf(100);
        this.stateMan = this.makeState(this.rubberBand);
        this.buildGUI();
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setPriority(Thread.currentThread().getPriority() - 1);
        thread.start();
    }

    void buildGUI() {
        this.cbRunMinimizer = new JCheckBox(new ReflectiveAction("Run minimizer", null, this, "onGuiAction"));
        this.cbUseBonds = new JCheckBox(new ReflectiveAction("Use bond terms", null, this, "onGuiAction"));
        this.cbUseAngles = new JCheckBox(new ReflectiveAction("Use angle terms", null, this, "onGuiAction"));
        this.cbUseVDW = new JCheckBox(new ReflectiveAction("Use VDW terms", null, this, "onGuiAction"));
        this.cbRunMinimizer.setSelected(this.runMin);
        this.cbUseBonds.setSelected(this.stateMan.getBondTerms().length != 0);
        this.cbUseAngles.setSelected(this.stateMan.getAngleTerms().length != 0);
        this.cbUseVDW.setSelected(this.stateMan.getNbTerms().length != 0);
        this.slBonds = new JSlider(0, 100, 100);
        this.slBonds.addChangeListener(this);
        this.slAngles = new JSlider(0, 100, 100);
        this.slAngles.addChangeListener(this);
        this.slVDW = new JSlider(0, 100, 100);
        this.slVDW.addChangeListener(this);
        TablePane2 tablePane2 = this.toolPane = new TablePane2();
        tablePane2.addCell(this.cbRunMinimizer).newRow();
        tablePane2.addCell(TablePane2.strut(0, 10)).newRow();
        tablePane2.addCell(this.cbUseBonds).hfill(true).addCell(this.slBonds).newRow();
        tablePane2.addCell(this.cbUseAngles).hfill(true).addCell(this.slAngles).newRow();
        tablePane2.addCell(this.cbUseVDW).hfill(true).addCell(this.slVDW).newRow();
    }

    KList makeRandomConf(int n) {
        KList kList = new KList("vector");
        kList.setName("rubber band");
        kList.setColor(KPalette.pinktint);
        VectorPoint vectorPoint = null;
        for (int i = 0; i < n; ++i) {
            VectorPoint vectorPoint2 = new VectorPoint("pt " + i, vectorPoint);
            vectorPoint2.setXYZ(10.0 * Math.random(), 10.0 * Math.random(), 10.0 * Math.random());
            kList.add((AHE)vectorPoint2);
            vectorPoint = vectorPoint2;
        }
        return kList;
    }

    StateManager makeState(KList kList) {
        int n;
        ArrayList<Triple> arrayList = new ArrayList<Triple>(kList.getChildren());
        arrayList.add(this.endpoint0);
        arrayList.add(this.endpoint1);
        arrayList.add(this.mouseTug);
        int n2 = arrayList.size() - 3;
        this.bondTerms = new ArrayList();
        for (n = 0; n < n2 - 1; ++n) {
            this.bondTerms.add(new BondTerm(n, n + 1, 1.0, 10.0));
        }
        this.angleTerms = new ArrayList();
        for (n = 0; n < n2 - 2; ++n) {
            this.angleTerms.add(new AngleTerm(n, n + 1, n + 2, 120.0, 10.0));
        }
        this.nbTerms = new ArrayList();
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < n2; ++n) {
            nArray[n] = 1;
        }
        while (n < nArray.length) {
            nArray[n] = 0;
            ++n;
        }
        NonbondedTerm nonbondedTerm = new NonbondedTerm(nArray, 6.0, 20);
        nonbondedTerm.setAB(1, 1, 1.0, 2.0);
        this.nbTerms.add(nonbondedTerm);
        StateManager stateManager = new StateManager(arrayList.toArray(new MutableTuple3[arrayList.size()]), n2);
        stateManager.setBondTerms(this.bondTerms);
        stateManager.setAngleTerms(this.angleTerms);
        return stateManager;
    }

    public void start() {
        super.start();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        KGroup kGroup = new KGroup("RubberBand");
        kGroup.setDominant(true);
        KGroup kGroup2 = new KGroup("");
        kGroup.add((AHE)kGroup2);
        this.rubberBand.setParent((AGE)kGroup2);
        kGroup2.add((AHE)this.rubberBand);
        kinemage.add((AHE)kGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            this.minimizer = new GradientMinimizer(this.stateMan);
            long l = System.currentTimeMillis();
            int n = 0;
            boolean bl = false;
            while (this.runMin && !bl) {
                StateManager stateManager = this.stateMan;
                synchronized (stateManager) {
                    bl = !this.minimizer.step();
                    ++n;
                }
                long l2 = System.currentTimeMillis() - l;
                if (l2 <= 33L) continue;
                SwingUtilities.invokeLater(new ReflectiveRunnable(this, "updateKinemage"));
            }
            SwingUtilities.invokeLater(new ReflectiveRunnable(this, "updateKinemage"));
            RubberBandTool rubberBandTool = this;
            synchronized (rubberBandTool) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKinemage() {
        StateManager stateManager = this.stateMan;
        synchronized (stateManager) {
            this.stateMan.getState();
        }
        int n = 0;
        Triple triple = new Triple();
        for (KPoint kPoint : this.rubberBand) {
            triple.add((Tuple3)kPoint);
            ++n;
        }
        triple.mult(1.0 / (double)n);
        for (KPoint kPoint : this.rubberBand) {
            int n2 = (int)Math.min((double)(colors.length - 1), 3.0 * triple.distance((Tuple3)kPoint));
            kPoint.setColor(colors[n2]);
        }
        this.kCanvas.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.onGuiAction(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGuiAction(ActionEvent actionEvent) {
        Object object = this.stateMan;
        synchronized (object) {
            this.stateMan.setBondTerms(this.cbUseBonds.isSelected() ? this.bondTerms : Collections.EMPTY_SET, (double)this.slBonds.getValue() / (double)this.slBonds.getMaximum());
            this.stateMan.setAngleTerms(this.cbUseAngles.isSelected() ? this.angleTerms : Collections.EMPTY_SET, (double)this.slAngles.getValue() / (double)this.slAngles.getMaximum());
            this.stateMan.setNbTerms(this.cbUseVDW.isSelected() ? this.nbTerms : Collections.EMPTY_SET, (double)this.slVDW.getValue() / (double)this.slVDW.getMaximum());
            this.runMin = this.cbRunMinimizer.isSelected();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    public void click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        super.click(n, n2, kPoint, mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drag(int n, int n2, MouseEvent mouseEvent) {
        KView kView = this.kMain.getView();
        if (kView != null && this.draggedPoint != null) {
            Dimension dimension = this.kCanvas.getCanvasSize();
            float[] fArray = kView.getCenter();
            float[] fArray2 = kView.translateRotated(mouseEvent.getX() - dimension.width / 2, dimension.height / 2 - mouseEvent.getY(), 0, Math.min(dimension.width, dimension.height));
            this.mouseTug.setX(fArray[0] + fArray2[0]);
            this.mouseTug.setY(fArray[1] + fArray2[1]);
            this.mouseTug.setZ(fArray[2] + fArray2[2]);
            Object object = this.stateMan;
            synchronized (object) {
                this.stateMan.setPoint(this.stateMan.getIndex(this.mouseTug));
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
        super.drag(n, n2, mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.draggedPoint = this.kMain.getKinemage() != null ? this.kCanvas.getEngine().pickPoint(mouseEvent.getX(), mouseEvent.getY(), this.services.doSuperpick.isSelected()) : null;
        if (this.draggedPoint == null) {
            this.allPoints = null;
        } else {
            Object object;
            this.mouseTug.like((Tuple3)this.draggedPoint);
            int n = this.rubberBand.getChildren().indexOf(this.draggedPoint);
            int n2 = this.stateMan.getIndex(this.mouseTug);
            if (n != -1 && n2 != -1) {
                object = this.stateMan;
                synchronized (object) {
                    this.extraTerms.clear();
                    this.extraTerms.add(new BondTerm(n, n2, 0.0, 30.0));
                    this.stateMan.setExtraTerms(this.extraTerms);
                }
            }
            object = this.kCanvas.getEngine().pickAll3D((double)this.draggedPoint.getDrawX(), (double)this.draggedPoint.getDrawY(), (double)this.draggedPoint.getDrawZ(), this.services.doSuperpick.isSelected(), 0.5);
            this.allPoints = object.toArray(new KPoint[object.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        StateManager stateManager = this.stateMan;
        synchronized (stateManager) {
            this.stateMan.setExtraTerms(Collections.EMPTY_SET);
        }
    }

    protected Container getToolPanel() {
        return this.toolPane;
    }

    public String getHelpAnchor() {
        return null;
    }

    public String toString() {
        return "Rubber band toy";
    }
}

