/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelManager2;
import chiropraxis.kingtools.SidechainSswing;
import chiropraxis.kingtools.SswingResultFrame;
import driftwood.moldb2.Residue;
import driftwood.util.ReflectiveRunnable;
import driftwood.util.SoftLog;
import driftwood.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import king.KingMain;

public class SswingRunner
implements Runnable {
    KingMain kMain;
    ModelManager2 modelman;
    Residue targetRes;
    volatile String cmdTemplate = null;
    final boolean dumpCmdLine;
    final boolean dumpStdErr;
    final boolean dumpStdOut;
    final int helperTimeout;
    double[] angles = new double[5];

    public SswingRunner(KingMain kingMain, ModelManager2 modelManager2, Residue residue, String string) {
        if (kingMain == null || modelManager2 == null || residue == null || string == null) {
            throw new NullPointerException("Null parameters are not allowed.");
        }
        this.kMain = kingMain;
        this.modelman = modelManager2;
        this.targetRes = residue;
        this.cmdTemplate = string;
        this.dumpCmdLine = this.kMain.getPrefs().getBoolean("showHelperCommand");
        this.dumpStdErr = this.kMain.getPrefs().getBoolean("showHelperErrors");
        this.dumpStdOut = this.kMain.getPrefs().getBoolean("showHelperOutput");
        this.helperTimeout = this.kMain.getPrefs().getInt("helperTimeout") * 1000;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        try {
            this.runCommand(this.cmdTemplate);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
        SwingUtilities.invokeLater(new ReflectiveRunnable(this, "cmdFinished"));
    }

    void runCommand(String string) throws IOException {
        String string2;
        if (this.dumpCmdLine) {
            SoftLog.err.println(string);
        }
        String[] stringArray = Strings.tokenizeCommandLine(string);
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
        }
        catch (IOException iOException) {
            System.out.println("can't create process:" + iOException);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("process can't wait:" + interruptedException);
        }
        for (int i = 0; i < this.angles.length; ++i) {
            this.angles[i] = 180.0;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader("forKingsswingOutput.txt"));
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    if (n < 4) {
                        this.angles[n] = Double.valueOf(stringTokenizer.nextToken());
                        ++n;
                        continue;
                    }
                    stringTokenizer.nextToken();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
        }
        bufferedReader.close();
    }

    private static final void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void cmdFinished() {
        try {
            SidechainSswing sidechainSswing = new SidechainSswing(this.kMain.getTopWindow(), this.targetRes, this.modelman);
            sidechainSswing.setAllAngles(this.angles);
            SswingResultFrame sswingResultFrame = new SswingResultFrame("sswingOutput.txt", sidechainSswing);
            sswingResultFrame.showFrame();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public static String findProgram(KingMain kingMain, String string) {
        File file;
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("windows") != -1) {
            string = string + ".exe";
        }
        if ((file = new File(kingMain.getPrefs().jarFileDirectory, string)).exists()) {
            try {
                string = "'" + file.getCanonicalPath() + "'";
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(SoftLog.err);
            }
        }
        return string;
    }
}

