/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;

public class Peptide {
    public Residue cRes;
    public Residue nRes;
    public Triple midpoint;
    public Peptide prev = null;
    public Peptide next = null;
    public Peptide hbondN = null;
    public Peptide hbondO = null;
    public boolean isBeta = false;
    public boolean isParallelN = false;
    public boolean isParallelO = false;
    int chain = -1;
    int index = -1;

    public Peptide(Residue residue, Residue residue2, ModelState modelState) throws AtomException {
        this.nRes = residue2;
        this.cRes = residue;
        if (residue == null) {
            this.midpoint = new Triple(modelState.get(residue2.getAtom(" N  ")));
        } else if (residue2 == null) {
            this.midpoint = new Triple(modelState.get(residue.getAtom(" C  ")));
        } else {
            AtomState atomState = modelState.get(residue2.getAtom(" CA "));
            AtomState atomState2 = modelState.get(residue.getAtom(" CA "));
            this.midpoint = new Triple().likeMidpoint(atomState, atomState2);
        }
    }

    public String toString() {
        return "peptide from " + this.cRes + " to " + this.nRes;
    }
}

