/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import chiropraxis.sc.SidechainAngles2;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.util.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class RotamerSampler {
    String aaType = null;
    File inFile = null;
    Residue res = null;
    boolean allAngles = true;

    public void Main() throws IOException, NumberFormatException {
        String[] stringArray;
        String string;
        Object object2;
        if (this.aaType == null || this.inFile == null) {
            throw new IllegalArgumentException("Not enough command line arguments");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(this.getClass().getResourceAsStream("singleres.pdb"));
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        for (Object object2 : model.getResidues()) {
            if (!this.aaType.equals(((Residue)object2).getName())) continue;
            this.res = object2;
        }
        if (this.res == null) {
            throw new IllegalArgumentException("Couldn't find a residue called '" + this.aaType + "'");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.inFile));
        object2 = new ArrayList();
        int n = -1;
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            stringArray = Strings.explode(string, ':');
            if (n < 0) {
                n = stringArray.length;
            } else if (n != stringArray.length) {
                throw new IllegalArgumentException("Data fields are of different lengths");
            }
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = Double.parseDouble(stringArray[i]);
            }
            ((ArrayList)object2).add(dArray);
        }
        lineNumberReader.close();
        stringArray = new SidechainAngles2();
        int n2 = this.allAngles ? stringArray.countAllAngles(this.res) : stringArray.countChiAngles(this.res);
        double d = 0.0;
        Object object3 = ((ArrayList)object2).iterator();
        while (object3.hasNext()) {
            double[] dArray = (double[])object3.next();
            d = Math.max(d, dArray[n2]);
        }
        object3 = new PdbWriter(System.out);
        ((PdbWriter)object3).setRenumberAtoms(true);
        int n3 = 1;
        Iterator iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            try {
                double[] dArray = (double[])iterator.next();
                Residue residue = new Residue(this.res, " ", "", Integer.toString(n3), " ", this.res.getName());
                ModelState modelState2 = residue.cloneStates(this.res, modelState, new ModelState(modelState));
                modelState2 = this.allAngles ? stringArray.setAllAngles(residue, modelState2, dArray) : stringArray.setChiAngles(residue, modelState2, dArray);
                for (Atom atom : residue.getAtoms()) {
                    double d2 = 999.0 * dArray[n2] / d;
                    if (d2 >= 1000.0) {
                        throw new Error("Logical error in occupancy weighting scheme");
                    }
                    modelState2.get(atom).setOccupancy(d2);
                }
                ((PdbWriter)object3).writeResidues(Collections.singletonList(residue), modelState2);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
            ++n3;
        }
        System.out.flush();
        ((PdbWriter)object3).close();
    }

    public static void main(String[] stringArray) {
        RotamerSampler rotamerSampler = new RotamerSampler();
        try {
            rotamerSampler.parseArguments(stringArray);
            rotamerSampler.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            rotamerSampler.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println();
            System.err.println("*** Error: " + throwable.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("RotamerSampler.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'RotamerSampler.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.sc.RotamerSampler");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.aaType == null) {
            this.aaType = string.toUpperCase();
        } else if (this.inFile == null) {
            this.inFile = new File(string);
        } else {
            throw new IllegalArgumentException("Too many command line arguments");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-chionly")) {
            this.allAngles = false;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

