/*
 * Decompiled with CFR 0.152.
 */
package driftwood.isosurface;

import driftwood.isosurface.CrystalVertexSource;
import driftwood.util.SoftLog;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class XplorVertexSource
extends CrystalVertexSource {
    LineNumberReader in;
    StringBuffer comments = new StringBuffer();
    float[] data = null;
    float[] nvQueue = new float[6];
    int nvCount = 0;
    int nvFront = 0;

    public XplorVertexSource(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public XplorVertexSource(InputStream inputStream, boolean bl) throws IOException {
        inputStream = new BufferedInputStream(inputStream);
        inputStream.mark(10);
        if (inputStream.read() == 31 && inputStream.read() == 139) {
            inputStream.reset();
            inputStream = new GZIPInputStream(inputStream);
        } else {
            inputStream.reset();
        }
        this.in = new LineNumberReader(new InputStreamReader(inputStream));
        super.init(bl);
    }

    void readHeader() throws IOException {
        try {
            String string;
            while ((string = this.in.readLine().trim()).equals("")) {
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            for (int i = 0; i < n; ++i) {
                this.comments.append(this.in.readLine().trim());
            }
            stringTokenizer = new StringTokenizer(this.in.readLine());
            this.aSteps = Integer.parseInt(stringTokenizer.nextToken());
            this.aMin = Integer.parseInt(stringTokenizer.nextToken());
            this.aMax = Integer.parseInt(stringTokenizer.nextToken());
            this.aCount = this.aMax - this.aMin + 1;
            this.bSteps = Integer.parseInt(stringTokenizer.nextToken());
            this.bMin = Integer.parseInt(stringTokenizer.nextToken());
            this.bMax = Integer.parseInt(stringTokenizer.nextToken());
            this.bCount = this.bMax - this.bMin + 1;
            this.cSteps = Integer.parseInt(stringTokenizer.nextToken());
            this.cMin = Integer.parseInt(stringTokenizer.nextToken());
            this.cMax = Integer.parseInt(stringTokenizer.nextToken());
            this.cCount = this.cMax - this.cMin + 1;
            this.aLength = this.nextValue();
            this.bLength = this.nextValue();
            this.cLength = this.nextValue();
            this.alpha = this.nextValue();
            this.beta = this.nextValue();
            this.gamma = this.nextValue();
            if (!this.in.readLine().trim().equalsIgnoreCase("ZYX")) {
                throw new IllegalArgumentException("Bad format -- not a ZYX file");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number: " + numberFormatException.getMessage());
        }
    }

    void readData() throws IOException {
        try {
            this.data = new float[this.aCount * this.bCount * this.cCount];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = this.nextValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number: " + numberFormatException.getMessage());
        }
        double d = this.mean;
        double d2 = this.sigma;
        this.calcMeanAndSigma();
        SoftLog.err.println("calculated  : mean = " + this.mean + "; sigma = " + this.sigma);
        if (Math.abs(this.mean - d) < 0.05 && Math.abs((this.sigma - d2) / this.sigma) < 0.05) {
            this.mean = 0.0;
            this.sigma = d2;
            SoftLog.err.println("close enough: mean = " + this.mean + "; sigma = " + this.sigma);
        }
    }

    float nextValue() throws IOException, NumberFormatException {
        if (this.nvCount <= this.nvFront) {
            String string;
            do {
                if ((string = this.in.readLine()) != null) continue;
                throw new EOFException("Unexpected EOF in X-PLOR file at line " + this.in.getLineNumber());
            } while (string.charAt(2) != '.' || string.length() < 12);
            this.nvFront = 0;
            this.nvCount = 0;
            while (this.nvCount < 6 && 12 * (this.nvCount + 1) <= string.length()) {
                this.nvQueue[this.nvCount] = Float.parseFloat(string.substring(12 * this.nvCount, 12 * (this.nvCount + 1)));
                ++this.nvCount;
            }
            if (this.nvCount <= this.nvFront) {
                throw new IOException("Can't read any more numbers from X-PLOR file (line " + this.in.getLineNumber() + ")");
            }
        }
        return this.nvQueue[this.nvFront++];
    }

    public boolean hasData() {
        return this.data != null;
    }

    void calcMeanAndSigma() {
        int n;
        this.mean = 0.0;
        for (n = 0; n < this.data.length; ++n) {
            this.mean += (double)this.data[n];
        }
        this.mean /= (double)this.data.length;
        this.sigma = 0.0;
        for (n = 0; n < this.data.length; ++n) {
            double d = this.mean - (double)this.data[n];
            this.sigma += d * d;
        }
        this.sigma = Math.sqrt(this.sigma / (double)this.data.length);
    }

    public double getValue(int n, int n2, int n3) {
        return this.data[n + n2 * this.aCount + n3 * this.aCount * this.bCount];
    }
}

