/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import molikin.GuidePoint;
import molikin.ResClassifier;

public class Ribbons {
    public Collection getProteinContigs(Collection collection, ModelState modelState, ResClassifier resClassifier) {
        ArrayList arrayList = new ArrayList();
        ArrayList<Residue> arrayList2 = new ArrayList<Residue>();
        Residue residue = null;
        for (Residue residue2 : collection) {
            if (resClassifier.classify(residue2) != ResClassifier.PROTEIN) continue;
            if (residue == null) {
                if (residue2.getAtom(" CA ") == null) continue;
                arrayList2.add(residue2);
                residue = residue2;
                continue;
            }
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue2.getAtom(" CA "));
                if (atomState2.sqDistance(atomState) < 25.0 && residue2.getChain().equals(residue.getChain())) {
                    arrayList2.add(residue2);
                } else {
                    if (arrayList2.size() > 0) {
                        arrayList.add(arrayList2);
                    }
                    arrayList2 = new ArrayList();
                    arrayList2.add(residue2);
                }
                residue = residue2;
            }
            catch (AtomException atomException) {}
        }
        if (arrayList2.size() > 0) {
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public Collection getNucleicAcidContigs(Collection collection, ModelState modelState, ResClassifier resClassifier) {
        ArrayList arrayList = new ArrayList();
        ArrayList<Residue> arrayList2 = new ArrayList<Residue>();
        Residue residue = null;
        for (Residue residue2 : collection) {
            if (resClassifier.classify(residue2) != ResClassifier.NUCACID) continue;
            if (residue == null) {
                if (residue2.getAtom(" P  ") == null && residue2.getAtom(" O5*") == null && residue2.getAtom(" O5'") == null) continue;
                arrayList2.add(residue2);
                residue = residue2;
                continue;
            }
            try {
                AtomState atomState;
                Atom atom = residue.getAtom(" P  ");
                if (atom == null) {
                    atom = residue.getAtom(" O5*");
                }
                if (atom == null) {
                    atom = residue.getAtom(" O5'");
                }
                AtomState atomState2 = modelState.get(atom);
                Atom atom2 = residue2.getAtom(" P  ");
                if (atom2 == null) {
                    atom2 = residue2.getAtom(" O5*");
                }
                if (atom2 == null) {
                    atom2 = residue2.getAtom(" O5'");
                }
                if ((atomState = modelState.get(atom2)).sqDistance(atomState2) < 100.0 && residue2.getChain().equals(residue.getChain())) {
                    arrayList2.add(residue2);
                } else {
                    if (arrayList2.size() > 0) {
                        arrayList.add(arrayList2);
                        arrayList2 = new ArrayList();
                    }
                    arrayList2.add(residue2);
                }
                residue = residue2;
            }
            catch (AtomException atomException) {}
        }
        if (arrayList2.size() > 0) {
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public GuidePoint[] makeProteinGuidepoints(Collection collection, ModelState modelState) {
        AtomState atomState;
        GuidePoint guidePoint;
        int n;
        Residue[] residueArray = collection.toArray(new Residue[collection.size()]);
        GuidePoint[] guidePointArray = new GuidePoint[residueArray.length + 4 - 1];
        Triple triple = new Triple();
        Triple triple2 = new Triple();
        Triple triple3 = new Triple();
        Triple triple4 = new Triple();
        for (n = 0; n < residueArray.length - 1; ++n) {
            GuidePoint guidePoint2 = new GuidePoint();
            guidePointArray[n + 2] = guidePoint2;
            guidePoint = guidePoint2;
            guidePoint.prevRes = residueArray[n];
            guidePoint.nextRes = residueArray[n + 1];
            try {
                AtomState atomState2;
                AtomState atomState3 = modelState.get(residueArray[n].getAtom(" CA "));
                AtomState atomState4 = modelState.get(residueArray[n + 1].getAtom(" CA "));
                guidePoint.xyz.likeMidpoint(atomState3, atomState4);
                if (1 <= n && n <= residueArray.length - 3) {
                    AtomState atomState5;
                    atomState2 = modelState.get(residueArray[n - 1].getAtom(" CA "));
                    double d = atomState2.distance(atomState5 = modelState.get(residueArray[n + 2].getAtom(" CA ")));
                    if (d < 7.0) {
                        guidePoint.widthFactor = guidePoint.offsetFactor = Math.min(1.5, 7.0 - d) / 1.5;
                        triple3.likeMidpoint(atomState2, atomState5);
                        triple4.likeVector(triple3, guidePoint.xyz).unit();
                        guidePoint.xyz.addMult(1.5 * guidePoint.offsetFactor, triple4);
                    } else if (d > 9.0) {
                        guidePoint.widthFactor = Math.min(1.5, d - 9.0) / 1.5;
                        guidePoint.offsetFactor = 0.0;
                    } else {
                        guidePoint.offsetFactor = 0.0;
                        guidePoint.widthFactor = 0.0;
                    }
                }
                atomState2 = modelState.get(residueArray[n].getAtom(" O  "));
                triple.likeVector(atomState3, atomState4);
                triple2.likeVector(atomState3, atomState2);
                guidePoint.cvec.likeCross(triple, triple2).unit();
                guidePoint.dvec.likeCross(guidePoint.cvec, triple).unit();
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        n = 2;
        while (n < guidePointArray.length - 2) {
            int n2;
            if (guidePointArray[n].widthFactor == 0.0) {
                ++n;
                continue;
            }
            int n3 = n;
            for (n2 = n + 1; n2 < guidePointArray.length - 2 && guidePointArray[n2].widthFactor != 0.0; ++n2) {
            }
            if (n2 - n3 < 3) {
                for (int i = n3; i < n2; ++i) {
                    guidePointArray[i].widthFactor = 0.0;
                }
            }
            n = n2;
        }
        try {
            guidePoint = new GuidePoint();
            atomState = modelState.get(residueArray[0].getAtom(" CA "));
            guidePoint.xyz.like(atomState);
            guidePoint.cvec.like(guidePointArray[2].cvec);
            guidePoint.dvec.like(guidePointArray[2].dvec);
            guidePoint.offsetFactor = guidePointArray[2].offsetFactor;
            guidePoint.widthFactor = guidePointArray[2].widthFactor;
            guidePoint.prevRes = guidePoint.nextRes = residueArray[0];
            guidePointArray[0] = guidePointArray[1] = guidePoint;
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            guidePoint = new GuidePoint();
            atomState = modelState.get(residueArray[residueArray.length - 1].getAtom(" CA "));
            guidePoint.xyz.like(atomState);
            guidePoint.cvec.like(guidePointArray[guidePointArray.length - 3].cvec);
            guidePoint.dvec.like(guidePointArray[guidePointArray.length - 3].dvec);
            guidePoint.offsetFactor = guidePointArray[guidePointArray.length - 3].offsetFactor;
            guidePoint.widthFactor = guidePointArray[guidePointArray.length - 3].widthFactor;
            guidePoint.prevRes = guidePoint.nextRes = residueArray[residueArray.length - 1];
            GuidePoint guidePoint3 = guidePoint;
            guidePointArray[guidePointArray.length - 2] = guidePoint3;
            guidePointArray[guidePointArray.length - 1] = guidePoint3;
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        return guidePointArray;
    }

    public GuidePoint[] makeNucleicAcidGuidepoints(Collection collection, ModelState modelState) {
        Atom atom;
        Object object;
        GuidePoint guidePoint;
        Residue[] residueArray = collection.toArray(new Residue[collection.size()]);
        GuidePoint[] guidePointArray = new GuidePoint[residueArray.length + 4 - 1];
        Triple triple = new Triple();
        Triple triple2 = new Triple();
        Triple triple3 = new Triple();
        Triple triple4 = new Triple();
        for (int i = 0; i < residueArray.length - 1; ++i) {
            GuidePoint guidePoint2 = new GuidePoint();
            guidePointArray[i + 2] = guidePoint2;
            guidePoint = guidePoint2;
            guidePoint.prevRes = residueArray[i];
            guidePoint.nextRes = residueArray[i + 1];
            try {
                AtomState atomState;
                Atom atom2;
                AtomState atomState2;
                Atom atom3;
                object = residueArray[i].getAtom(" P  ");
                if (object == null) {
                    object = residueArray[i].getAtom(" O5*");
                }
                if (object == null) {
                    object = residueArray[i].getAtom(" O5'");
                }
                AtomState atomState3 = modelState.get((Atom)object);
                Atom atom4 = residueArray[i + 1].getAtom(" P  ");
                if (atom4 == null) {
                    atom4 = residueArray[i + 1].getAtom(" O5*");
                }
                if (atom4 == null) {
                    atom4 = residueArray[i + 1].getAtom(" O5'");
                }
                AtomState atomState4 = modelState.get(atom4);
                guidePoint.xyz.likeMidpoint(atomState3, atomState4);
                if (1 <= i && i <= residueArray.length - 3) {
                    atom3 = residueArray[i - 1].getAtom(" P  ");
                    if (atom3 == null) {
                        atom3 = residueArray[i - 1].getAtom(" O5*");
                    }
                    if (atom3 == null) {
                        atom3 = residueArray[i - 1].getAtom(" O5'");
                    }
                    atomState2 = modelState.get(atom3);
                    atom2 = residueArray[i + 2].getAtom(" P  ");
                    if (atom2 == null) {
                        atom2 = residueArray[i + 2].getAtom(" O5*");
                    }
                    if (atom2 == null) {
                        atom2 = residueArray[i + 2].getAtom(" O5'");
                    }
                    atomState = modelState.get(atom2);
                    double d = guidePoint.xyz.distance(atomState2);
                    double d2 = guidePoint.xyz.distance(atomState);
                    boolean bl = false;
                    double d3 = d;
                    double d4 = 0.0;
                    guidePoint.offsetFactor = 0.0;
                    guidePoint.widthFactor = 0.0;
                    if (d <= 9.0 || d2 <= 9.0) {
                        bl = true;
                        d3 = Math.min(d, d2);
                        Atom atom5 = residueArray[i].getAtom(" C4*");
                        if (atom5 == null) {
                            atom5 = residueArray[i].getAtom(" C4'");
                        }
                        AtomState atomState5 = modelState.get(atom5);
                        d4 = guidePoint.xyz.distance(atomState5) + 1.0;
                        guidePoint.offsetFactor = (9.0 - d3) / 2.0;
                        if (guidePoint.offsetFactor > 1.0) {
                            guidePoint.offsetFactor = 1.0;
                        }
                        triple4.likeVector(guidePoint.xyz, atomState5).unit();
                        guidePoint.xyz.addMult(d4 * guidePoint.offsetFactor, triple4);
                    }
                }
                if ((atom3 = residueArray[i].getAtom(" C3*")) == null) {
                    atom3 = residueArray[i].getAtom(" C3'");
                }
                atomState2 = modelState.get(atom3);
                atom2 = residueArray[i].getAtom(" C1*");
                if (atom2 == null) {
                    atom2 = residueArray[i].getAtom(" C1'");
                }
                atomState = modelState.get(atom2);
                triple.likeVector(atomState3, atomState4);
                triple2.likeVector(atomState2, atomState);
                guidePoint.cvec.likeCross(triple, triple2).unit();
                guidePoint.dvec.likeCross(guidePoint.cvec, triple).unit();
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        try {
            guidePoint = new GuidePoint();
            atom = residueArray[0].getAtom(" P  ");
            if (atom == null) {
                atom = residueArray[0].getAtom(" O5*");
            }
            if (atom == null) {
                atom = residueArray[0].getAtom(" O5'");
            }
            object = modelState.get(atom);
            guidePoint.xyz.like((Tuple3)object);
            guidePoint.cvec.like(guidePointArray[2].cvec);
            guidePoint.dvec.like(guidePointArray[2].dvec);
            guidePoint.offsetFactor = guidePointArray[2].offsetFactor;
            guidePoint.widthFactor = guidePointArray[2].widthFactor;
            guidePoint.prevRes = guidePoint.nextRes = residueArray[0];
            guidePointArray[0] = guidePointArray[1] = guidePoint;
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            guidePoint = new GuidePoint();
            atom = residueArray[residueArray.length - 1].getAtom(" C3*");
            if (atom == null) {
                atom = residueArray[residueArray.length - 1].getAtom(" C3'");
            }
            if (atom == null) {
                atom = residueArray[residueArray.length - 1].getAtom(" P  ");
            }
            if (atom == null) {
                atom = residueArray[residueArray.length - 1].getAtom(" O5'");
            }
            if (atom == null) {
                atom = residueArray[residueArray.length - 1].getAtom(" O5*");
            }
            object = modelState.get(atom);
            guidePoint.xyz.like((Tuple3)object);
            guidePoint.cvec.like(guidePointArray[guidePointArray.length - 3].cvec);
            guidePoint.dvec.like(guidePointArray[guidePointArray.length - 3].dvec);
            guidePoint.offsetFactor = guidePointArray[guidePointArray.length - 3].offsetFactor;
            guidePoint.widthFactor = guidePointArray[guidePointArray.length - 3].widthFactor;
            guidePoint.prevRes = guidePoint.nextRes = residueArray[residueArray.length - 1];
            GuidePoint guidePoint3 = guidePoint;
            guidePointArray[guidePointArray.length - 2] = guidePoint3;
            guidePointArray[guidePointArray.length - 1] = guidePoint3;
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        return guidePointArray;
    }

    public void swapEdgeAndFace(GuidePoint[] guidePointArray) {
        for (int i = 0; i < guidePointArray.length; ++i) {
            Triple triple = guidePointArray[i].cvec;
            guidePointArray[i].cvec = guidePointArray[i].dvec;
            guidePointArray[i].dvec = triple;
        }
    }

    public void untwistRibbon(GuidePoint[] guidePointArray) {
        for (int i = 1; i < guidePointArray.length; ++i) {
            if (!(guidePointArray[i].dvec.dot(guidePointArray[i - 1].dvec) < 0.0)) continue;
            guidePointArray[i].dvec.neg();
        }
    }
}

